/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.intervall;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.swing.treetable.TreeTableModel;
import se.prediktera.map.data.DataGroupLayer;
import se.prediktera.map.data.DescriptionLayer;
import se.prediktera.map.data.intervall.IntervallTable;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractLayer;
import se.prediktera.map.main.layer.AbstractLayerPanel;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class IntervallTableSettings
extends AbstractLayerPanel {
    private static void addLayersFromDataGroup(Description description, DefaultMutableTreeNode defaultMutableTreeNode, AbstractDataMatrix abstractDataMatrix) {
        DataGroupLayer dataGroupLayer = new DataGroupLayer(description, abstractDataMatrix.isObsN());
        defaultMutableTreeNode.add(dataGroupLayer.getLayerNode());
        ((AbstractLayer)defaultMutableTreeNode.getUserObject()).addTreeNode(dataGroupLayer);
        for (int i = 0; i < description.getColumnCount(); ++i) {
            DescriptionLayer descriptionLayer = new DescriptionLayer(description, i, abstractDataMatrix);
            Color color = description.isObs() ? CellIdentifierModel.getColorByType(1) : CellIdentifierModel.getColorByType(0);
            descriptionLayer.setFixedColor(color);
            dataGroupLayer.getLayerNode().add(descriptionLayer.getLayerNode());
            dataGroupLayer.addTreeNode(descriptionLayer);
        }
    }

    public IntervallTableSettings(IntervallTable intervallTable, AbstractDataInfo[] abstractDataInfoArray) {
        super(intervallTable, new String[]{"V", "Name"}, false);
        this.jbInit();
        this.addLayersFromDataInfo(abstractDataInfoArray[0], intervallTable.getMatrix());
        this.addLayersFromDataInfo(abstractDataInfoArray[1], intervallTable.getMatrix());
        this.updateTable();
    }

    public IntervallTableSettings(IntervallTable intervallTable, RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(intervallTable, new String[]{"V", "Name"}, false, randomInputStream, mapProperty);
        this.jbInit();
    }

    @Override
    public AbstractLayer addLayer(boolean bl) {
        return null;
    }

    public DataGroupLayer getBaseLayer(int n) {
        if (n < 0 || n >= this.rootNode.getChildCount()) {
            return null;
        }
        Object object = ((DefaultMutableTreeNode)this.rootNode.getChildAt(n)).getUserObject();
        if (object instanceof DataGroupLayer) {
            return (DataGroupLayer)object;
        }
        return null;
    }

    @Override
    public void layerSelected(AbstractLayer abstractLayer) {
    }

    @Override
    public void layerVisibleChanged(AbstractLayer abstractLayer) {
    }

    public void setCellBackground(Component component, int n) {
        component.setBackground(CellIdentifierModel.getColorByType(n));
    }

    @Override
    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        for (int i = 0; i < this.window.getTreeNodeCount(); ++i) {
            if (!(this.window.getTreeNodeAt(i) instanceof AbstractLayer)) continue;
            ((AbstractLayer)this.window.getTreeNodeAt(i)).setCreated(abstractWindow_GUI, bl);
        }
    }

    @Override
    protected void enableButtons(boolean bl) {
        this.newLayer.setEnabled(false);
        this.removeLayer.setEnabled(false);
        this.renameLayer.setEnabled(false);
        this.moveLayerUp.setEnabled(false);
        this.moveLayerDown.setEnabled(false);
    }

    @Override
    protected Class[] getCTypes() {
        return new Class[]{AbstractLayerPanel.VisibleTableCellRenderer.class, TreeTableModel.class};
    }

    @Override
    protected void repaintLayers() {
    }

    private void addLayersFromDataInfo(AbstractDataInfo abstractDataInfo, AbstractDataMatrix abstractDataMatrix) {
        DataGroupLayer dataGroupLayer = new DataGroupLayer(abstractDataInfo, abstractDataMatrix.isObsN());
        this.rootNode.add(dataGroupLayer.getLayerNode());
        this.window.addTreeNode(dataGroupLayer);
        Description description = (Description)abstractDataInfo.getGroupColumnByType(0);
        IntervallTableSettings.addLayersFromDataGroup(description, dataGroupLayer.getLayerNode(), abstractDataMatrix);
    }

    private void jbInit() {
        this.layerTreeTable.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.layerTreeTable.getColumnModel().getColumn(0).setMaxWidth(25);
        this.layerTreeTable.getColumnModel().getColumn(1).setPreferredWidth(80);
    }
}

