/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.modeltable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import se.prediktera.map.data.modeltable.ModelTable;
import se.prediktera.map.data.modeltable.ModelTableInterface;
import se.prediktera.map.model.ModelListener;
import se.prediktera.map.simpletableeditor.sortable.ExtendSortableScrollTable;

public class InnerModelTable
extends ExtendSortableScrollTable
implements ModelListener {
    private final ModelTable modelTable;
    private boolean interactive = false;

    public InnerModelTable(ModelTable modelTable, JScrollPane jScrollPane, ModelTableInterface modelTableInterface) {
        super(jScrollPane, true, false, true, true);
        this.modelTable = modelTable;
        this.setAutoResizeMode(0);
        this.setColumnSelectionAllowed(false);
        this.setDefaultRenderer(Object.class, new Renderer());
        this.setModelTableInterface(modelTableInterface);
        SelectionListener selectionListener = new SelectionListener();
        this.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public void beginInteraction() {
        this.interactive = true;
    }

    public void endInteraction() {
        this.interactive = false;
    }

    @Override
    public void modelUpdated() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableStructureChanged();
        }
        if (this.rowHeader != null) {
            this.rowHeader.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    public void setModelTableInterface(ModelTableInterface modelTableInterface) {
        this.setModel(modelTableInterface.createTableModel());
        modelTableInterface.addModelListener(this);
    }

    private class Renderer
    extends JLabel
    implements TableCellRenderer {
        private final Font bold;
        private final Font plain;

        public Renderer() {
            this.setOpaque(true);
            Font font = this.getFont();
            this.bold = new Font(font.getName(), 1, font.getSize());
            this.plain = new Font(font.getName(), 0, font.getSize());
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(this.plain);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
                if (jTable.getValueAt(n, 0) != "") {
                    this.setFont(this.bold);
                    this.setBackground(Color.lightGray);
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            this.setText(String.valueOf(object));
            return this;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (InnerModelTable.this.modelTable != null && InnerModelTable.this.modelTable.getProject_GUI() != null && !listSelectionEvent.getValueIsAdjusting() && !InnerModelTable.this.interactive) {
                InnerModelTable.this.modelTable.getProject_GUI().doInteraction(InnerModelTable.this.modelTable);
            }
        }
    }
}

