/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.modeltable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.BooleanArray;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.modeltable.AbstractTModel;
import se.prediktera.map.data.modeltable.InnerModelTable;
import se.prediktera.map.data.modeltable.ModelTableInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindowProperties;

public class ModelTable
extends AbstractTable {
    private InnerModelTable innerTable = null;
    private boolean interacting = false;

    public ModelTable(DataInit dataInit) {
        super(dataInit);
        this.init();
    }

    public ModelTable(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.init();
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        super.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
        return this.innerTable.addToPopup(project_GUI, dataTreeInterface, point, jPopupMenu, bl);
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        if (!this.interacting) {
            this.innerTable.beginInteraction();
            AbstractTModel abstractTModel = (AbstractTModel)this.innerTable.getModel();
            boolean bl = abstractTModel.doInteraction(this, interactionInterface, this.innerTable.getSelectionModel());
            this.innerTable.endInteraction();
            return bl;
        }
        return false;
    }

    @Override
    public void finishInteraction() {
    }

    @Override
    public String getGUI_Name() {
        if (this.dti != null) {
            return "Table (" + String.valueOf(this.dti) + ")";
        }
        return "Table";
    }

    @Override
    public String getInformation() {
        return this.dti.getInformation();
    }

    public BooleanArray getInteractionArray(boolean bl) {
        return null;
    }

    public InteractionArray getInteractionArray(int n, int n2, boolean bl) {
        if (bl) {
            return this.project_GUI.getInteractionArray(this.dti, n, this.innerTable.getRowCount(), n2);
        }
        return this.project_GUI.getInteractionArray(n, n2);
    }

    public ModelTableInterface getModelTable() {
        return (ModelTableInterface)((Object)this.dti);
    }

    @Override
    public byte getTreeType() {
        return 4;
    }

    @Override
    public boolean hasInteractivity() {
        return false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n = this.innerTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.innerTable.columnAtPoint(mouseEvent.getPoint());
            if (!this.innerTable.isRowSelected(n) || !this.innerTable.isColumnSelected(n2)) {
                this.innerTable.setRowSelectionInterval(n, n);
                this.innerTable.setColumnSelectionInterval(n2, n2);
            }
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        this.dti = dataTreeEvent.getReplaceDataTreeInterface();
        this.innerTable.setModelTableInterface((ModelTableInterface)((Object)this.dti));
    }

    @Override
    public void prepareInteraction() {
        this.interacting = true;
        AbstractTModel abstractTModel = (AbstractTModel)this.innerTable.getModel();
        abstractTModel.prepareInteraction(this, this.innerTable.getSelectedRows());
        this.interacting = false;
    }

    @Override
    public byte SendGlobalMessage(byte by, byte by2) {
        if (by == 0 && this.dti.isCleaned()) {
            this.cleanUp();
            return 2;
        }
        return 0;
    }

    @Override
    protected void cleanUpChild() {
        if (this.dti != null && this.innerTable != null) {
            ((ModelTableInterface)((Object)this.dti)).removeModelListener(this.innerTable);
            this.innerTable = null;
        }
        super.cleanUpChild();
    }

    @Override
    protected AbstractWindowProperties createProperties() {
        return null;
    }

    @Override
    protected String getDefaultTitle() {
        return "Model Table";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.innerTable = new InnerModelTable(this, jScrollPane, (ModelTableInterface)((Object)this.dti));
        jScrollPane.setViewportView(this.innerTable);
        this.add((Component)jScrollPane, "Center");
        this.innerTable.addMouseListener(this);
    }
}

