/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.data.SimpleTable;

public class PropertyPanel
extends JPanel {
    private final JCheckBox showGrids = new JCheckBox("Show grids");
    private final JTextFieldButtonUppDown spinnerWidth = new JTextFieldButtonUppDown(0.0, 10000.0, false);
    private final JTextFieldButtonUppDown spinnerHeight = new JTextFieldButtonUppDown(0.0, 10000.0, false);
    private final JTextFieldButtonUppDown spinnerSize = new JTextFieldButtonUppDown(1.0, 100.0, false);
    private boolean haschanged = false;

    public PropertyPanel(SimpleTable simpleTable) {
        this.setLayout(new BoxLayout(this, 1));
        if (simpleTable != null) {
            this.spinnerHeight.setNumber(simpleTable.getRowHeight());
            this.spinnerWidth.setNumber(simpleTable.getColumnCount() > 0 ? (double)simpleTable.getColumnModel().getColumn(0).getPreferredWidth() : 45.0);
            this.spinnerSize.setNumber(simpleTable.getFont().getSize());
            this.showGrids.setSelected(simpleTable.getShowGrid());
        }
        JPanel jPanel = new JPanel(new GridLayout(3, 2, 5, 5));
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Dimensions"));
        this.showGrids.setFont(new Font("Dialog", 0, 10));
        this.showGrids.setAlignmentX(0.0f);
        jPanel.setAlignmentX(0.0f);
        this.spinnerWidth.setPreferredSize(new Dimension(100, 18));
        this.spinnerWidth.setToolTipText("");
        this.spinnerHeight.setPreferredSize(new Dimension(100, 18));
        this.spinnerSize.setPreferredSize(new Dimension(100, 18));
        jPanel.setMaximumSize(new Dimension(1000, this.spinnerWidth.getHeight() * 3));
        this.add((Component)jPanel, null);
        jPanel.add(new JLabel("Cell Width"));
        jPanel.add(this.spinnerWidth);
        jPanel.add(new JLabel("Cell Height"));
        jPanel.add(this.spinnerHeight);
        jPanel.add(new JLabel("Text Size"));
        jPanel.add(this.spinnerSize);
        this.add((Component)this.showGrids, null);
        this.add(Box.createVerticalGlue());
        JValidateNumberField.NumberChangedInterface numberChangedInterface = (n, d) -> {
            this.haschanged = true;
        };
        this.spinnerWidth.setNumberChangedInterface(numberChangedInterface);
        this.spinnerHeight.setNumberChangedInterface(numberChangedInterface);
        this.spinnerSize.setNumberChangedInterface(numberChangedInterface);
    }

    public void applyChanges(SimpleTable simpleTable) {
        if (simpleTable != null) {
            if (this.haschanged) {
                simpleTable.setRowHeight(this.getCellHeight());
                simpleTable.setCellWidth(this.getCellWidth());
                simpleTable.setFont(new Font(simpleTable.getFont().getFontName(), simpleTable.getFont().getStyle(), this.getTextSize()));
                this.haschanged = false;
            }
            simpleTable.setShowGrid(this.isShowGrids());
        }
    }

    public int getCellWidth() {
        return (int)this.spinnerWidth.getNumber();
    }

    private int getCellHeight() {
        return (int)this.spinnerHeight.getNumber();
    }

    private int getTextSize() {
        return (int)this.spinnerSize.getNumber();
    }

    private boolean isShowGrids() {
        return this.showGrids.isSelected();
    }
}

