/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.settings;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.data.TableLayer;
import se.prediktera.map.data.settings.color.CellScalePanel;
import se.prediktera.map.data.settings.color.DataColorAdvancedFrame;
import se.prediktera.map.data.settings.color.DataContinuousColor;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.layer.AbstractSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Color.FixedColorChangedInterface;
import se.prediktera.map.plot.axisplot.settings.Color.ScalePanel;

public class DataComboBoxColor
extends AbstractSettingsBox
implements FixedColorChangedInterface {
    private CellScalePanel colorPanel = new CellScalePanel((ContinuousColorInterface)new DataContinuousColor("Fixed", Color.red), this);
    private TableLayer layer;

    public DataComboBoxColor(AbstractDataMatrix abstractDataMatrix, TableLayer tableLayer) {
        super(abstractDataMatrix, 0);
        this.layer = tableLayer;
    }

    @Override
    public void Calculate() {
        this.fullRepaint();
    }

    @Override
    public void FixedColorChanged(Color color) {
        this.fullRepaint();
    }

    public Color getFixedColor() {
        return this.colorPanel.getFixedColor();
    }

    public ScalePanel getScalePanel() {
        return this.colorPanel;
    }

    @Override
    public byte getType() {
        return 3;
    }

    @Override
    public void LoadProperty(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super.LoadProperty(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("col")) {
            this.colorPanel.setFixedColor(new Color(mapProperty.getLVInt(), true));
        }
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        super.SaveProperty(randomOutputStream);
        randomOutputStream.writePropertyInt("col", this.colorPanel.getFixedColor().getRGB());
    }

    public void setCellBackground(Component component, Object object, boolean bl) {
        if (this.curType == 1 || this.curType < 0) {
            if (bl) {
                component.setBackground(this.colorPanel.getFixedSelectedColor());
            } else {
                component.setBackground(this.colorPanel.getFixedColor());
            }
        }
    }

    public void setFixedColor(Color color) {
        this.colorPanel.setFixedColor(color);
    }

    @Override
    public void setSelected(int n, int n2, boolean bl) {
        this.curType = n;
        this.setSelectedChild();
    }

    @Override
    public void updateCalculation(boolean bl) {
        this.Calculate();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.colorPanel = null;
        this.layer = null;
    }

    @Override
    protected AbstractAdvancedFrame createAdvanceSettings(MapProperty mapProperty) throws IOException {
        return new DataColorAdvancedFrame("Advanced Color Settings", this);
    }

    @Override
    protected void fullRepaint() {
        if (this.layer != null && this.layer.getTable() != null) {
            this.layer.getTable().repaint();
        }
    }

    @Override
    protected void matrixEventFinished(int n) {
    }

    @Override
    protected boolean setComboItems(boolean bl, boolean bl2, boolean bl3) {
        return false;
    }

    @Override
    protected void setSelectedChild() {
        this.Calculate();
    }
}

