/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.settings.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.JColorChooser;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.data.settings.DataComboBoxColor;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.layer.AbstractAdvancedFrame;
import se.prediktera.map.main.layer.AbstractSettingsBox;
import se.prediktera.map.plot.axisplot.settings.AbstractSettingsPanel;
import se.prediktera.map.plot.axisplot.settings.Color.AbstractColorInterface;
import se.prediktera.map.plot.axisplot.settings.Color.ColorChooserPanel;
import se.prediktera.map.plot.axisplot.settings.Color.PerfectSpread;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class DataColorAdvancedFrame
extends AbstractAdvancedFrame {
    private FixedColorPanel fixedColorCard = null;

    public DataColorAdvancedFrame(String string, AbstractSettingsBox abstractSettingsBox) {
        super(string, abstractSettingsBox);
        Color color = PerfectSpread.generateColor(0);
        this.settingsTabbed.addTab("Color", this.settingsCardPanel);
        if (abstractSettingsBox.hasMainType(1)) {
            this.fixedColorCard = new FixedColorPanel(color);
            this.settingsCardPanel.addRadioButton("Fixed Color", 1, this.fixedColorCard);
        }
        this.pack();
        super.setLocationRelativeTo(null);
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
    }

    @Override
    public void SyncronizeComboBox(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        if (1 == n) {
            DataComboBoxColor dataComboBoxColor = (DataComboBoxColor)this.settingsBox;
            this.fixedColorCard.setFixedColor(dataComboBoxColor.getFixedColor());
        }
        this.settingsCardPanel.setSelected(n);
    }

    @Override
    protected void applyChanges() {
        int n = this.settingsCardPanel.getSelected();
        if (n == 1) {
            DataComboBoxColor dataComboBoxColor = (DataComboBoxColor)this.settingsBox;
            dataComboBoxColor.setFixedColor(this.fixedColorCard.getFixedColor());
        }
        this.settingsBox.setSelected(n, 0);
    }

    private class FixedColorPanel
    extends AbstractSettingsPanel
    implements AbstractColorInterface {
        private JColorChooser colorChooser;
        private final PlotContinuousColor continuesColor;

        public FixedColorPanel(Color color) {
            this.continuesColor = new PlotContinuousColor("Fixed", color);
            this.init();
        }

        @Override
        public ContinuousColorInterface getContinuesColor() {
            if (this.colorChooser != null) {
                this.continuesColor.setColor(0, this.colorChooser.getColor());
            }
            return this.continuesColor;
        }

        @Override
        public double[] getContinuesMinMax() {
            return null;
        }

        public Color getFixedColor() {
            if (this.colorChooser != null) {
                return this.colorChooser.getColor();
            }
            return Color.white;
        }

        public void Save(RandomOutputStream randomOutputStream) throws IOException {
            this.continuesColor.Save(randomOutputStream);
        }

        public void setFixedColor(Color color) {
            if (this.colorChooser != null) {
                this.colorChooser.setColor(color);
            }
        }

        private void init() {
            if (UpdateHelper.Product.isRunningProductEvince()) {
                this.colorChooser = new JColorChooser();
                AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.colorChooser.getChooserPanels();
                AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = new AbstractColorChooserPanel[abstractColorChooserPanelArray.length];
                for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
                    abstractColorChooserPanelArray2[i] = abstractColorChooserPanelArray[i].toString().startsWith("javax.swing.colorchooser.DefaultSwatchChooserPanel") ? new ColorChooserPanel() : abstractColorChooserPanelArray[i];
                }
                this.colorChooser.setChooserPanels(abstractColorChooserPanelArray2);
                if (this.continuesColor.getNrColors() > 0) {
                    this.colorChooser.setColor(this.continuesColor.getColor(0));
                }
                this.removeScrolling();
                this.setPreferredSize(new Dimension(380, 400));
                this.centerPanel.add((Component)this.colorChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 6, 6), 0, 0));
            }
        }
    }
}

