/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.data.settings.color;

import java.awt.Color;
import java.io.IOException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.plot.axisplot.settings.SettingsBoxInterface;

public class DataContinuousColor
implements ContinuousColorInterface,
SettingsBoxInterface {
    private int classIndex;
    private Color[] colorArray = null;
    private Color[] selectedColorArray = null;
    private String name;
    private Color selectionColor;
    private boolean isReversed = false;
    private int noVisibleColors = -1;

    public DataContinuousColor(MapProperty mapProperty) {
        this.name = mapProperty.hasProperty("cname") ? mapProperty.getLVStringUTF() : "NoName";
        if (mapProperty.hasProperty("csize")) {
            int n;
            int n2 = mapProperty.getLVInt();
            this.colorArray = new Color[n2];
            this.selectedColorArray = new Color[n2];
            for (n = 0; n < n2; ++n) {
                if (!mapProperty.hasProperty("cc" + n)) continue;
                this.colorArray[n] = new Color(mapProperty.getLVInt(), true);
            }
            for (n = 0; n < n2; ++n) {
                if (!mapProperty.hasProperty("scc" + n)) continue;
                this.selectedColorArray[n] = new Color(mapProperty.getLVInt(), true);
            }
        } else {
            this.colorArray = new Color[]{Color.red};
            this.selectedColorArray = new Color[]{Color.red.darker()};
        }
        this.isReversed = mapProperty.getPropertyBoolean("reversed");
    }

    public DataContinuousColor(String string, Color color) {
        this.name = string;
        this.colorArray = new Color[]{color};
        this.selectedColorArray = new Color[]{color.darker()};
    }

    private DataContinuousColor(String string, int n) {
        this.name = string;
        this.colorArray = new Color[n];
        this.selectedColorArray = new Color[n];
    }

    @Override
    public ContinuousColorInterface cloneColors() {
        DataContinuousColor dataContinuousColor = new DataContinuousColor(this.toString(), this.getNrColors());
        for (int i = 0; i < this.getNrColors(); ++i) {
            dataContinuousColor.setColor(i, this.getColor(i));
        }
        return dataContinuousColor;
    }

    @Override
    public int getClassIndex() {
        return this.classIndex;
    }

    @Override
    public Color getColor(int n) {
        if (n >= this.colorArray.length) {
            n = this.colorArray.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return this.colorArray[n];
    }

    @Override
    public int getNoVisibleColors() {
        return this.noVisibleColors;
    }

    @Override
    public int getNrColors() {
        return this.colorArray.length;
    }

    @Override
    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getSelectionColor(int n) {
        if (n >= this.colorArray.length) {
            n = this.colorArray.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        return this.selectedColorArray[n];
    }

    @Override
    public int getType() {
        if (this.name.equalsIgnoreCase("Fixed")) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    public void reverseColors() {
        this.isReversed = !this.isReversed;
        int n = 0;
        for (int i = this.colorArray.length - 1; n < i; ++n, --i) {
            Color color = this.colorArray[n];
            this.colorArray[n] = this.colorArray[i];
            this.colorArray[i] = color;
            color = this.selectedColorArray[n];
            this.selectedColorArray[n] = this.selectedColorArray[i];
            this.selectedColorArray[i] = color;
        }
    }

    @Override
    public void Save(RandomOutputStream randomOutputStream) throws IOException {
        int n;
        randomOutputStream.writePropertyStringUTF("cname", this.name);
        randomOutputStream.writePropertyInt("csize", this.colorArray.length);
        for (n = 0; n < this.colorArray.length; ++n) {
            randomOutputStream.writePropertyInt("cc" + n, this.colorArray[n].getRGB());
        }
        for (n = 0; n < this.selectedColorArray.length; ++n) {
            randomOutputStream.writePropertyInt("scc" + n, this.selectedColorArray[n].getRGB());
        }
        randomOutputStream.writePropertyBoolean("reversed", this.isReversed);
    }

    @Override
    public void setAlpha(float f) {
        for (int i = 0; i < this.colorArray.length; ++i) {
            this.colorArray[i] = new Color((float)this.colorArray[i].getRed(), (float)this.colorArray[i].getGreen(), (float)this.colorArray[i].getBlue(), f);
            this.selectedColorArray[i] = new Color((float)this.selectedColorArray[i].getRed(), (float)this.selectedColorArray[i].getGreen(), (float)this.selectedColorArray[i].getBlue(), f);
        }
    }

    @Override
    public void setClassIndex(int n) {
        this.classIndex = n;
    }

    @Override
    public void setColor(int n, Color color) {
        this.colorArray[n] = color;
        this.selectedColorArray[n] = color.darker();
    }

    @Override
    public void setNoVisibleColors(int n) {
        this.noVisibleColors = n;
    }

    @Override
    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public String toString() {
        return this.name;
    }
}

