/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;

public abstract class AbstractExportInfo
extends AbstractInfo {
    private static final JCheckBox includeIdentifiersCheckBox = new JCheckBox("Include headers/identifiers", true);
    private static FileFilter defaultFileFilter;
    protected File file;
    protected SimpleTableModel model;
    protected Properties properties;

    public static void ExportDataNow(ProgressManager progressManager, File file, String string, String string2, SimpleTableModel simpleTableModel, boolean bl, Properties properties) {
        AbstractExportInfo abstractExportInfo = AbstractExportInfo.getExportInfo(string, string2);
        if (abstractExportInfo != null) {
            abstractExportInfo.SaveNow(progressManager, file, simpleTableModel, bl, properties);
        }
    }

    public static void ExportDataNow(SimpleTableModel simpleTableModel, boolean bl) {
        AbstractExportInfo.ExportDataNow(simpleTableModel, bl, null);
    }

    public static void ExportDataNow(SimpleTableModel simpleTableModel, boolean bl, AbstractExportInfo abstractExportInfo) {
        Object object;
        Cloneable cloneable;
        AbstractDataMatrix abstractDataMatrix = simpleTableModel.getMatrix();
        String string = abstractDataMatrix == null ? "Table" : abstractDataMatrix.toString();
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Save " + string + " As", IniManager.getMainFrame());
        defaultFileFilter = null;
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.EXPORT_INFO);
        for (AbstractInfo object22 : list) {
            cloneable = (AbstractExportInfo)object22;
            if (!cloneable.supportTableModel(simpleTableModel) || cloneable.isImageSave() != bl) continue;
            object = jopensaveDialog2.addExtension(cloneable.getExt(), cloneable.getDescription());
            if (abstractExportInfo == null || !abstractExportInfo.getClass().equals(cloneable.getClass())) continue;
            defaultFileFilter = object;
        }
        File file = IniManager.getWorkDir((byte)1);
        if (file == null) {
            jopensaveDialog2.setSelectedFile(new File(string));
        } else {
            jopensaveDialog2.setSelectedFile(new File(IniManager.Slash(file.getAbsolutePath()) + string));
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Save settings"));
        jopensaveDialog2.setAccessory(jPanel);
        cloneable = new Properties();
        jopensaveDialog2.addPropertyChangeListener(arg_0 -> AbstractExportInfo.lambda$ExportDataNow$0(jopensaveDialog2, jPanel, (Properties)cloneable, arg_0));
        includeIdentifiersCheckBox.setSelected(true);
        if (defaultFileFilter != null) {
            SwingUtilities.invokeLater(() -> jopensaveDialog2.setFileFilter(defaultFileFilter));
        }
        if (jopensaveDialog2.saveshow()) {
            IniManager.setWorkDir((byte)1, jopensaveDialog2.getCurrentDirectory());
            object = jopensaveDialog2.getSelectedFile();
            String string2 = jopensaveDialog.getFileExtension((File)object);
            FileFilter fileFilter = jopensaveDialog2.getFileFilter();
            String string3 = fileFilter.getDescription();
            AbstractExportInfo.ExportDataNow(null, (File)object, string2, string3, simpleTableModel, includeIdentifiersCheckBox.isSelected(), (Properties)cloneable);
        }
    }

    private static AbstractExportInfo getExportInfo(String string, String string2) {
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.EXPORT_INFO);
        for (AbstractInfo abstractInfo : list) {
            AbstractExportInfo abstractExportInfo = (AbstractExportInfo)abstractInfo;
            if (!(string2 != null ? string2.equals(abstractExportInfo.getDescription()) : string != null && string.equals(abstractExportInfo.getExt()))) continue;
            return abstractExportInfo;
        }
        return null;
    }

    public abstract String getDescription();

    public abstract String getExt();

    public boolean isImageSave() {
        return false;
    }

    public void SaveNow(ProgressManager progressManager, File file, SimpleTableModel simpleTableModel, boolean bl, final Properties properties) {
        this.file = file;
        this.model = simpleTableModel;
        simpleTableModel.setIncludeIdentifiers(bl);
        file.getParentFile().mkdirs();
        if (progressManager == null) {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                final /* synthetic */ AbstractExportInfo this$0;
                {
                    this.this$0 = abstractExportInfo;
                }

                @Override
                public Object doWork() {
                    this.this$0.saveNow(this, properties);
                    return null;
                }
            };
            progressManagerImpl.invokeNow();
        } else {
            this.saveNow(progressManager, properties);
        }
    }

    public boolean supportTableModel(SimpleTableModel simpleTableModel) {
        return true;
    }

    public String toString() {
        return this.getDescription();
    }

    protected void addExportSettings(JPanel jPanel, Properties properties) {
        jPanel.add((Component)includeIdentifiersCheckBox, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
    }

    @Override
    protected void cleanUpChild() {
        this.model = null;
    }

    protected abstract void SaveNow(ProgressManager var1);

    protected void SaveNow(ProgressManager progressManager, Properties properties) {
        this.properties = properties;
        this.SaveNow(progressManager);
    }

    private void saveNow(ProgressManager progressManager, Properties properties) {
        if (UpdateHelper.Product.isRunningProductBreezeSuite()) {
            progressManager.setInfoText("Saving " + this.model.toString() + " into file");
        } else {
            progressManager.setInfoText("Saving " + this.model.toString() + " into file: " + this.file.getName());
        }
        progressManager.setIndeterminate(true);
        this.SaveNow(progressManager, properties);
        this.model.setIncludeIdentifiers(true);
    }

    private static /* synthetic */ void lambda$ExportDataNow$0(jopensaveDialog jopensaveDialog2, JPanel jPanel, Properties properties, PropertyChangeEvent propertyChangeEvent) {
        FileFilter fileFilter;
        if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged") && (fileFilter = jopensaveDialog2.getFileFilter()) != null) {
            String string = fileFilter.getDescription();
            AbstractExportInfo abstractExportInfo = AbstractExportInfo.getExportInfo(null, string);
            jPanel.removeAll();
            properties.clear();
            abstractExportInfo.addExportSettings(jPanel, properties);
            jPanel.add((Component)new JLabel(""), new GridBagConstraints(0, 10, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            jPanel.revalidate();
            jPanel.repaint();
            jopensaveDialog2.setAccessory(jPanel);
        }
    }
}

