/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.sparsetable.SparseModel;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.simpletableeditor.CellIdentifier;

public class ExportHTML
extends AbstractExportInfo {
    @Override
    public String getDescription() {
        return "HTML files (*.html)";
    }

    @Override
    public String getExt() {
        return "html";
    }

    @Override
    protected void SaveNow(ProgressManager progressManager) {
        try {
            FileWriter fileWriter = new FileWriter(this.file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.toFullHtml(bufferedWriter, progressManager);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String colorToHtml(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    private void toFullHtml(BufferedWriter bufferedWriter, ProgressManager progressManager) throws IOException {
        bufferedWriter.write("<!DOCTYPE html\nPUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n");
        bufferedWriter.write("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        bufferedWriter.write("<html lang=\"en\">\n");
        bufferedWriter.write("<head>\n");
        bufferedWriter.write("<title>");
        bufferedWriter.write(this.model.getMatrix().toString());
        bufferedWriter.write(" - Created with Evince");
        bufferedWriter.write("</title>\n");
        bufferedWriter.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />\n");
        bufferedWriter.write("<style type=\"text/css\">\n");
        bufferedWriter.write("td.missing {\n");
        bufferedWriter.write("background-color: ");
        bufferedWriter.write(this.colorToHtml(CellIdentifier.colorMissing));
        bufferedWriter.write("\n}\n");
        bufferedWriter.write("td.vardesc {\n");
        bufferedWriter.write("background-color: ");
        bufferedWriter.write(this.colorToHtml(CellIdentifier.colorVarId));
        bufferedWriter.write("\n}\n");
        bufferedWriter.write("td.obsdesc {\n");
        bufferedWriter.write("background-color: ");
        bufferedWriter.write(this.colorToHtml(CellIdentifier.colorObsId));
        bufferedWriter.write("\n}\n");
        bufferedWriter.write("</style>\n");
        bufferedWriter.write("</head>\n");
        bufferedWriter.write("<body>\n");
        this.toHtml(bufferedWriter, progressManager);
        bufferedWriter.write("</body>\n");
        bufferedWriter.write("</html>\n");
    }

    private void toHtml(BufferedWriter bufferedWriter, ProgressManager progressManager) throws IOException {
        int n = this.model.getColumnDescriptionCount();
        int n2 = this.model.getRowDescriptionCount();
        int n3 = this.model.getRowCount();
        int n4 = this.model.getColumnCount();
        if (this.model instanceof SparseModel) {
            n3 = this.model.getMatrix().getN();
            n4 = this.model.getMatrix().getK();
        }
        bufferedWriter.write("<table border=\"1\">\n");
        progressManager.setMaximumAndReset(n3 + n);
        for (int i = 0; i < n3 + n; ++i) {
            bufferedWriter.write("<tr>");
            for (int j = 0; j < n4 + n2; ++j) {
                int n5;
                if (i >= n && j >= n2) {
                    n5 = this.model.getMatrix().isMissing(i - n, j - n2) ? 1 : 0;
                    Object object = this.model.getValueAt(i - n, j - n2);
                    Double d = SimpleTableModel.parseObject(object);
                    if (d != null) {
                        bufferedWriter.write("<td>");
                        bufferedWriter.write(String.valueOf(d));
                        bufferedWriter.write("</td>");
                        continue;
                    }
                    if (!(object instanceof String) || n5 != 0) {
                        bufferedWriter.write("<td class=\"missing\">MV</td>");
                        continue;
                    }
                    bufferedWriter.write("<td>");
                    bufferedWriter.write(object.toString());
                    bufferedWriter.write("</td>");
                    continue;
                }
                if (i < n && j >= n2) {
                    n5 = j - n2;
                    bufferedWriter.write("<td class=\"vardesc\">");
                    bufferedWriter.write(this.model.getRowDescription(i, n5));
                    bufferedWriter.write("</td>");
                    continue;
                }
                if (i >= n) {
                    n5 = i - n;
                    bufferedWriter.write("<td class=\"obsdesc\">");
                    bufferedWriter.write(this.model.getColumnDescriptionSorted(n5, j));
                    bufferedWriter.write("</td>");
                    continue;
                }
                bufferedWriter.write("<td></td>");
            }
            bufferedWriter.write("</tr>\n");
            progressManager.incStep();
        }
        bufferedWriter.write("</table>\n");
    }
}

