/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport;

import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5File;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;

public class ExportHdf
extends AbstractExportInfo {
    @Override
    public String getDescription() {
        return "HDF files (*.hdf)";
    }

    @Override
    public String getExt() {
        return "hdf";
    }

    public boolean saveHdf(String string, ProgressManager progressManager) {
        try {
            LayerMatrix layerMatrix = (LayerMatrix)this.model.getMatrix();
            FileFormat fileFormat = FileFormat.getFileFormat((String)"HDF5");
            H5File h5File = (H5File)fileFormat.createFile(this.file.getAbsolutePath(), 10);
            h5File.open();
            Group group = (Group)((DefaultMutableTreeNode)h5File.getRootNode()).getUserObject();
            int n = layerMatrix.getFoldN();
            int n2 = layerMatrix.getFoldsize();
            int n3 = layerMatrix.getFoldK();
            long[] lArray = new long[]{n2, n3, n};
            Group group2 = h5File.createGroup("float arrays", group);
            Datatype datatype = h5File.createDatatype(1, 8, -1, -1);
            double[][][] dArray = new double[n2][n3][n];
            progressManager.setMaximumAndReset(n2 * n);
            for (int i = 0; i < n2; ++i) {
                AbstractDataMatrix abstractDataMatrix = layerMatrix.getMatrixAt(i);
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        dArray[i][k][j] = abstractDataMatrix.getValue(j, k);
                    }
                    progressManager.incStep();
                }
            }
            h5File.createScalarDS("3D 64-bit double", group2, datatype, lArray, null, null, 0, (Object)dArray);
            h5File.close();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return false;
        }
        return true;
    }

    @Override
    public boolean supportTableModel(SimpleTableModel simpleTableModel) {
        return simpleTableModel.getMatrix() instanceof LayerMatrix;
    }

    @Override
    protected void SaveNow(ProgressManager progressManager) {
        this.saveHdf("MV", progressManager);
    }
}

