/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.sparsetable.SparseModel;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.Transformations;
import se.prediktera.map.main.script.ScriptHelper;

public class ExportRaw
extends AbstractExportInfo {
    private static final JCheckBox includeClassesCheckBox = new JCheckBox("Include categories", false);

    @Override
    public String getDescription() {
        return "Ascii files (*.txt)";
    }

    @Override
    public String getExt() {
        return "txt";
    }

    public boolean saveRaw(char c, String string, ProgressManager progressManager) {
        try {
            int n;
            AbstractDataInfo abstractDataInfo;
            Cloneable cloneable;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            DecimalFormat decimalFormat = null;
            String[] stringArray = null;
            String[] stringArray2 = null;
            String string2 = null;
            HashMap hashMap = null;
            if (this.properties != null) {
                String string3;
                if (ScriptHelper.hasKey(this.properties, "append")) {
                    bl = ScriptHelper.getPropertyBool(this.properties, "append");
                }
                if (ScriptHelper.hasKey(this.properties, "description")) {
                    string3 = ScriptHelper.getProperty(this.properties, "description");
                    stringArray = string3.split(";");
                }
                if (ScriptHelper.hasKey(this.properties, "variable")) {
                    string3 = ScriptHelper.getProperty(this.properties, "variable");
                    stringArray2 = string3.split(";");
                }
                if (ScriptHelper.hasKey(this.properties, "header")) {
                    bl2 = ScriptHelper.getPropertyBool(this.properties, "header");
                }
                if (ScriptHelper.hasKey(this.properties, "obsheader")) {
                    bl3 = ScriptHelper.getPropertyBool(this.properties, "obsheader");
                }
                if (ScriptHelper.hasKey(this.properties, "classname")) {
                    string2 = ScriptHelper.getProperty(this.properties, "classname");
                }
                if (ScriptHelper.hasKey(this.properties, "classindex")) {
                    hashMap = (HashMap)this.properties.get("classindex");
                }
                if (ScriptHelper.hasKey(this.properties, "decimalseparator")) {
                    char c2 = ScriptHelper.getProperty(this.properties, "decimalseparator").charAt(0);
                    decimalFormat = new DecimalFormat();
                    cloneable = DecimalFormatSymbols.getInstance();
                    ((DecimalFormatSymbols)cloneable).setDecimalSeparator(c2);
                    decimalFormat.setDecimalFormatSymbols((DecimalFormatSymbols)cloneable);
                }
            }
            if (bl && this.file.exists()) {
                bl2 = false;
            }
            boolean bl4 = includeClassesCheckBox.isSelected();
            cloneable = new ArrayList<InnerColumnClass>();
            if ((bl4 || string2 != null) && (abstractDataInfo = this.model.getPrimaryDataInfo()) != null) {
                Transformations transformations = abstractDataInfo.getTransformationNode();
                n = transformations.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    if (transformations.getColumnType(i) != 4) continue;
                    InnerColumnClass innerColumnClass = (InnerColumnClass)transformations.getInnerColumn(i);
                    if (string2 != null && (!innerColumnClass.getName().equals(string2) || cloneable.size() > 0)) continue;
                    cloneable.add(innerColumnClass);
                }
            }
            int n2 = bl2 ? this.model.getColumnDescriptionCount() : 0;
            int n3 = bl3 ? this.model.getRowDescriptionCount() : 0;
            n = n3 + cloneable.size();
            if (stringArray != null) {
                n += stringArray.length;
            }
            if (stringArray2 != null) {
                ++n;
            }
            int[] nArray = this.model.getPrimaryRef();
            int n4 = this.model.getRowCount();
            int n5 = this.model.getColumnCount();
            if (this.model instanceof SparseModel) {
                n4 = this.model.getMatrix().getN();
                n5 = this.model.getMatrix().getK();
            }
            progressManager.setMaximumAndReset(n4 + n2);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.file, bl));){
                AbstractDataMatrix abstractDataMatrix = this.model.getMatrix();
                if (UpdateHelper.Product.isRunningProductBreezeSuite() && n2 == 0 && n == 0 && abstractDataMatrix != null && abstractDataMatrix.getN() == n4 && abstractDataMatrix.getK() == n5) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n5; ++j) {
                            if (j > 0) {
                                stringBuilder.append(c);
                            }
                            stringBuilder.append(abstractDataMatrix.getValue(i, j));
                        }
                        bufferedWriter.write(stringBuilder.toString());
                        bufferedWriter.newLine();
                        stringBuilder.setLength(0);
                        progressManager.incStep();
                    }
                } else {
                    for (int i = 0; i < n4 + n2; ++i) {
                        for (int j = 0; j < n5 + n; ++j) {
                            if (i >= n2 && j >= n) {
                                Object object = this.model.getRenderedTableValue(i - n2, j - n);
                                Double d = SimpleTableModel.parseObject(object);
                                if (d != null) {
                                    if (decimalFormat != null) {
                                        bufferedWriter.write(decimalFormat.format(d));
                                    } else {
                                        bufferedWriter.write(d.toString());
                                    }
                                } else if (object instanceof String) {
                                    bufferedWriter.write((String)object);
                                } else {
                                    bufferedWriter.write(string);
                                }
                            } else if (i < n2) {
                                if (j < cloneable.size()) {
                                    bufferedWriter.write(((InnerColumnClass)cloneable.get(j)).getName());
                                } else if (stringArray2 != null && j < 1) {
                                    bufferedWriter.write(stringArray2[0]);
                                } else if (j >= n) {
                                    int n6 = j - n;
                                    bufferedWriter.write(this.model.getRowDescription(i, n6));
                                } else {
                                    bufferedWriter.write(this.model.getRowDescriptionTitle(j));
                                }
                            } else {
                                int n7 = i - n2;
                                if (j < n3) {
                                    String string4 = this.model.getColumnDescriptionSorted(n7, j);
                                    if (string4 != null) {
                                        bufferedWriter.write(string4);
                                    }
                                } else {
                                    int n8 = j - n3;
                                    if (n8 < cloneable.size()) {
                                        InnerColumnClass innerColumnClass = (InnerColumnClass)cloneable.get(n8);
                                        int n9 = this.model.getSortIndexForRow(n7);
                                        short s = innerColumnClass.getValueShort(nArray != null ? nArray[n9] : n9);
                                        String string5 = innerColumnClass.getObject().getTypeDescription(s);
                                        if (hashMap != null) {
                                            bufferedWriter.write(((Short)hashMap.get(string5)).toString());
                                        } else {
                                            bufferedWriter.write(string5);
                                        }
                                    } else if (stringArray2 != null && n8 < 1) {
                                        bufferedWriter.write(stringArray2[n7 + 1]);
                                    } else {
                                        bufferedWriter.write(stringArray[n8 - cloneable.size()]);
                                    }
                                }
                            }
                            if (j + 1 == n5 + n) continue;
                            bufferedWriter.write(c);
                        }
                        bufferedWriter.newLine();
                        progressManager.incStep();
                    }
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showConfirmDialog(progressManager != null ? progressManager.getWindow() : null, exception.getMessage(), "Cannot save file", -1, 0);
            ErrorHandler.logAndReportException(exception);
            return false;
        }
        return true;
    }

    @Override
    protected void addExportSettings(JPanel jPanel, Properties properties) {
        super.addExportSettings(jPanel, properties);
        jPanel.add((Component)includeClassesCheckBox, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
    }

    @Override
    protected void SaveNow(ProgressManager progressManager) {
        this.saveRaw('\t', "MV", progressManager);
    }
}

