/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport;

import java.io.File;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.data.sparsetable.SparseModel;
import se.prediktera.map.dataexport.AbstractExportInfo;

public class ExportXLS
extends AbstractExportInfo {
    @Override
    public String getDescription() {
        return "Excel files (*.xls)";
    }

    @Override
    public String getExt() {
        return "xls";
    }

    public boolean saveXLS(String string, ProgressManager progressManager) {
        try {
            WorkbookSettings workbookSettings = new WorkbookSettings();
            workbookSettings.setLocale(Locale.of("en", "EN"));
            WritableWorkbook writableWorkbook = Workbook.createWorkbook((File)this.file, (WorkbookSettings)workbookSettings);
            WritableSheet writableSheet = writableWorkbook.createSheet(this.model.getMatrix().toString(), 0);
            this.writeSheet(writableSheet, string, progressManager);
            writableWorkbook.write();
            writableWorkbook.close();
            return true;
        }
        catch (Exception exception) {
            ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            return false;
        }
    }

    @Override
    protected void SaveNow(ProgressManager progressManager) {
        this.saveXLS("MV", progressManager);
    }

    private void writeSheet(WritableSheet writableSheet, String string, ProgressManager progressManager) throws WriteException {
        int n = this.model.getColumnDescriptionCount();
        int n2 = this.model.getRowDescriptionCount();
        int n3 = this.model.getRowCount();
        int n4 = this.model.getColumnCount();
        if (this.model instanceof SparseModel) {
            n3 = this.model.getMatrix().getN();
            n4 = this.model.getMatrix().getK();
        }
        WritableCellFormat writableCellFormat = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        WritableCellFormat writableCellFormat2 = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        writableCellFormat2.setBackground(Colour.RED);
        WritableCellFormat writableCellFormat3 = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        writableCellFormat3.setBackground(Colour.LIGHT_TURQUOISE);
        WritableCellFormat writableCellFormat4 = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        writableCellFormat4.setBackground(Colour.LIGHT_GREEN);
        progressManager.setMaximumAndReset(n3 + n);
        for (int i = 0; i < n3 + n; ++i) {
            for (int j = 0; j < n4 + n2; ++j) {
                int n5;
                if (i >= n && j >= n2) {
                    n5 = this.model.getMatrix().isMissing(i - n, j - n2) ? 1 : 0;
                    Object object = this.model.getRenderedTableValue(i - n, j - n2);
                    Double d = SimpleTableModel.parseObject(object);
                    if (d != null) {
                        writableSheet.addCell((WritableCell)new Number(j, i, d.doubleValue()));
                        continue;
                    }
                    if (object instanceof String) {
                        if (n5 != 0) {
                            writableSheet.addCell((WritableCell)new Label(j, i, (String)object, (CellFormat)writableCellFormat2));
                            continue;
                        }
                        writableSheet.addCell((WritableCell)new Label(j, i, (String)object, (CellFormat)writableCellFormat));
                        continue;
                    }
                    writableSheet.addCell((WritableCell)new Label(j, i, string, (CellFormat)writableCellFormat2));
                    continue;
                }
                if (i < n) {
                    if (j >= n2) {
                        n5 = j - n2;
                        writableSheet.addCell((WritableCell)new Label(j, i, this.model.getRowDescription(i, n5), (CellFormat)writableCellFormat4));
                        continue;
                    }
                    writableSheet.addCell((WritableCell)new Label(j, i, this.model.getRowDescriptionTitle(j), (CellFormat)writableCellFormat4));
                    continue;
                }
                n5 = i - n;
                writableSheet.addCell((WritableCell)new Label(j, i, this.model.getColumnDescriptionSorted(n5, j), (CellFormat)writableCellFormat3));
            }
            progressManager.incStep();
        }
    }
}

