/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport.matlab;

import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLChar;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import se.prediktera.map.common.cleanup.CleanUpVector;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.dataexport.matlab.MLDoubleCustom;
import se.prediktera.map.dataexport.matlab.Mat73FileWriterCustom;
import se.prediktera.map.dataexport.matlab.MatFileWriterCustom;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;

public class ExportMAT
extends AbstractExportInfo {
    public static String DISALLOWED_CHARACTERS = "[^A-Za-z0-9_]";
    public static String ALLOWED_AT_START = "^[A-Za-z].*";
    private final JComboBox<String> formatCheckBox = new JComboBox<String>(new String[]{"hdf4", "hdf5"});

    public static String getCorrectVariableName(String object) {
        if (!((String)(object = ((String)object).replaceAll(DISALLOWED_CHARACTERS, "_"))).matches(ALLOWED_AT_START)) {
            object = "X_" + (String)object;
        }
        if (((String)object).length() > 63) {
            object = ((String)object).substring(0, 63);
        }
        return object;
    }

    private static String createCorrectFileName(String string, String string2) {
        if (!string.endsWith(".mat")) {
            string = string.concat(".mat");
        }
        if (string2 == null) {
            return string;
        }
        Pattern pattern = Pattern.compile("[.]mat$");
        Matcher matcher = pattern.matcher(string);
        String string3 = matcher.replaceFirst("_" + string2 + ".mat");
        matcher.find();
        return string3;
    }

    @Override
    public String getDescription() {
        return "MATLAB Data Cube file  (.mat)";
    }

    @Override
    public String getExt() {
        return "mat";
    }

    @Override
    public boolean isImageSave() {
        return true;
    }

    @Override
    protected void addExportSettings(JPanel jPanel, Properties properties) {
        super.addExportSettings(jPanel, properties);
        jPanel.add(this.formatCheckBox, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
    }

    @Override
    protected void SaveNow(ProgressManager progressManager) {
        int n;
        int n2;
        int n3;
        Serializable serializable;
        AbstractDataMatrix abstractDataMatrix = this.model.getMatrix();
        if (abstractDataMatrix instanceof LayerMatrix) {
            serializable = (LayerMatrix)abstractDataMatrix;
            if (((LayerMatrix)serializable).getFoldsize() <= 0) {
                return;
            }
            n3 = ((MatrixContainer)serializable).getMatrixAt(0).getN();
            n2 = ((MatrixContainer)serializable).getMatrixAt(0).getK();
            n = ((LayerMatrix)serializable).getFoldsize();
        } else if (abstractDataMatrix instanceof FoldMatrix) {
            n3 = abstractDataMatrix.getN();
            n2 = abstractDataMatrix.getK();
            n = abstractDataMatrix.getFoldsize();
        } else if (abstractDataMatrix instanceof AbstractMVmatrix && !abstractDataMatrix.isFoldable()) {
            n3 = abstractDataMatrix.getN();
            n2 = abstractDataMatrix.getK();
            n = 1;
        } else if (abstractDataMatrix.isFoldable()) {
            serializable = new FoldMatrix(abstractDataMatrix);
            n3 = ((FoldMatrix)serializable).getN();
            n2 = ((FoldMatrix)serializable).getK();
            n = ((ReferenceMatrix)serializable).getFoldsize();
            ((CleanUpVector)serializable).cleanUp();
        } else if (abstractDataMatrix instanceof ModelMatrix || !abstractDataMatrix.isFoldable()) {
            n3 = abstractDataMatrix.getN();
            n2 = abstractDataMatrix.getK();
            n = 1;
        } else {
            serializable = new FoldMatrix(abstractDataMatrix);
            n3 = ((FoldMatrix)serializable).getN();
            n2 = ((FoldMatrix)serializable).getK();
            n = ((ReferenceMatrix)serializable).getFoldsize();
            ((CleanUpVector)serializable).cleanUp();
        }
        serializable = this.file.getParentFile();
        if (this.formatCheckBox.getSelectedIndex() == 1 || this.model.getMatrix().getSize() * 8.0 > 2.0E9) {
            this.writeHdf5(progressManager, abstractDataMatrix, this.file);
            if (this.model.isIncludeIdentifiers()) {
                this.writeDescriptions(abstractDataMatrix, (File)serializable);
            }
        } else {
            this.writeData(abstractDataMatrix, n3, n2, n);
            if (this.model.isIncludeIdentifiers()) {
                this.writeDescriptions(abstractDataMatrix, (File)serializable);
            }
        }
    }

    protected void writeDescriptions(AbstractDataMatrix abstractDataMatrix, File file) {
        Object object;
        String[] stringArray;
        Object object2;
        MatFileWriter matFileWriter = new MatFileWriter();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (abstractDataMatrix instanceof AbstractMVmatrix || abstractDataMatrix instanceof ModelMatrix) {
            return;
        }
        if (abstractDataMatrix instanceof FoldMatrix) {
            object2 = (FoldMatrix)abstractDataMatrix;
            for (var7_6 = 0; var7_6 < ((ReferenceMatrix)object2).getFoldsize(); ++var7_6) {
                linkedList.add(((ReferenceMatrix)object2).getFoldName(var7_6));
            }
        } else if (abstractDataMatrix instanceof LayerMatrix) {
            stringArray = (String[])abstractDataMatrix;
            if (stringArray.getFoldsize() < 1) {
                return;
            }
            for (var7_6 = 0; var7_6 < stringArray.getFoldsize(); ++var7_6) {
                object2 = stringArray.getMatrixAt(var7_6);
                linkedList.add(((DataTreeClass)object2).toString());
            }
        } else {
            object2 = new FoldMatrix(abstractDataMatrix);
            var7_6 = ((ReferenceMatrix)object2).getFoldsize();
            object = new double[var7_6];
            for (int i = 0; i < var7_6; ++i) {
                double d;
                String string = ((ReferenceMatrix)object2).getFoldName(i);
                linkedList.add(string);
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                object[i] = d;
            }
            ((CleanUpVector)object2).cleanUp();
        }
        stringArray = linkedList.toArray(new String[0]);
        object2 = this.file.getName().replaceAll("[.]mat", "_layer_names");
        if (!((String)object2).matches(ALLOWED_AT_START)) {
            object2 = "X_" + (String)object2;
        }
        object2 = ((String)object2).replaceAll(DISALLOWED_CHARACTERS, "_");
        MLChar mLChar = new MLChar((String)object2, stringArray, 30);
        object = new ArrayList();
        ((ArrayList)object).add(mLChar);
        try {
            File file2 = new File(file, this.file.getName().replaceAll("[.]mat", "_LAYERS.mat"));
            matFileWriter.write(file2, (Collection)object);
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private void writeData(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3) {
        try {
            MatFileWriterCustom matFileWriterCustom = new MatFileWriterCustom(this.file);
            int[] nArray = new int[]{n, n2, n3};
            String string = ExportMAT.getCorrectVariableName(this.model.toString());
            MLDoubleCustom mLDoubleCustom = new MLDoubleCustom(string, abstractDataMatrix.getDataSize(), nArray);
            matFileWriterCustom.write((MLArray)mLDoubleCustom, abstractDataMatrix, false, true);
            matFileWriterCustom.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private void writeHdf5(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, File file) {
        try {
            progressManager.setInfoText("Writing HDF5 format");
            if (abstractDataMatrix.isFoldable()) {
                FoldMatrix foldMatrix = new FoldMatrix(abstractDataMatrix);
                int n = foldMatrix.getFoldsize();
                progressManager.setMaximumAndReset(n);
                String string = ExportMAT.getCorrectVariableName(abstractDataMatrix.getName());
                Mat73FileWriterCustom mat73FileWriterCustom = new Mat73FileWriterCustom(file);
                mat73FileWriterCustom.write(progressManager, foldMatrix, string, -1);
                mat73FileWriterCustom.close();
                String string2 = ExportMAT.createCorrectFileName(file.getName(), "ROWS");
                Mat73FileWriterCustom mat73FileWriterCustom2 = new Mat73FileWriterCustom(new File(file.getParentFile(), string2));
                int[] nArray = this.createIndex(foldMatrix.getNref(), foldMatrix.getN());
                mat73FileWriterCustom2.write(nArray, string2.replace(".mat", "").toLowerCase());
                mat73FileWriterCustom2.close();
                String string3 = ExportMAT.createCorrectFileName(file.getName(), "COLS");
                Mat73FileWriterCustom mat73FileWriterCustom3 = new Mat73FileWriterCustom(new File(file.getParentFile(), string3));
                int[] nArray2 = this.createIndex(foldMatrix.getKref(), foldMatrix.getK());
                mat73FileWriterCustom3.write(nArray2, string3.replace(".mat", "").toLowerCase());
                mat73FileWriterCustom3.close();
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private int[] createIndex(int[] nArray, int n) {
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = n2++;
                nArray[n3] = nArray[n3] + 1;
            }
        } else {
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray2[i] = i + 1;
            }
            return nArray2;
        }
        return nArray;
    }
}

