/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport.matlab;

import com.jmatio.types.MLArray;
import java.io.IOException;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataexport.matlab.ExportMAT;
import se.prediktera.map.dataexport.matlab.MLDoubleCustom;
import se.prediktera.map.dataexport.matlab.MatFileWriterCustom;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;

public class ExportMATRaw
extends ExportMAT {
    public static String DISALLOWED_CHARACTERS = "[^A-Za-z0-9._]";
    public static String ALLOWED_AT_START = "^[A-Za-z].*";

    @Override
    public String getDescription() {
        return "MATLAB file (.mat)";
    }

    @Override
    public boolean isImageSave() {
        return false;
    }

    @Override
    protected void SaveNow(ProgressManager progressManager) {
        int n;
        int n2;
        int n3;
        AbstractDataMatrix abstractDataMatrix = this.model.getMatrix();
        if (abstractDataMatrix instanceof LayerMatrix) {
            LayerMatrix layerMatrix = (LayerMatrix)abstractDataMatrix;
            if (layerMatrix.getFoldsize() <= 0) {
                return;
            }
            n3 = layerMatrix.getMatrixAt(0).getN();
            n2 = layerMatrix.getMatrixAt(0).getK();
            n = layerMatrix.getFoldsize();
        } else if (abstractDataMatrix instanceof FoldMatrix) {
            n3 = abstractDataMatrix.getN();
            n2 = abstractDataMatrix.getK();
            n = abstractDataMatrix.getFoldsize();
        } else {
            n3 = abstractDataMatrix.getN();
            n2 = abstractDataMatrix.getK();
            n = 1;
        }
        this.writeData(abstractDataMatrix, n3, n2, n);
        if (this.model.isIncludeIdentifiers()) {
            this.writeDescriptions(abstractDataMatrix, this.file.getParentFile());
        }
    }

    private void writeData(AbstractDataMatrix abstractDataMatrix, int n, int n2, int n3) {
        try {
            MatFileWriterCustom matFileWriterCustom = new MatFileWriterCustom(this.file);
            int[] nArray = new int[]{n, n2, n3};
            String string = ExportMATRaw.getCorrectVariableName(this.model.toString());
            MLDoubleCustom mLDoubleCustom = new MLDoubleCustom(string, abstractDataMatrix.getDataSize(), nArray);
            matFileWriterCustom.write((MLArray)mLDoubleCustom, abstractDataMatrix, false, false);
            matFileWriterCustom.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }
}

