/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport.matlab;

import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5DoubleWriter;
import ch.systemsx.cisd.hdf5.IHDF5IntWriter;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadWriteInfoProviderHandler;
import ch.systemsx.cisd.hdf5.IHDF5StringWriter;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;

public class Mat73FileWriterCustom {
    public static final Charset ASCII_CHARSET = StandardCharsets.US_ASCII;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final int DEFLATION_LEVEL = 3;
    public static final int FILE_BYTE_BUFFER_SIZE = 8192;
    private FileOutputStream outputStream;
    private WritableByteChannel byteChannel = null;
    private boolean writeMissingValues;
    private final long superBlockOffset = 512L;
    private final long superBlockOffsetAddress = 24L;

    public static double[] flatten(double[][][] dArray) {
        long[] lArray = Mat73FileWriterCustom.getDimensions(dArray);
        double[] dArray2 = new double[(int)(lArray[0] * lArray[1] * lArray[2])];
        int n = 0;
        int n2 = 0;
        while ((long)n2 < lArray[0]) {
            int n3 = 0;
            while ((long)n3 < lArray[1]) {
                int n4 = 0;
                while ((long)n4 < lArray[2]) {
                    dArray2[n++] = dArray[n2][n4][n3];
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }

    public static long[] getDimensions(AbstractDataMatrix abstractDataMatrix) {
        long l = abstractDataMatrix.getFoldsize();
        long l2 = abstractDataMatrix.getN();
        long l3 = abstractDataMatrix.getK();
        return new long[]{l, l3, l2};
    }

    public static long[] getDimensions(double[][][] dArray) {
        long l = dArray.length;
        long l2 = 0L;
        long l3 = 0L;
        if (dArray.length > 0) {
            l2 = dArray[0].length;
            if (dArray[0].length > 0) {
                l3 = dArray[0][0].length;
            }
        }
        return new long[]{l, l3, l2};
    }

    public static double[][][] unFlatten(double[] dArray, long[] lArray) {
        double[][][] dArray2 = new double[(int)lArray[0]][(int)lArray[2]][(int)lArray[1]];
        int n = 0;
        int n2 = 0;
        while ((long)n2 < lArray[0]) {
            int n3 = 0;
            while ((long)n3 < lArray[1]) {
                int n4 = 0;
                while ((long)n4 < lArray[2]) {
                    dArray2[n2][n4][n3] = dArray[n++];
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }

    public Mat73FileWriterCustom(File file) throws IOException {
        this.outputStream = new FileOutputStream(file);
        this.byteChannel = this.outputStream.getChannel();
    }

    public Mat73FileWriterCustom(String string) throws IOException {
        this(new File(string));
    }

    public synchronized void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.byteChannel != null) {
            this.byteChannel.close();
            this.byteChannel = null;
        }
    }

    public synchronized void write(double[][][] dArray, String string) throws IOException {
        File file = null;
        try {
            file = File.createTempFile("temp", ".tmp");
            this.writeMatrix(file, dArray, string);
            Mat73FileWriterCustom.writeMatlabHeader(this.byteChannel);
            Mat73FileWriterCustom.updateBaseAddress(file);
            Mat73FileWriterCustom.appendHDFData(file, this.byteChannel);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    public synchronized void write(int[] nArray, String string) throws IOException {
        File file = File.createTempFile("temp", ".tmp");
        this.writeMatrix(file, nArray, string);
        Mat73FileWriterCustom.writeMatlabHeader(this.byteChannel);
        Mat73FileWriterCustom.updateBaseAddress(file);
        Mat73FileWriterCustom.appendHDFData(file, this.byteChannel);
        file.delete();
    }

    public synchronized void write(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix, String string, int n) throws IOException {
        File file = File.createTempFile("temp", ".tmp");
        this.writeMatrix(progressManager, file, abstractDataMatrix, string, n);
        Mat73FileWriterCustom.writeMatlabHeader(this.byteChannel);
        Mat73FileWriterCustom.updateBaseAddress(file);
        Mat73FileWriterCustom.appendHDFData(file, this.byteChannel);
        file.delete();
    }

    public static void appendHDFData(File file, WritableByteChannel writableByteChannel) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8192);
        while (fileChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            byteBuffer.clear();
        }
        fileChannel.close();
        fileInputStream.close();
    }

    public static IHDF5Writer getHDFWriter(File file) {
        IHDF5WriterConfigurator iHDF5WriterConfigurator = HDF5Factory.configure((File)file);
        iHDF5WriterConfigurator = iHDF5WriterConfigurator.fileFormat(IHDF5WriterConfigurator.FileFormat.STRICTLY_1_8);
        return iHDF5WriterConfigurator.writer();
    }

    public static void updateBaseAddress(File file) throws IOException {
    }

    public static int writeMatlabHeader(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        byteBuffer.order(BYTE_ORDER);
        Properties properties = System.getProperties();
        String string = "MATLAB 7.3 MAT-file, Platform: Java " + properties.getProperty("java.version") + " " + properties.getProperty("sun.arch.data.model") + "bit, Created on: " + new SimpleDateFormat("E MMM dd kk:mm:ss yyyy ").format(Calendar.getInstance().getTime()) + "HDF5 schema 1.00 .";
        string = string + new String(new char[116 - string.length()]).replace('\u0000', ' ');
        byte[] byArray = string.getBytes(ASCII_CHARSET);
        byteBuffer.put(byArray);
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byteBuffer.put(byArray2);
        byteBuffer.putShort((short)512);
        byteBuffer.putShort((short)19785);
        byte[] byArray3 = new byte[384];
        byteBuffer.put(byArray3);
        int n = byteBuffer.position();
        byteBuffer.flip();
        writableByteChannel.write(byteBuffer);
        byteBuffer.clear();
        return n;
    }

    private void writeMatrix(File file, double[][][] dArray, String string) {
        this.writeMatrix(null, file, dArray, string);
    }

    private void writeMatrix(File file, int[] nArray, String string) {
        String string2 = "/" + string;
        IHDF5WriterConfigurator iHDF5WriterConfigurator = HDF5Factory.configure((File)file);
        iHDF5WriterConfigurator = iHDF5WriterConfigurator.fileFormat(IHDF5WriterConfigurator.FileFormat.STRICTLY_1_8);
        IHDF5Writer iHDF5Writer = iHDF5WriterConfigurator.writer();
        IHDF5ObjectReadWriteInfoProviderHandler iHDF5ObjectReadWriteInfoProviderHandler = iHDF5Writer.object();
        iHDF5ObjectReadWriteInfoProviderHandler.delete("/__DATA_TYPES__");
        IHDF5IntWriter iHDF5IntWriter = iHDF5Writer.int32();
        long[] lArray = new long[]{nArray.length};
        MDIntArray mDIntArray = new MDIntArray(nArray, lArray);
        HDF5IntStorageFeatures hDF5IntStorageFeatures = HDF5IntStorageFeatures.createDeflation((int)3);
        iHDF5IntWriter.writeMDArray(string2, mDIntArray, hDF5IntStorageFeatures);
        IHDF5StringWriter iHDF5StringWriter = iHDF5Writer.string();
        iHDF5StringWriter.setAttr(string2, "MATLAB_class", "double");
        iHDF5Writer.close();
    }

    private void writeMatrix(ProgressManager progressManager, File file, AbstractDataMatrix abstractDataMatrix, String string, int n) {
        long l;
        IHDF5Writer iHDF5Writer = Mat73FileWriterCustom.getHDFWriter(file);
        String string2 = "/" + string;
        IHDF5ObjectReadWriteInfoProviderHandler iHDF5ObjectReadWriteInfoProviderHandler = iHDF5Writer.object();
        iHDF5ObjectReadWriteInfoProviderHandler.delete("/__DATA_TYPES__");
        IHDF5DoubleWriter iHDF5DoubleWriter = iHDF5Writer.float64();
        FoldMatrix foldMatrix = (FoldMatrix)abstractDataMatrix;
        long[] lArray = Mat73FileWriterCustom.getDimensions(abstractDataMatrix);
        long l2 = l = n < 0 ? lArray[0] : 1L;
        if (lArray[0] * lArray[1] * lArray[2] < 250000000L) {
            String string3 = string2;
            MDDoubleArray mDDoubleArray = new MDDoubleArray(lArray);
            int n2 = 0;
            while ((long)n2 < l) {
                foldMatrix.setFold(n < 0 ? n2 : n);
                for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                    for (int j = 0; j < abstractDataMatrix.getK(); ++j) {
                        mDDoubleArray.set(foldMatrix.getValue(i, j), n2, j, i);
                    }
                }
                progressManager.incStep();
                ++n2;
            }
            HDF5FloatStorageFeatures hDF5FloatStorageFeatures = HDF5FloatStorageFeatures.createDeflation((int)3);
            iHDF5DoubleWriter.writeMDArray(string3, mDDoubleArray, hDF5FloatStorageFeatures);
            IHDF5StringWriter iHDF5StringWriter = iHDF5Writer.string();
            iHDF5StringWriter.setAttr(string3, "MATLAB_class", "double");
        } else {
            int n3 = 0;
            while ((long)n3 < l) {
                String string4 = string2 + n3;
                MDDoubleArray mDDoubleArray = new MDDoubleArray(new long[]{abstractDataMatrix.getK(), abstractDataMatrix.getN()});
                foldMatrix.setFold(n < 0 ? n3 : n);
                for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                    for (int j = 0; j < abstractDataMatrix.getK(); ++j) {
                        try {
                            mDDoubleArray.set(foldMatrix.getValue(i, j), j, i);
                            continue;
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndReportException(exception);
                        }
                    }
                }
                HDF5FloatStorageFeatures hDF5FloatStorageFeatures = HDF5FloatStorageFeatures.createDeflation((int)3);
                iHDF5DoubleWriter.writeMDArray(string4, mDDoubleArray, hDF5FloatStorageFeatures);
                IHDF5StringWriter iHDF5StringWriter = iHDF5Writer.string();
                iHDF5StringWriter.setAttr(string4, "MATLAB_class", "double");
                progressManager.incStep();
                ++n3;
            }
        }
        iHDF5Writer.close();
    }

    private void writeMatrix(ProgressManager progressManager, File file, double[][][] dArray, String string) {
        IHDF5Writer iHDF5Writer = Mat73FileWriterCustom.getHDFWriter(file);
        String string2 = "/" + string;
        IHDF5ObjectReadWriteInfoProviderHandler iHDF5ObjectReadWriteInfoProviderHandler = iHDF5Writer.object();
        iHDF5ObjectReadWriteInfoProviderHandler.delete("/__DATA_TYPES__");
        IHDF5DoubleWriter iHDF5DoubleWriter = iHDF5Writer.float64();
        long[] lArray = Mat73FileWriterCustom.getDimensions(dArray);
        if (lArray[0] * lArray[1] * lArray[2] < 0L) {
            String string3 = string2;
            MDDoubleArray mDDoubleArray = new MDDoubleArray(lArray);
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    for (int k = 0; k < dArray[0][0].length; ++k) {
                        mDDoubleArray.set(dArray[i][j][k], i, k, j);
                    }
                }
                if (progressManager == null) continue;
                progressManager.incStep();
            }
            HDF5FloatStorageFeatures hDF5FloatStorageFeatures = HDF5FloatStorageFeatures.createDeflation((int)3);
            iHDF5DoubleWriter.writeMDArray(string3, mDDoubleArray, hDF5FloatStorageFeatures);
            IHDF5StringWriter iHDF5StringWriter = iHDF5Writer.string();
            iHDF5StringWriter.setAttr(string3, "MATLAB_class", "double");
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                String string4 = string2 + i;
                MDDoubleArray mDDoubleArray = new MDDoubleArray(dArray[i]);
                HDF5FloatStorageFeatures hDF5FloatStorageFeatures = HDF5FloatStorageFeatures.createDeflation((int)3);
                iHDF5DoubleWriter.writeMDArray(string4, mDDoubleArray, hDF5FloatStorageFeatures);
                IHDF5StringWriter iHDF5StringWriter = iHDF5Writer.string();
                iHDF5StringWriter.setAttr(string4, "MATLAB_class", "double");
            }
        }
        iHDF5Writer.close();
    }
}

