/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataexport.matlab;

import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatlabIOException;
import com.jmatio.io.OSArrayTag;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLSparse;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Set;
import java.util.TreeSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.AbstractMVmatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;

public class MatFileWriterCustom {
    private FileOutputStream stream;
    private WritableByteChannel channel = null;
    private boolean writeMissingValues = true;
    private boolean headerWritten = false;
    private final Set<String> varNames = new TreeSet<String>();
    private final int type = 5;

    public MatFileWriterCustom(File file) throws IOException {
        this.stream = new FileOutputStream(file);
        this.channel = this.stream.getChannel();
    }

    public MatFileWriterCustom(String string) throws IOException {
        this(new File(string));
    }

    public synchronized void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public synchronized void write(MLArray mLArray, AbstractDataMatrix abstractDataMatrix, boolean bl, boolean bl2) throws IOException {
        this.writeMissingValues = bl2;
        String string = mLArray.getName();
        if (this.varNames.contains(string)) {
            throw new IllegalArgumentException("Error: variable " + string + " specified more than once for file input.");
        }
        if (!this.headerWritten) {
            this.writeHeader(this.channel);
        }
        this.writeMatrix(mLArray, abstractDataMatrix);
    }

    private void write2DMatrix(AbstractDataMatrix abstractDataMatrix, ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.writeMissingValues) {
            n4 = 0;
            n3 = abstractDataMatrix.getN();
            n2 = abstractDataMatrix.getK();
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    if (abstractDataMatrix.isMissing(i, n)) continue;
                    ++n4;
                }
            }
            byteBuffer.putInt(n4 * 8);
        } else {
            byteBuffer.putInt(abstractDataMatrix.getDataSize() * 8);
        }
        n4 = abstractDataMatrix.getN();
        n3 = abstractDataMatrix.getK();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (!this.writeMissingValues && abstractDataMatrix.isMissing(n, n2)) continue;
                byteBuffer.putDouble(abstractDataMatrix.getValue(n, n2));
                if (byteBuffer.remaining() >= 8) continue;
                byteBuffer.flip();
                this.channel.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        byteBuffer.flip();
        this.channel.write(byteBuffer);
    }

    private void writeDimensions(DataOutputStream dataOutputStream, MLArray mLArray) throws IOException {
        int[] nArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        for (int n : nArray = mLArray.getDimensions()) {
            dataOutputStream2.writeInt(n);
        }
        OSArrayTag oSArrayTag = new OSArrayTag(5, byteArrayOutputStream.toByteArray());
        oSArrayTag.writeTo(dataOutputStream);
    }

    private void writeFlags(DataOutputStream dataOutputStream, MLArray mLArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeInt(mLArray.getFlags());
        if (mLArray.isSparse()) {
            dataOutputStream2.writeInt(((MLSparse)mLArray).getMaxNZ());
        } else {
            dataOutputStream2.writeInt(0);
        }
        OSArrayTag oSArrayTag = new OSArrayTag(6, byteArrayOutputStream.toByteArray());
        oSArrayTag.writeTo(dataOutputStream);
    }

    private void writeFoldMatrix(FoldMatrix foldMatrix, ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putInt(foldMatrix.getDataSize() * 8 * foldMatrix.getFoldsize());
        for (int i = 0; i < foldMatrix.getFoldsize(); ++i) {
            foldMatrix.setFold(i);
            int n = foldMatrix.getN();
            int n2 = foldMatrix.getK();
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    byteBuffer.putDouble(foldMatrix.getValue(k, j));
                    if (byteBuffer.remaining() >= 8) continue;
                    byteBuffer.flip();
                    this.channel.write(byteBuffer);
                    byteBuffer.clear();
                }
            }
        }
        byteBuffer.flip();
        this.channel.write(byteBuffer);
    }

    private void writeHeader(WritableByteChannel writableByteChannel) throws IOException {
        MatFileHeader matFileHeader = MatFileHeader.createHeader();
        char[] cArray = new char[116];
        char[] cArray2 = matFileHeader.getDescription().toCharArray();
        System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
        byte[] byArray = matFileHeader.getEndianIndicator();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(cArray.length * 2 + 2 + byArray.length);
        for (char c : cArray) {
            byteBuffer.put((byte)c);
        }
        byteBuffer.position(byteBuffer.position() + 8);
        int n = matFileHeader.getVersion();
        byteBuffer.put((byte)(n >> 8));
        byteBuffer.put((byte)n);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        writableByteChannel.write(byteBuffer);
        this.headerWritten = true;
    }

    private void writeLayerMatrix(LayerMatrix layerMatrix, ByteBuffer byteBuffer) throws IOException {
        AbstractDataMatrix abstractDataMatrix = layerMatrix.getMatrixAt(0);
        byteBuffer.putInt(abstractDataMatrix.getDataSize() * 8 * layerMatrix.getFoldsize());
        for (int i = 0; i < layerMatrix.getFoldsize(); ++i) {
            AbstractDataMatrix abstractDataMatrix2 = layerMatrix.getMatrixAt(i);
            int n = abstractDataMatrix2.getN();
            int n2 = abstractDataMatrix2.getK();
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    byteBuffer.putDouble(abstractDataMatrix2.getValue(k, j));
                    if (byteBuffer.remaining() >= 8) continue;
                    byteBuffer.flip();
                    this.channel.write(byteBuffer);
                    byteBuffer.clear();
                }
            }
        }
        byteBuffer.flip();
        this.channel.write(byteBuffer);
        byteBuffer.clear();
    }

    private void writeMatrix(MLArray mLArray, AbstractDataMatrix abstractDataMatrix) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeFlags(dataOutputStream, mLArray);
        this.writeDimensions(dataOutputStream, mLArray);
        this.writeName(dataOutputStream, mLArray);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0x100000);
        byteBuffer.putInt(14);
        int n = abstractDataMatrix.getOrigSize(1);
        int n2 = abstractDataMatrix.getOrigSize(2);
        byteBuffer.putInt(byteArrayOutputStream.size() + (n > n2 ? n : n2) * abstractDataMatrix.getFoldsize() * 8 + 8);
        byteBuffer.put(byteArrayOutputStream.toByteArray());
        byteBuffer.flip();
        this.channel.write(byteBuffer);
        byteBuffer.clear();
        if (mLArray.getType() != 6) {
            throw new MatlabIOException("Cannot write matrix of type: " + MLArray.typeToString((int)mLArray.getType()));
        }
        byteBuffer.putInt(9);
        if (abstractDataMatrix instanceof LayerMatrix) {
            this.writeLayerMatrix((LayerMatrix)abstractDataMatrix, byteBuffer);
        } else if (abstractDataMatrix instanceof FoldMatrix) {
            this.writeFoldMatrix((FoldMatrix)abstractDataMatrix, byteBuffer);
        } else if (abstractDataMatrix instanceof AbstractMVmatrix && !abstractDataMatrix.isFoldable() || !abstractDataMatrix.isFoldable() || !this.writeMissingValues) {
            this.write2DMatrix(abstractDataMatrix, byteBuffer);
        } else {
            FoldMatrix foldMatrix = new FoldMatrix(abstractDataMatrix);
            this.writeFoldMatrix(foldMatrix, byteBuffer);
            foldMatrix.cleanUp();
        }
    }

    private void writeName(DataOutputStream dataOutputStream, MLArray mLArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = mLArray.getNameToByteArray();
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.write(byArray);
        OSArrayTag oSArrayTag = new OSArrayTag(1, byteArrayOutputStream.toByteArray());
        oSArrayTag.writeTo(dataOutputStream);
    }
}

