/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.performace.IndexCache;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.propagation.PropagationInterface;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.MemoryInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.event.DataMatrixEvent;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.simpletableeditor.CMModifierInterface;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractDataSource
extends CellIdentifierModel
implements DataTreeInterface,
MemoryInterface,
PropagationInterface {
    public static final ImageIcon datasourceIcon = AbstractPaint.createIcon(12);
    protected byte mergeType;
    private Vector<DataTreeInterface> treeVector = new Vector();
    private Integer layerID;
    private DataTreeInterface nodeParent;
    private DataTreeManager dataTreeManager;
    protected boolean isloaded = false;
    protected long blockBegin = -1L;
    private int saveIndex = -1;
    private File saveFile;
    private long lastused;
    private int[] dataRefRow;
    private int[] dataRefCol;
    protected boolean refreshing = false;
    protected IndexCache[] valueCache = null;
    private Case dataSetContainer;
    private boolean isprotected = false;
    private boolean haschanged = false;
    private boolean ismanual = true;

    public AbstractDataSource(byte by) {
        super(0, 0);
        this.mergeType = by;
        this.isloaded = true;
    }

    public AbstractDataSource(int n, int n2) {
        super(n, n2);
        this.isloaded = true;
    }

    public AbstractDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.blockBegin = randomInputStream.getFilePointer();
        this.saveFile = randomInputStream.getFile();
        this.isloaded = false;
        this.layerID = randomInputStream.getDataTreeManager().addUniqueID(randomInputStream.getCT().id, this);
        this.dataSetContainer = (Case)mapProperty.resolveNodeFromName(randomInputStream, "dsc");
        if (mapProperty.hasProperty("mT")) {
            this.mergeType = mapProperty.getLVByte();
        }
        if (mapProperty.hasProperty("locked")) {
            this.isprotected = mapProperty.getLVBoolean();
        }
        if (mapProperty.hasProperty("hc")) {
            this.haschanged = mapProperty.getLVBoolean();
        }
        if (mapProperty.hasProperty("manual")) {
            this.ismanual = mapProperty.getLVBoolean();
        }
    }

    @Override
    public void addDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public void addPostModifier(CMModifierInterface cMModifierInterface) {
        if (!this.containsTreeNode(cMModifierInterface)) {
            this.addTreeNode(cMModifierInterface);
        }
    }

    @Override
    public void addShortcut(DataTreeInterface dataTreeInterface) {
        this.treeVector.addElement(dataTreeInterface);
    }

    @Override
    public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
        if (this.dataSetContainer != null && this.dataSetContainer.isDataSource()) {
            CMenuItem cMenuItem = new CMenuItem("Apply Changes", new ImageIcon(Main_GUI.class.getResource("gif/update.png")));
            cMenuItem.addActionListener(actionEvent -> this.doUpdate(null));
            jPopupMenu.add(cMenuItem);
        }
        return true;
    }

    public void addToPopupMenu(Project_GUI project_GUI, JPopupMenu jPopupMenu) {
        final Case case_ = (Case)DataTreeManager.getAncestorNull(this, Case.class);
        AbstractDataMatrix abstractDataMatrix = case_.getOriginalMatrix();
        byte by = abstractDataMatrix.getMemoryState();
        CMenuItem cMenuItem = new CMenuItem((Object)project_GUI, true);
        cMenuItem.setText("Load from data source");
        cMenuItem.addActionListener(actionEvent -> {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){

                @Override
                public Object doWork() {
                    try {
                        case_.changeState(this, "keepdatainmemory", null);
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                    }
                    return null;
                }
            };
            progressManagerImpl.invokeLater();
        });
        cMenuItem.setEnabled(by == 2);
        jPopupMenu.add(cMenuItem);
        CMenuItem cMenuItem2 = new CMenuItem((Object)project_GUI, true);
        cMenuItem2.setText("Clear data from memory");
        cMenuItem2.addActionListener(actionEvent -> {
            ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){

                @Override
                public Object doWork() {
                    try {
                        case_.changeState(this, "keepdataondisk", null);
                    }
                    catch (Exception exception) {
                        ErrorHandler.logAndReportException(exception);
                    }
                    return null;
                }
            };
            progressManagerImpl.invokeLater();
        });
        cMenuItem2.setEnabled(by != 2);
        jPopupMenu.add(cMenuItem2);
    }

    @Override
    public void addTreeNode(DataTreeInterface dataTreeInterface) {
        dataTreeInterface.setTreeParent(this);
        this.treeVector.addElement(dataTreeInterface);
    }

    @Override
    public void applyModifier(ProgressManager progressManager, AbstractDataMatrix abstractDataMatrix) {
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof CMModifierInterface)) continue;
            CMModifierInterface cMModifierInterface = (CMModifierInterface)dataTreeInterface;
            cMModifierInterface.applyModifier(progressManager, this, abstractDataMatrix);
        }
    }

    @Override
    public void beginCalculations() {
    }

    @Override
    public void ClearFromMemory() throws IOException {
        this.ClearDataLocal();
        this.isloaded = false;
    }

    @Override
    public boolean containsTreeNode(DataTreeInterface dataTreeInterface) {
        return this.treeVector.contains(dataTreeInterface);
    }

    @Override
    public void doUpdate(ProgressManager progressManager) {
        if (!this.isprotected) {
            if (progressManager == null) {
                progressManager = new ProgressManagerImpl(){

                    @Override
                    public Object doWork() {
                        AbstractDataSource.this.doUpdateLocal(this);
                        return null;
                    }
                };
                progressManager.invokeLater();
            } else {
                this.doUpdateLocal(progressManager);
            }
        }
    }

    @Override
    public void endCalculations() {
    }

    @Override
    public long getBlockBegin() {
        return this.blockBegin;
    }

    public Case getCase() {
        return this.dataSetContainer;
    }

    public Object getColumnValueAt(int n, int n2) {
        if (this.dataRefCol != null) {
            return this.getValueAt(n, this.dataRefCol[n2]);
        }
        return "MV";
    }

    @Override
    public int getDataByteSize() {
        return 1000;
    }

    public int getDataColumnCount() {
        if (this.dataRefCol == null) {
            return 0;
        }
        return this.dataRefCol.length;
    }

    public int getDataRowCount() {
        if (this.dataRefRow == null) {
            return 0;
        }
        return this.dataRefRow.length;
    }

    @Override
    public int getDataSize() {
        return 1000;
    }

    public File getDataSourceFile() {
        return null;
    }

    @Override
    public DataTreeManager getDataTreeManager() {
        if (this.dataTreeManager == null && this.nodeParent != null) {
            this.setDataTreeManager(this.nodeParent.getDataTreeManager(), false);
        }
        return this.dataTreeManager;
    }

    public final FastDecimal getDataValueAt(int n, int n2, FastDecimal fastDecimal) {
        if (this.dataRefRow != null && this.dataRefCol != null) {
            return this.getDoubleAt(this.dataRefRow[n], this.dataRefCol[n2], fastDecimal);
        }
        return null;
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return datasourceIcon;
    }

    @Override
    public Integer getID() {
        if (this.layerID == null && this.getDataTreeManager() != null) {
            this.layerID = this.dataTreeManager.addUniqueID(null, this);
        }
        return this.layerID;
    }

    @Override
    public long getLastUsed() {
        return this.lastused;
    }

    @Override
    public byte getMemoryState() {
        if (this.isloaded) {
            return 0;
        }
        return 1;
    }

    public byte getMergeType() {
        return this.mergeType;
    }

    public abstract String getName();

    @Override
    public byte getNodeType() {
        return 10;
    }

    public Object getRowValueAt(int n, int n2) {
        if (this.dataRefRow != null) {
            return this.getValueAt(this.dataRefRow[n], n2);
        }
        return "MV";
    }

    @Override
    public File getSaveFile() {
        return this.saveFile;
    }

    @Override
    public int getSaveIndex() {
        return this.saveIndex;
    }

    @Override
    public String getToolTipText() {
        return this.toString();
    }

    @Override
    public DataTreeInterface getTreeNodeAt(int n) {
        return this.treeVector.elementAt(n);
    }

    @Override
    public int getTreeNodeCount() {
        if (this.treeVector != null) {
            return this.treeVector.size();
        }
        return 0;
    }

    @Override
    public DataTreeInterface getTreeParent() {
        return this.nodeParent;
    }

    @Override
    public boolean hasChanged() {
        return this.haschanged;
    }

    @Override
    public void insertTreeNode(DataTreeInterface dataTreeInterface) {
        this.treeVector.insertElementAt(dataTreeInterface, 0);
    }

    @Override
    public boolean isCalculating() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        if (this.treeVector != null) {
            return this.treeVector.isEmpty();
        }
        return true;
    }

    @Override
    public boolean isLoaded() {
        return this.isloaded;
    }

    @Override
    public boolean isManual() {
        return this.ismanual;
    }

    @Override
    public boolean isMemoryState(byte by) {
        return this.isloaded == (by == 0);
    }

    @Override
    public boolean isNode() {
        return !this.isLeaf();
    }

    @Override
    public boolean isProtected() {
        return this.isprotected;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    @Override
    public boolean isSupportClearMemory() {
        return false;
    }

    @Override
    public boolean isVisibleInTree() {
        return RegisterKeyManager.isPredikteraDevelopmentLicense();
    }

    @Override
    public void LoadIntoMemory(RandomInputStream randomInputStream) throws IOException {
        randomInputStream.seek(this.blockBegin);
        if (randomInputStream.beginDataBlock("Loading " + String.valueOf(this) + " into memory", false)) {
            this.isloaded = true;
            this.LoadDataLocal(randomInputStream);
            randomInputStream.endDataBlock();
        }
    }

    public void reCalcRef() {
        int n;
        int n2;
        int n3 = this.analyzeObs();
        int n4 = this.analyzeVar();
        if (n3 != this.getDataRowCount()) {
            this.dataRefRow = new int[n3];
            n2 = 0;
            for (n = 0; n < this.getRowCount(); ++n) {
                if (!this.isRowTypeData(n)) continue;
                this.dataRefRow[n2++] = n;
            }
        }
        if (n4 != this.getDataColumnCount()) {
            this.dataRefCol = new int[n4];
            n2 = 0;
            for (n = 0; n < this.getColumnCount(); ++n) {
                if (!this.isColumnTypeData(n)) continue;
                this.dataRefCol[n2++] = n;
            }
        }
    }

    public abstract void refreshDataSourceLocal(ProgressManager var1) throws IOException;

    @Override
    public void removeDataTreeChangeListener(DataTreeListener dataTreeListener) {
    }

    @Override
    public boolean removeTreeNode(DataTreeInterface dataTreeInterface) {
        if (this.treeVector != null) {
            return this.treeVector.removeElement(dataTreeInterface);
        }
        return false;
    }

    public void removeTreeNodeAt(int n) {
        if (this.treeVector != null) {
            this.treeVector.removeElementAt(n);
        }
    }

    public DataTreeInterface replaceNode(DataTreeInterface dataTreeInterface, DataTreeInterface dataTreeInterface2, boolean bl) {
        int n = this.treeVector.indexOf(dataTreeInterface);
        if (n >= 0) {
            if (dataTreeInterface2 != null) {
                if (dataTreeInterface instanceof DataTreeClass) {
                    DataTreeEvent dataTreeEvent = new DataTreeEvent((Object)this, dataTreeInterface, dataTreeInterface2);
                    ((DataTreeClass)dataTreeInterface).triggerReplaceEvent(dataTreeEvent);
                    dataTreeEvent.cleanUp();
                }
                this.treeVector.set(n, dataTreeInterface2);
                dataTreeInterface2.setTreeParent(this);
            }
            if (dataTreeInterface != null && bl) {
                dataTreeInterface.cleanUp();
            }
        } else {
            this.addTreeNode(dataTreeInterface2);
        }
        return dataTreeInterface2;
    }

    @Override
    public void SaveData(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
        if (randomOutputStream.isStorePosition()) {
            this.blockBegin = randomOutputStream.getFilePointer();
            this.saveFile = randomOutputStream.getFile();
        }
        randomOutputStream.beginDataBlock();
        this.SaveDataLocal(randomOutputStream);
        randomOutputStream.endDataBlock();
    }

    @Override
    public void SaveProperty(RandomOutputStream randomOutputStream, int n) throws IOException {
        this.saveIndex = n;
        this.SavePropertyLocal(randomOutputStream);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyNode("dsc", this.dataSetContainer);
        randomOutputStream.writePropertyByte("mT", this.mergeType);
        randomOutputStream.writePropertyBoolean("locked", this.isprotected);
        randomOutputStream.writePropertyBoolean("hc", this.haschanged);
        randomOutputStream.writePropertyBoolean("manual", this.ismanual);
    }

    @Override
    public void setBlockBeginning(long l) {
        this.blockBegin = l;
    }

    public void setCase(Case case_) {
        this.dataSetContainer = case_;
    }

    public void setChanged() {
        this.setChanged(null);
    }

    @Override
    public void setChanged(ProgressManager progressManager) {
        this.haschanged = true;
        if (!this.ismanual) {
            this.doUpdate(progressManager);
        }
    }

    public void setChangedNoUpdate() {
        this.haschanged = true;
    }

    public void setColumnValueAt(int n, int n2, Object object) {
        if (this.dataRefCol != null) {
            this.setValueAt(object, n, this.dataRefCol[n2]);
        }
    }

    @Override
    public void setDataTreeManager(DataTreeManager dataTreeManager, boolean bl) {
        if (bl || this.dataTreeManager != null && this.dataTreeManager != dataTreeManager) {
            this.layerID = null;
        }
        this.dataTreeManager = dataTreeManager;
        if (this.layerID == null && this.dataTreeManager != null) {
            this.layerID = this.dataTreeManager.addUniqueID(null, this);
        }
        for (int i = 0; i < this.getTreeNodeCount(); ++i) {
            this.getTreeNodeAt(i).setDataTreeManager(dataTreeManager, bl);
        }
    }

    public final void setDataValueAt(int n, int n2, Object object) {
        if (this.dataRefRow != null && this.dataRefCol != null) {
            this.setValueAt(object, this.dataRefRow[n], this.dataRefCol[n2]);
        }
    }

    @Override
    public void setManual(ProgressManager progressManager, boolean bl) {
        this.ismanual = bl;
        if (!bl) {
            this.doUpdate(progressManager);
        }
    }

    @Override
    public void setProtected(boolean bl) {
        if (this.isprotected != bl) {
            if (bl) {
                this.doUpdate(null);
            }
            this.isprotected = bl;
        }
    }

    public void setRowValueAt(int n, int n2, Object object) {
        if (this.dataRefRow != null) {
            this.setValueAt(object, this.dataRefRow[n], n2);
        }
    }

    @Override
    public void setSaveFile(File file) {
        this.saveFile = file;
    }

    @Override
    public void setTreeParent(DataTreeInterface dataTreeInterface) {
        this.nodeParent = dataTreeInterface;
        if (dataTreeInterface != null && dataTreeInterface.getDataTreeManager() != null) {
            this.dataTreeManager = dataTreeInterface.getDataTreeManager();
            if (this.layerID == null) {
                this.layerID = this.dataTreeManager.addUniqueID(null, this);
            }
            for (int i = 0; i < this.getTreeNodeCount(); ++i) {
                this.getTreeNodeAt(i).setTreeParent(this);
            }
        }
    }

    @Override
    public void swapNodes(int n, int n2) {
        DataTreeInterface dataTreeInterface = this.treeVector.get(n);
        this.treeVector.set(n, this.treeVector.get(n2));
        this.treeVector.set(n2, dataTreeInterface);
    }

    @Override
    public String toString() {
        return this.getName() + " Data File";
    }

    @Override
    protected void cleanUpChild() {
        DataTreeInterface dataTreeInterface;
        super.cleanUpChild();
        while (this.treeVector != null && !this.treeVector.isEmpty() && (dataTreeInterface = this.getTreeNodeAt(0)) != null) {
            if ((this.dataTreeManager == null || this.dataTreeManager.hasDataMask(dataTreeInterface)) && !dataTreeInterface.cleanUp()) continue;
            this.treeVector.removeElementAt(0);
        }
        this.treeVector = null;
        if (this.dataTreeManager != null && this.layerID != null) {
            this.dataTreeManager.removeUniqueID(this.layerID);
            this.dataTreeManager = null;
        }
        this.layerID = null;
        if (this.nodeParent != null) {
            this.nodeParent.removeTreeNode(this);
            this.nodeParent = null;
        }
        this.dataSetContainer = null;
    }

    @Override
    protected void ClearDataLocal() throws IOException {
        super.ClearDataLocal();
        this.dataRefRow = null;
        this.dataRefCol = null;
    }

    @Override
    protected void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        int n;
        super.LoadDataLocal(randomInputStream);
        int n2 = randomInputStream.ReadBlockInt();
        this.dataRefCol = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.dataRefCol[n] = randomInputStream.ReadBlockInt();
        }
        n = randomInputStream.ReadBlockInt();
        this.dataRefRow = new int[n];
        for (int i = 0; i < n; ++i) {
            this.dataRefRow[i] = randomInputStream.ReadBlockInt();
        }
    }

    @Override
    protected void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        int n;
        int n2;
        super.SaveDataLocal(randomOutputStream);
        if (this.dataRefCol != null) {
            n2 = this.dataRefCol.length;
            randomOutputStream.WriteBlockInt(n2);
            for (n = 0; n < n2; ++n) {
                randomOutputStream.WriteBlockInt(this.dataRefCol[n]);
            }
        } else {
            randomOutputStream.WriteBlockInt(0);
        }
        if (this.dataRefRow != null) {
            n2 = this.dataRefRow.length;
            randomOutputStream.WriteBlockInt(n2);
            for (n = 0; n < n2; ++n) {
                randomOutputStream.WriteBlockInt(this.dataRefRow[n]);
            }
        } else {
            randomOutputStream.WriteBlockInt(0);
        }
    }

    protected void updateFinished() {
    }

    private void doUpdateLocal(ProgressManager progressManager) {
        if (this.dataSetContainer != null) {
            progressManager.setInfoText("Applying changes");
            try {
                this.refreshing = true;
                AbstractDataMatrix abstractDataMatrix = this.dataSetContainer.getOriginalMatrix();
                if (abstractDataMatrix != null) {
                    int n = abstractDataMatrix.getN();
                    int n2 = abstractDataMatrix.getK();
                    if (this.valueCache != null) {
                        for (IndexCache indexCache : this.valueCache) {
                            indexCache.flushCache();
                        }
                    }
                    this.refreshDataSourceLocal(progressManager);
                    this.reCalcRef();
                    this.resize();
                    abstractDataMatrix.refreshModel();
                    this.updateFinished();
                    this.fireTableStructureChanged();
                    DataMatrixEvent dataMatrixEvent = new DataMatrixEvent((Object)abstractDataMatrix, abstractDataMatrix);
                    dataMatrixEvent.setProgressManager(progressManager);
                    if (n != abstractDataMatrix.getN() || n2 != abstractDataMatrix.getK()) {
                        dataMatrixEvent.Structurechanged(n, n2);
                    }
                    abstractDataMatrix.triggerEvent(dataMatrixEvent);
                }
                this.refreshing = false;
                this.haschanged = false;
            }
            catch (IOException iOException) {
                this.refreshing = false;
            }
        }
    }
}

