/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.ImageIcon;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.performace.IndexCache;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.components.paint.AbstractPaint;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;

public abstract class AbstractFileDataSource
extends AbstractDataSource {
    protected static final int buff_size = 8192;
    protected static ImageIcon datasourceIcon = AbstractPaint.createIcon(12);
    protected File[] files;
    protected RandomAccessFile[] channels;
    protected byte[][] buf;
    protected byte mergeType;
    protected long[] bufstart;
    protected long[] bufend;
    protected int curchannel;
    protected byte[] sarray = new byte[16383];
    protected short sindex;
    protected boolean includeFileNames = false;
    private int cRow;
    private int cCol;
    private int[] startIndex;
    private int[] endIndex;

    public AbstractFileDataSource(File[] fileArray, byte by) throws IOException {
        this(fileArray, by, false);
    }

    public AbstractFileDataSource(File[] fileArray, byte by, boolean bl) throws IOException {
        super(by);
        this.set(fileArray, by, bl);
    }

    public AbstractFileDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        if (mapProperty.hasProperty("fnr")) {
            int n = mapProperty.getLVInt();
            this.files = new File[n];
            for (int i = 0; i < n; ++i) {
                if (!mapProperty.hasProperty("file" + i)) continue;
                this.files[i] = new File(mapProperty.getLVStringUTF());
            }
        }
        if (mapProperty.hasProperty("si")) {
            this.startIndex = mapProperty.getLVIntArray();
        }
        if (mapProperty.hasProperty("ei")) {
            this.endIndex = mapProperty.getLVIntArray();
        }
        this.includeFileNames = mapProperty.getPropertyBoolean("ifn");
        this.init();
    }

    @Override
    public void closeConnections() {
        this.closeChannels();
        this.sarray = null;
        this.buf = null;
    }

    public int getColumnsForChannel(int n) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (!this.refreshing && this.isloaded) {
            AbstractFileDataSource abstractFileDataSource = this;
            synchronized (abstractFileDataSource) {
                try {
                    if (this.setCurrentChannel(n, n2)) {
                        return fastDecimal.error();
                    }
                    int n3 = this.getLength(this.cRow, this.cCol);
                    if (n3 > 0) {
                        long l = this.getIndex(this.cRow, this.cCol);
                        long l2 = l + (long)n3;
                        this.sindex = 0;
                        for (long i = l; i < l2 && this.sindex < this.sarray.length; ++i) {
                            short s = this.sindex;
                            this.sindex = (short)(s + 1);
                            this.sarray[s] = this.readByte(i);
                        }
                        fastDecimal.parseString(this.sarray, this.sindex);
                        return fastDecimal;
                    }
                    return fastDecimal.error();
                }
                catch (IOException iOException) {
                }
            }
        }
        return fastDecimal.error();
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        for (int i = 0; i < this.files.length; ++i) {
            stringBuilder.append("<tr><td>File ");
            stringBuilder.append(i + 1);
            stringBuilder.append(":&nbsp;</td><td>");
            stringBuilder.append(this.files[i].getName());
            stringBuilder.append("</td></tr>");
        }
        return stringBuilder.toString();
    }

    @Override
    public int getLayerCount() {
        if (this.mergeType == 4) {
            return this.files.length;
        }
        return super.getLayerCount();
    }

    @Override
    public String getLayerName(int n) {
        return this.files[n].getName();
    }

    @Override
    public File getRootFolder() {
        if (this.files != null && this.files.length > 0) {
            return this.files[0].getParentFile();
        }
        return null;
    }

    public int getRowsForChannel(int n) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getValueAt_Transpose(int n, int n2) {
        if (!this.refreshing && this.isloaded) {
            AbstractFileDataSource abstractFileDataSource = this;
            synchronized (abstractFileDataSource) {
                try {
                    if (this.setCurrentChannel(n, n2)) {
                        return this.files[this.curchannel].getName();
                    }
                    int n3 = this.getLength(this.cRow, this.cCol);
                    if (n3 > 0) {
                        long l = this.getIndex(this.cRow, this.cCol);
                        Object object = this.valueCache[this.curchannel].get(l);
                        if (object == null) {
                            long l2 = l + (long)n3;
                            this.sindex = 0;
                            for (long i = l; i < l2 && this.sindex < this.sarray.length; ++i) {
                                short s = this.sindex;
                                this.sindex = (short)(s + 1);
                                this.sarray[s] = this.readByte(i);
                            }
                            object = new String(this.sarray, 0, (int)this.sindex);
                            this.valueCache[this.curchannel].put(l, object);
                        }
                        return object;
                    }
                    return "MV";
                }
                catch (IOException iOException) {
                }
            }
        }
        return "1.0";
    }

    @Override
    public abstract void refreshDataSourceLocal(ProgressManager var1) throws IOException;

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyInt("fnr", this.files.length);
        for (int i = 0; i < this.files.length; ++i) {
            randomOutputStream.writePropertyStringUTF("file" + i, this.files[i].getAbsolutePath());
        }
        randomOutputStream.writePropertyIntArray("si", this.startIndex);
        randomOutputStream.writePropertyIntArray("ei", this.endIndex);
        randomOutputStream.writePropertyBoolean("ifn", this.includeFileNames);
    }

    public void set(File[] fileArray, byte by, boolean bl) throws IOException {
        this.files = fileArray;
        this.mergeType = by;
        this.includeFileNames = bl;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentLayer(int n) {
        AbstractFileDataSource abstractFileDataSource = this;
        synchronized (abstractFileDataSource) {
            this.curchannel = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setValueAt_Transpose(Object object, int n, int n2) {
        if (!this.refreshing && this.isloaded) {
            AbstractFileDataSource abstractFileDataSource = this;
            synchronized (abstractFileDataSource) {
                try {
                    if (this.setCurrentChannel(n, n2)) {
                        return;
                    }
                    int n3 = this.getLength(this.cRow, this.cCol);
                    long l = this.getIndex(this.cRow, this.cCol);
                    String string = object.toString();
                    int n4 = string.length();
                    if (n4 != n3) {
                        this.setLength(this.cRow, this.cCol, n4);
                        this.shuffle((int)l, n4 - n3);
                    }
                    this.writeBytes((int)l, string.getBytes());
                    this.valueCache[this.curchannel].flushCache();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.closeConnections();
    }

    protected abstract long getIndex(int var1, int var2);

    protected abstract int getLength(int var1, int var2);

    protected boolean setCurrentChannel(int n, int n2) {
        this.cRow = n;
        this.cCol = n2--;
        if (this.channels.length > 1 && this.mergeType != 4) {
            boolean bl = false;
            if (this.includeFileNames) {
                if (this.mergeType == 1 && (this.cCol = n2) < 0) {
                    n2 = 0;
                    bl = true;
                } else if (this.mergeType == 2 && (this.cRow = --n) < 0) {
                    n = 0;
                    bl = true;
                }
            }
            int n3 = this.curchannel;
            if (this.mergeType == 1) {
                if (n < this.startIndex[this.curchannel]) {
                    while (n < this.startIndex[this.curchannel]) {
                        --this.curchannel;
                    }
                } else if (n > this.endIndex[this.curchannel]) {
                    while (n > this.endIndex[this.curchannel]) {
                        ++this.curchannel;
                    }
                }
                this.cRow = n - this.startIndex[this.curchannel];
            } else if (this.mergeType == 2) {
                if (n2 < this.startIndex[this.curchannel]) {
                    while (n2 < this.startIndex[this.curchannel]) {
                        --this.curchannel;
                    }
                } else if (n2 > this.endIndex[this.curchannel]) {
                    while (n2 > this.endIndex[this.curchannel]) {
                        ++this.curchannel;
                    }
                }
                this.cCol = n2 - this.startIndex[this.curchannel];
            }
            if (n3 != this.curchannel) {
                this.bufstart[this.curchannel] = 0L;
                this.bufend[this.curchannel] = 0L;
            }
            return bl;
        }
        return false;
    }

    protected abstract void setLength(int var1, int var2, int var3);

    @Override
    protected void updateFinished() {
        this.resetBufIndex();
        int n = 0;
        this.startIndex = new int[this.channels.length];
        this.endIndex = new int[this.channels.length];
        for (int i = 0; i < this.channels.length; ++i) {
            this.startIndex[i] = n;
            switch (this.mergeType) {
                case 1: {
                    n += this.getRowsForChannel(i);
                    break;
                }
                case 2: {
                    n += this.getColumnsForChannel(i);
                }
            }
            this.endIndex[i] = n - 1;
        }
    }

    private void closeChannels() {
        if (this.channels != null) {
            try {
                for (RandomAccessFile randomAccessFile : this.channels) {
                    if (randomAccessFile == null) continue;
                    randomAccessFile.close();
                }
                this.channels = null;
            }
            catch (IOException iOException) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(iOException);
            }
        }
    }

    private void init() throws IOException {
        if (this.channels != null) {
            this.closeChannels();
        }
        if (this.files != null) {
            int n;
            this.channels = new RandomAccessFile[this.files.length];
            for (n = 0; n < this.files.length; ++n) {
                try {
                    this.channels[n] = new RandomAccessFile(this.files[n], "rw");
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.channels[n] = new RandomAccessFile(this.files[n], "r");
                }
            }
            this.buf = new byte[this.channels.length][8192];
            this.bufstart = new long[this.channels.length];
            this.bufend = new long[this.channels.length];
            this.valueCache = new IndexCache[this.channels.length];
            for (n = 0; n < this.valueCache.length; ++n) {
                this.valueCache[n] = new IndexCache(25);
            }
        }
    }

    private final synchronized byte readByte(long l) throws IOException {
        if (l < this.bufstart[this.curchannel] || l >= this.bufend[this.curchannel]) {
            this.bufstart[this.curchannel] = l;
            this.channels[this.curchannel].seek(this.bufstart[this.curchannel]);
            this.bufend[this.curchannel] = this.bufstart[this.curchannel] + (long)this.channels[this.curchannel].read(this.buf[this.curchannel]);
        }
        try {
            return this.buf[this.curchannel][(int)(l - this.bufstart[this.curchannel])];
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return 0;
        }
    }

    private void resetBufIndex() {
        for (int i = 0; i < this.channels.length; ++i) {
            this.bufstart[i] = 0L;
            this.bufend[i] = 0L;
        }
        this.curchannel = 0;
    }

    private final synchronized void shuffle(int n, int n2) throws IOException {
        int n3 = (int)this.channels[this.curchannel].length();
        int n4 = 8192;
        if (n2 < 0) {
            int n5 = n;
            while (n4 > 0) {
                if (n5 + n4 >= n3) {
                    n4 = n3 - n5;
                }
                if (n5 + n2 < n) {
                    n5 -= n2;
                    n4 += n2;
                }
                this.writeBuffert(n4, n5, n2);
                n5 += n4;
            }
            this.channels[this.curchannel].setLength(n3 + n2);
        } else {
            int n6 = n3;
            while (n4 > 0) {
                if ((n6 -= n4) < n) {
                    n4 -= n - n6;
                    n6 = n;
                }
                this.writeBuffert(n4, n6, n2);
            }
        }
        this.bufstart[this.curchannel] = 0L;
        this.bufend[this.curchannel] = 0L;
    }

    private void writeBuffert(int n, int n2, int n3) throws IOException {
        if (n > 0) {
            this.channels[this.curchannel].seek(n2);
            this.channels[this.curchannel].read(this.buf[this.curchannel], 0, n);
            if (n2 + n3 < 0) {
                this.channels[this.curchannel].seek(0L);
                this.channels[this.curchannel].write(this.buf[this.curchannel], -n3, n + n3);
            } else {
                this.channels[this.curchannel].seek(n2 + n3);
                this.channels[this.curchannel].write(this.buf[this.curchannel], 0, n);
            }
        }
    }

    private final synchronized void writeBytes(int n, byte[] byArray) throws IOException {
        this.channels[this.curchannel].seek(n);
        this.channels[this.curchannel].write(byArray);
        this.bufstart[this.curchannel] = 0L;
        this.bufend[this.curchannel] = 0L;
    }
}

