/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.io.File;
import java.util.List;
import java.util.Properties;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.analysis.AbstractAnalysisInfo;
import se.prediktera.map.model.modelgenerator.ModelInit;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractImportInfo
extends AbstractInfo {
    protected AbstractImportPanel importPanel;
    protected ImportWizard importWizard;

    public boolean accepts(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String string = this.getExtension(file);
        return this.supportExtension(string);
    }

    public void finishIdentify(ProgressManager progressManager) {
        this.importWizard.finishIdentify(progressManager);
    }

    public String finishImport(ProgressManager progressManager, Project_GUI project_GUI, Case case_, AbstractModel abstractModel) {
        List<DataTreeInterface> list;
        CleanUpClass cleanUpClass;
        if (project_GUI == null || project_GUI.isCleaned() || project_GUI.getData_GUI() == null || project_GUI.getData_GUI().isCleaned()) {
            return null;
        }
        AbstractDataMatrix abstractDataMatrix = case_.getOriginalMatrix();
        if (abstractDataMatrix != null) {
            abstractDataMatrix.setImage(this.isImage());
        }
        CellIdentifierModel cellIdentifierModel = this.importPanel.getCellIdentifierModel();
        int n = ImportHelper.replaceMissingWithMedian(progressManager, cellIdentifierModel, abstractDataMatrix);
        Object object = "";
        AbstractScriptInfo abstractScriptInfo = cellIdentifierModel.getScriptInfo();
        boolean bl = true;
        if (abstractScriptInfo != null) {
            bl = abstractScriptInfo.isAddDefaultImportScript();
            object = abstractScriptInfo.getScript();
        }
        if (bl) {
            if (cellIdentifierModel.createQuickTable && case_.getOriginalMatrix() != null) {
                object = (String)object + "origmatrix = dataset.get(\"originalmatrix\");";
                object = (String)object + "createTable(\"datatable\", origmatrix);";
            }
            if (cellIdentifierModel.createDatasetTable) {
                object = (String)object + "createTable(\"viewdataset\", dataset);";
            }
            if (cellIdentifierModel.modelComponent != null) {
                object = (String)object + "model = dataset.createModel(\"" + cellIdentifierModel.modelComponent.getType() + "\", 3);";
                cleanUpClass = new ModelInit(case_.getDsContainer().getTreeNodeAt(0));
                ((ModelInit)cleanUpClass).setModelName(cellIdentifierModel.modelComponent.getType().toUpperCase());
                list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.SCRIPT_INFO);
                for (AbstractInfo cloneable : list) {
                    AbstractScriptInfo abstractScriptInfo2 = (AbstractScriptInfo)cloneable;
                    if (!abstractScriptInfo2.supportObject(cleanUpClass)) continue;
                    object = (String)object + abstractScriptInfo2.getScript();
                    break;
                }
            }
        }
        if (((String)object).length() > 0) {
            try {
                cleanUpClass = new ScriptManager(project_GUI);
                list = case_.getDsContainer();
                DataSet dataSet = (DataSet)((DataTreeClass)list).getTreeNodeAt(0);
                ((ScriptManager)cleanUpClass).addVariable(dataSet, "dataset");
                if (abstractModel != null) {
                    ((ScriptManager)cleanUpClass).addVariable(abstractModel, "calibrationmodel");
                }
                ((ScriptManager)cleanUpClass).evaluteScript(progressManager, (String)object, false, true);
                dataSet.copyTransformations(case_.getOriginalDataSet(), AbstractTransform.Type.localUpdate);
                AbstractModel abstractModel2 = (AbstractModel)((ScriptManager)cleanUpClass).getVariable("model");
                if (abstractModel2 != null) {
                    project_GUI.updateDataTree(abstractModel2);
                }
                cleanUpClass.cleanUp();
                dataSet.doUpdate(progressManager);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        if (n > 0) {
            return n + " missing values replaced with median.";
        }
        return null;
    }

    public AbstractImportPanel getCurrentPanel() {
        return this.importPanel;
    }

    public abstract String getDescription();

    public abstract String[] getExt();

    public AbstractImportPanel getImportPanel(ImportInterface importInterface, Properties properties) {
        this.importPanel = this.createImportPanel(importInterface, properties);
        return this.importPanel;
    }

    public byte getMultipleMergeTypes() {
        return 0;
    }

    public boolean isMultiLayerPublic() {
        return this.isMultiLayer();
    }

    public void performProperties(ProgressManager progressManager, Object[] objectArray, Properties properties) {
        if (ScriptHelper.hasKey(properties, "apply")) {
            String string = ScriptHelper.getProperty(properties, "apply");
            if (string.equalsIgnoreCase("none")) {
                return;
            }
            string = EvinceScriptCommands.removeSpace(string.toLowerCase());
            boolean bl = false;
            List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.ANALYSIS_INFO);
            for (AbstractAnalysisInfo abstractAnalysisInfo : list) {
                if (!abstractAnalysisInfo.supportParam(string, objectArray)) continue;
                abstractAnalysisInfo.performAnalysis(progressManager, objectArray, properties);
                abstractAnalysisInfo.cleanUp();
                bl = true;
            }
            if (!bl) {
                throw new RuntimeException("No apply type: " + string);
            }
        }
    }

    public boolean requireHeaderFile() {
        return false;
    }

    public void setCalibrationProperties(Properties properties, boolean bl) {
    }

    public boolean supportCalibration() {
        return false;
    }

    public boolean supportDataSource() {
        return false;
    }

    public boolean supportExtension(String string) {
        String[] stringArray;
        for (String string2 : stringArray = this.getExt()) {
            if (!jopensaveDialog.equalExtension(string, string2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    protected void cleanUpChild() {
        if (this.importWizard != null) {
            this.importWizard.cleanUp();
        }
        this.importWizard = null;
        if (this.importPanel != null) {
            this.importPanel.cleanUp();
        }
        this.importPanel = null;
    }

    protected abstract AbstractImportPanel createImportPanel(ImportInterface var1) throws Exception;

    protected AbstractImportPanel createImportPanel(ImportInterface importInterface, Properties properties) {
        try {
            return this.createImportPanel(importInterface);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected boolean isImage() {
        return false;
    }

    public boolean isMultiLayer() {
        return false;
    }

    private String getExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).toLowerCase();
    }

    public boolean isBreezeImport() {
        return false;
    }

    public String getPreviewDescription(File file) {
        return null;
    }

    public File getPreviewFile(File file) {
        return null;
    }

    public File getPreviewDataFile(File file) {
        return file;
    }
}

