/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.LayoutManager;
import java.io.File;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractImportPanel
extends WizardPageClass {
    protected File[] filenames;
    protected CellIdentifierModel ciModel = null;

    public AbstractImportPanel(File[] fileArray) {
        this.filenames = fileArray;
    }

    public AbstractImportPanel(LayoutManager layoutManager, File[] fileArray) {
        super(layoutManager);
        this.filenames = fileArray;
    }

    public void finishIdentify(ProgressManager progressManager) {
    }

    public CellIdentifierModel getCashedCiModel() {
        return null;
    }

    public CellIdentifierModel getCellIdentifierModel() {
        return this.getCellIdentifierModel(null, false);
    }

    public CellIdentifierModel getCellIdentifierModel(ProgressManager progressManager) {
        return this.getCellIdentifierModel(progressManager, false);
    }

    public CellIdentifierModel getCellIdentifierModel(ProgressManager progressManager, boolean bl) {
        if (bl || this.ciModel == null) {
            CellIdentifierModel cellIdentifierModel = this.getTableModel(progressManager, bl);
            if (cellIdentifierModel != null) {
                cellIdentifierModel.clear(true);
                cellIdentifierModel.fireTableStructureChanged();
            }
            this.ciModel = bl ? null : cellIdentifierModel;
            return cellIdentifierModel;
        }
        return this.ciModel;
    }

    public File getFile() {
        if (this.filenames != null) {
            return this.filenames[0];
        }
        return null;
    }

    public String getFilename() {
        File file = this.getFile();
        if (file == null) {
            return "N/A";
        }
        String string = file.getName();
        int n = string.indexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public abstract String getType();

    public abstract boolean hasSettings();

    public void updateInfo(ImportInterface importInterface) {
    }

    @Override
    protected void cleanUpChild() {
        this.filenames = null;
        this.ciModel = null;
    }

    protected int getNrCellIdentiferModels() {
        return this.filenames.length;
    }

    protected abstract CellIdentifierModel getTableModel(ProgressManager var1, boolean var2);

    public boolean isSac() {
        return false;
    }
}

