/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.util.Random;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.performace.RuntimeInfo;

public class FastDecimal {
    private boolean isMissing;
    private double value;
    private byte[] sarray;
    private short size;

    public static void main(String[] stringArray) {
        int n;
        int n2;
        FastDecimal fastDecimal = new FastDecimal();
        Random random = new Random();
        random.setSeed(0L);
        byte[][] byArrayArray = new byte[1000000][];
        for (n2 = 0; n2 < 1000000; ++n2) {
            String string = String.valueOf(1.0E-6 * (random.nextDouble() - 0.5));
            byArrayArray[n2] = string.getBytes();
        }
        System.out.println("Testing correctness for parseString");
        for (n2 = 0; n2 < 1000000; ++n2) {
            String string;
            fastDecimal.parseString(byArrayArray[n2], (short)byArrayArray[n2].length);
            double d = 0.0;
            try {
                string = new String(byArrayArray[n2]);
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (fastDecimal.isMissing()) continue;
                System.out.println("Parse Error (missing value not marked as such)");
                continue;
            }
            if (!(Math.abs(fastDecimal.getValue() - d) > 1.0E-8)) continue;
            System.out.println("Parse Error. Found " + fastDecimal.getValue() + " expected " + d + " (" + string + ")");
        }
        System.out.println("Testing performance for parseString");
        RuntimeInfo runtimeInfo = new RuntimeInfo();
        for (n = 0; n < 1000000; ++n) {
            fastDecimal.parseString(byArrayArray[n], (short)byArrayArray[n].length);
        }
        System.out.println(runtimeInfo);
        System.out.println("Testing performance for valueOf");
        runtimeInfo.reset();
        for (n = 0; n < 1000000; ++n) {
            try {
                Double.parseDouble(new String(byArrayArray[n]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println(runtimeInfo);
        fastDecimal.parseString(new byte[]{49, 48, 101, 49, 48}, (short)5);
        System.out.println(fastDecimal.getValue() + " " + (fastDecimal.isMissing() ? "Missing" : ""));
        fastDecimal.parseString("2.5350000e+000".getBytes(), (short)14);
        System.out.println(fastDecimal.getValue() + " " + (fastDecimal.isMissing() ? "Missing" : ""));
    }

    public final boolean equalsIgnoreCase(String string) {
        if (string.length() == this.size) {
            for (int i = 0; i < this.size; ++i) {
                if (Character.toLowerCase(string.charAt(i)) == Character.toLowerCase((char)this.sarray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final FastDecimal error() {
        this.isMissing = true;
        this.value = 0.0;
        return this;
    }

    public final byte getByteAt(int n) {
        if (this.sarray == null || n >= this.sarray.length) {
            return 0;
        }
        return this.sarray[n];
    }

    public final int getSize() {
        if (this.sarray == null) {
            return 0;
        }
        if (this.size > this.sarray.length) {
            this.size = (short)this.sarray.length;
        }
        return this.size;
    }

    public final String getString() {
        if (this.size < 0) {
            return "";
        }
        return new String(this.sarray, 0, (int)this.size);
    }

    public final double getValue() {
        return this.value;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isMissing() {
        return this.isMissing;
    }

    public final boolean isNaN() {
        if (this.size == 3) {
            return this.sarray[0] == 78 && this.sarray[1] == 97 && this.sarray[2] == 78;
        }
        return false;
    }

    public final boolean parseString(byte[] byArray, short n) {
        int n2;
        this.sarray = byArray;
        this.size = n;
        this.value = 0.0;
        this.isMissing = true;
        double d = 1.0;
        boolean bl = false;
        block14: for (n2 = 0; n2 < n && !bl; ++n2) {
            switch (byArray[n2]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block14;
                }
                case 45: {
                    d = -1.0;
                }
                case 43: {
                    bl = true;
                    continue block14;
                }
                default: {
                    bl = true;
                    --n2;
                }
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        double d4 = 0.0;
        double d5 = 1.0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = false;
        while (n2 < n) {
            switch (byArray[n2]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case 48: {
                    if (!bl2 && d2 == 0.0) {
                        this.isMissing = false;
                        break;
                    }
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n4 = byArray[n2] - 48;
                    if (bl3) {
                        d4 = d4 * 10.0 + (double)n4;
                    } else if (bl2) {
                        d3 = d3 * 10.0 + (double)n4;
                        ++n3;
                    } else {
                        d2 = d2 * 10.0 + (double)n4;
                    }
                    this.isMissing = false;
                    break;
                }
                case 44: 
                case 46: {
                    if (bl2) {
                        this.isMissing = true;
                        return true;
                    }
                    bl2 = true;
                    break;
                }
                case 69: 
                case 101: {
                    if (bl3) {
                        this.isMissing = true;
                        return true;
                    }
                    bl3 = true;
                    break;
                }
                case 43: {
                    if (bl3 && !bl) {
                        bl = true;
                        break;
                    }
                    this.isMissing = true;
                    return true;
                }
                case 45: {
                    if (bl3 && !bl) {
                        bl = true;
                        d5 = -1.0;
                        break;
                    }
                }
                default: {
                    this.isMissing = true;
                    return true;
                }
            }
            ++n2;
        }
        this.value = bl3 ? d * (d2 + d3 * Math.pow(10.0, -n3)) * Math.pow(10.0, d5 * d4) : d * (d2 + d3 * Math.pow(10.0, -n3));
        return false;
    }

    public final FastDecimal parseString(String string) {
        this.parseString(string.getBytes(), (short)string.length());
        return this;
    }

    public final FastDecimal setValueOrError(Float f) {
        if (f == null) {
            return this.error();
        }
        return this.setValue(f.floatValue());
    }

    public final FastDecimal setValueOrError(Double d) {
        if (d == null) {
            return this.error();
        }
        return this.setValue(d);
    }

    public final FastDecimal setValue(double d) {
        this.value = d;
        this.isMissing = Double.isNaN(d) || Double.isInfinite(d);
        this.size = (short)-1;
        return this;
    }

    public final String toString() {
        if (this.isMissing) {
            return "MV";
        }
        return NiceDataFormat.toString(this.value);
    }
}

