/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.StatusBar;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ImportHelper {
    private static int[][] neighbours = new int[][]{{-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}, {0, 1}, {-1, 1}};

    public static jopensaveDialog createFileDialog(Component component, String string, final AbstractWizard abstractWizard) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog(string, component){

            @Override
            public void approveSelection() {
                if (abstractWizard != null) {
                    abstractWizard.handleDoubleClick(false);
                } else {
                    super.approveSelection();
                }
            }
        };
        jopensaveDialog2.setMultiSelectionEnabled(true);
        Vector<AbstractImportInfo> vector = ImportHelper.getExternImportInfo();
        for (int i = 0; i < vector.size(); ++i) {
            jopensaveDialog2.addExtension(vector.elementAt(i));
        }
        jopensaveDialog2.addAllSupported();
        jopensaveDialog2.addAllFiles();
        jopensaveDialog2.addFiltersIntoDialog();
        File file = IniManager.getWorkDir((byte)1);
        if (file != null) {
            try {
                jopensaveDialog2.setCurrentDirectory(file);
            }
            catch (Exception exception) {
                System.out.println("Cannot set current directory: " + exception.getMessage());
            }
        }
        return jopensaveDialog2;
    }

    public static jopensaveDialog createFileDialog(String string, AbstractWizard abstractWizard) {
        return ImportHelper.createFileDialog(null, string, abstractWizard);
    }

    public static File createLegalFile(File file) {
        String string = file.getParent();
        String string2 = file.getName();
        string2 = string2.replaceAll("[,/\\\\:*?\"<>|]", "_");
        return new File(string + IniManager.getFileSeparator() + string2);
    }

    public static jopensaveDialog createModelDialog(Component component, String string, String string2, boolean bl) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog(string, component);
        jopensaveDialog2.addExtension("mdl", "Evince Model Files (*.mdl)");
        jopensaveDialog2.addExtension("map", "Evince Project Files (*.map)");
        jopensaveDialog2.addAllSupported();
        jopensaveDialog2.setMultiSelectionEnabled(bl);
        File file = IniManager.getWorkDir((byte)5);
        if (file != null) {
            if (string2 != null) {
                File file2 = new File(file.getAbsolutePath(), string2);
                jopensaveDialog2.setSelectedFile(file2);
            }
            try {
                jopensaveDialog2.setCurrentDirectory(file);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException(exception);
            }
        }
        return jopensaveDialog2;
    }

    public static jopensaveDialog createModelDialog(String string, String string2, boolean bl) {
        return ImportHelper.createModelDialog(null, string, string2, bl);
    }

    public static jopensaveDialog createProjectDialog(Component component, String string, String string2, boolean bl) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog(string, component);
        jopensaveDialog2.addExtension("map", "Evince Project Files (*.map)");
        jopensaveDialog2.setMultiSelectionEnabled(bl);
        File file = IniManager.getWorkDir((byte)0);
        if (file != null) {
            if (string2 != null) {
                File file2 = new File(file.getAbsolutePath(), string2);
                jopensaveDialog2.setSelectedFile(file2);
            }
            jopensaveDialog2.setCurrentDirectory(file);
        }
        return jopensaveDialog2;
    }

    public static Vector<AbstractImportInfo> getExternImportInfo() {
        Vector<AbstractImportInfo> vector = new Vector<AbstractImportInfo>();
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.IMPORT_INFO);
        for (AbstractInfo abstractInfo : list) {
            vector.addElement((AbstractImportInfo)abstractInfo);
        }
        return vector;
    }

    public static boolean importData(Project_GUI project_GUI, Case case_, AbstractModel abstractModel, List<File> list) {
        return ImportHelper.importData(project_GUI, case_, abstractModel, list, null, false);
    }

    public static boolean importData(Project_GUI project_GUI, Case case_, AbstractModel abstractModel, List<File> list, boolean bl) {
        return ImportHelper.importData(project_GUI, case_, abstractModel, list, null, bl);
    }

    public static boolean importData(final Project_GUI project_GUI, final Case case_, final AbstractModel abstractModel, List<File> list, ScriptFile scriptFile, boolean bl) {
        ImportWizard importWizard = new ImportWizard(project_GUI, abstractModel, true);
        if (importWizard.executeWizard(list, true, scriptFile) == 1) {
            if (importWizard.getCellIdentifierModel() != null) {
                ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(new Object[]{importWizard}){

                    @Override
                    public Object doWork() {
                        if (case_ == null) {
                            return null;
                        }
                        this.setInfoText("Checking file");
                        ImportWizard importWizard = (ImportWizard)this.arguments[0];
                        CellIdentifierModel cellIdentifierModel = importWizard.getCellIdentifierModel(this);
                        AbstractImportInfo abstractImportInfo = importWizard.getImportInfo();
                        importWizard.finishIdentify(this);
                        boolean bl = case_.importCaseFromModel(cellIdentifierModel, project_GUI, this, new Properties());
                        if (bl) {
                            DataContainer dataContainer;
                            String string;
                            AbstractDataMatrix abstractDataMatrix = case_.getOriginalMatrix();
                            Object object = "";
                            if (abstractDataMatrix != null) {
                                if (abstractModel == null) {
                                    project_GUI.suggestProjectName(abstractDataMatrix.toString());
                                }
                                if ((string = importWizard.finishImport(this, cellIdentifierModel, abstractDataMatrix)) != null) {
                                    object = (String)object + string;
                                }
                            }
                            string = null;
                            if (abstractImportInfo != null) {
                                string = abstractImportInfo.finishImport(this, project_GUI, case_, abstractModel);
                            }
                            if (string != null) {
                                object = (String)object + string;
                            }
                            if (abstractModel != null) {
                                case_.setExternal();
                            }
                            if ((dataContainer = case_.getDsContainer()) != null && dataContainer.getTreeNodeCount() > 0) {
                                project_GUI.updateDataTree(dataContainer.getTreeNodeAt(0));
                            }
                            if (!cellIdentifierModel.isDataSource()) {
                                if (abstractImportInfo.supportDataSource()) {
                                    try {
                                        cellIdentifierModel.closeConnections();
                                    }
                                    catch (Exception exception) {
                                        ErrorHandler.logAndReportException(exception);
                                    }
                                } else {
                                    cellIdentifierModel.cleanUp();
                                }
                            }
                            project_GUI.repaint();
                            this.Finish();
                            if (((String)object).length() > 0) {
                                Main_GUI.setStatusMessage(StatusBar.MessageType.INFORMATION, (String)object, 15);
                            }
                        } else if (project_GUI != null && project_GUI.isNewProject()) {
                            project_GUI.closeProject(false);
                            Main_GUI.get().newProject(null, false);
                        }
                        if (abstractImportInfo != null) {
                            // empty if block
                        }
                        importWizard.cleanUp();
                        System.gc();
                        return null;
                    }
                };
                if (bl) {
                    progressManagerImpl.invokeNow();
                } else {
                    progressManagerImpl.invokeLater();
                }
            }
            return true;
        }
        if (abstractModel == null && project_GUI != null && project_GUI.isNewProject()) {
            project_GUI.closeProject(false);
            Main_GUI.get().newProject(null, false);
        }
        return false;
    }

    public static boolean importData(Project_GUI project_GUI, Case case_, List<File> list) {
        return ImportHelper.importData(project_GUI, case_, null, list);
    }

    public static ImportWizard importMultiDataFile(ImportWizard importWizard, Project_GUI project_GUI, List<File> list) {
        return ImportHelper.importMultiDataFile(importWizard, project_GUI, list, true);
    }

    public static ImportWizard importMultiDataFile(ImportWizard importWizard, Project_GUI project_GUI, List<File> list, boolean bl) {
        if (importWizard == null ? (importWizard = new ImportWizard(project_GUI, null, true, true, false, true)).executeWizard(list, bl, null) == 1 : importWizard.showWizard() == 1) {
            return importWizard;
        }
        return null;
    }

    public static int replaceMissingWithMedian(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix) {
        int n = 0;
        if (!cellIdentifierModel.isDataSource() && cellIdentifierModel.isReplaceMissingWithMedian()) {
            progressManager.setInfoText("Replacing missing values with median");
            if (abstractDataMatrix instanceof LayerMatrix) {
                LayerMatrix layerMatrix = (LayerMatrix)abstractDataMatrix;
                InnerColumnBoolean innerColumnBoolean = null;
                if (abstractDataMatrix.getCase() != null && abstractDataMatrix.getCase().getOriginalDataSet() != null) {
                    innerColumnBoolean = (InnerColumnBoolean)abstractDataMatrix.getCase().getOriginalDataSet().getVarDataInfo().getGroupColumnByType(3).getPrimaryColumn();
                }
                int n2 = layerMatrix.getMatrixCount();
                progressManager.setMaximumAndReset(n2);
                for (int i = 0; i < n2; ++i) {
                    if (innerColumnBoolean == null || innerColumnBoolean.getValueBool(i)) {
                        n += ImportHelper.replaceMissingWithMedian(layerMatrix.getMatrixAt(i));
                    }
                    progressManager.incStep();
                }
            } else {
                n += ImportHelper.replaceMissingWithMedian(abstractDataMatrix);
            }
        }
        return n;
    }

    private static int replaceAllMissingWithZero(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        int n3 = abstractDataMatrix.getN();
        int n4 = abstractDataMatrix.getK();
        for (int[] nArray : neighbours) {
            int n5 = n + nArray[0];
            int n6 = n2 + nArray[1];
            if (n5 < 0 || n6 < 0 || n5 >= n3 || n6 >= n4 || abstractDataMatrix.isMissing(n5, n6)) continue;
            return 0;
        }
        abstractDataMatrix.setValue(n, n2, 0.0, false);
        return 1;
    }

    private static int replaceMissingWithMedian(AbstractDataMatrix abstractDataMatrix) {
        int n = 0;
        if (abstractDataMatrix.hasMissing()) {
            int n2;
            int n3;
            int[] nArray = abstractDataMatrix.getMissingCountForColumns(false);
            int[] nArray2 = abstractDataMatrix.getMissingCountForRows(false);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] <= 0) continue;
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    if (nArray2[n2] <= 0 || !abstractDataMatrix.isMissing(n2, n3)) continue;
                    n += ImportHelper.replaceAllMissingWithZero(abstractDataMatrix, n2, n3);
                }
            }
            nArray = abstractDataMatrix.getMissingCountForColumns(false);
            nArray2 = abstractDataMatrix.getMissingCountForRows(false);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] <= 0) continue;
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    if (nArray2[n2] <= 0 || !abstractDataMatrix.isMissing(n2, n3)) continue;
                    n += ImportHelper.replaceMissingWithMedian(abstractDataMatrix, n2, n3);
                }
            }
        }
        return n;
    }

    private static int replaceMissingWithMedian(AbstractDataMatrix abstractDataMatrix, int n, int n2) {
        double[] dArray = new double[8];
        int n3 = 0;
        int n4 = abstractDataMatrix.getN();
        int n5 = abstractDataMatrix.getK();
        for (int[] nArray : neighbours) {
            int n6 = n + nArray[0];
            int n7 = n2 + nArray[1];
            if (n6 < 0 || n7 < 0 || n6 >= n4 || n7 >= n5) continue;
            dArray[n3++] = abstractDataMatrix.getValue(n6, n7);
        }
        if (n3 == 0) {
            return 0;
        }
        if (n3 == 1) {
            abstractDataMatrix.setValue(n, n2, dArray[n3], false);
            return 1;
        }
        Arrays.sort(dArray, 0, n3);
        int n8 = n3 / 2;
        if (n3 % 2 == 0) {
            abstractDataMatrix.setValue(n, n2, (dArray[n8 - 1] + dArray[n8]) * 0.5, false);
        } else {
            abstractDataMatrix.setValue(n, n2, dArray[n8], false);
        }
        return 1;
    }
}

