/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.border.EmptyBorder;
import se.prediktera.map.common.AbstractPanelInfo;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.AbstractWizardInfo;
import se.prediktera.map.common.wizard.FileChooserPage;
import se.prediktera.map.common.wizard.MergeException;
import se.prediktera.map.common.wizard.WizardDialog;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.MultiImportPanel;
import se.prediktera.map.dataimport.OtherSettingsPanel;
import se.prediktera.map.dataimport.identifier.CellIdentifierPanel;
import se.prediktera.map.dataimport.multi.MultiCellIdentifierModel;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ImportWizard
extends AbstractWizard
implements ImportInterface {
    private AbstractImportPanel importPanel = null;
    private CellIdentifierPanel cellIdentifierPanel;
    private OtherSettingsPanel settingsPanel;
    private FileChooserPage fileChooser;
    private boolean showAutoIdentify;
    private boolean showSettingsPanel;
    private Project_GUI project_GUI;
    private AbstractModel calibrationModel;
    private MultiImportPanel multiImportPanel;
    private File[] openFiles;
    private int lastpage = -1;
    private boolean multiimage = false;
    private CellIdentifierModel multiModel;
    private ScriptFile importTemplate;

    public ImportWizard(File file) {
        this.openFiles = new File[]{file};
    }

    public ImportWizard(Project_GUI project_GUI, AbstractModel abstractModel, boolean bl) {
        this(project_GUI, abstractModel, bl, true, false, false);
    }

    public ImportWizard(Project_GUI project_GUI, AbstractModel abstractModel, boolean bl, boolean bl2) {
        this(project_GUI, abstractModel, bl, bl2, false, false);
    }

    public ImportWizard(Project_GUI project_GUI, AbstractModel abstractModel, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.project_GUI = project_GUI;
        this.showAutoIdentify = bl;
        this.showSettingsPanel = bl2;
        this.calibrationModel = abstractModel;
        this.multiimage = bl4;
        this.fileChooser = new FileChooserPage(this, !bl4);
        this.setBorder(new EmptyBorder(4, 12, 0, 12));
        this.addPage(this.fileChooser, "Page1");
    }

    @Override
    public boolean canFinish() {
        return this.currentPage != null && (this.currentPage.canFinish() || !this.showAutoIdentify && this.currentPage.canNext());
    }

    @Override
    public void cleanUpChild() {
        super.cleanUpChild();
        if (this.multiImportPanel != null) {
            this.multiImportPanel.cleanUp();
            this.multiImportPanel = null;
        }
        if (this.importPanel != null) {
            this.importPanel.cleanUp();
            this.importPanel = null;
        }
        if (this.cellIdentifierPanel != null) {
            this.cellIdentifierPanel.cleanUp();
            this.cellIdentifierPanel = null;
        }
        if (this.settingsPanel != null) {
            this.settingsPanel.cleanUp();
            this.settingsPanel = null;
        }
        if (this.fileChooser != null) {
            this.fileChooser.cleanUp();
            this.fileChooser = null;
        }
    }

    @Override
    public int executeWizard() {
        return this.executeWizard(null);
    }

    public int executeWizard(List<File> list) {
        return this.executeWizard(list, true, null);
    }

    public int executeWizard(List<File> list, boolean bl, ScriptFile scriptFile) {
        this.importTemplate = scriptFile;
        this.setPreferredSize(new Dimension(900, 650));
        this.wizardWindow = new WizardDialog("Data Import Wizard", this, true, true, false);
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1) {
                if (list.get(0).exists()) {
                    this.fileChooser.setSelectedFile(list.get(0));
                    return this.wizardWindow.executeWizard(1, bl);
                }
            } else {
                this.fileChooser.setAndAddMultiFiles(list.toArray(new File[list.size()]));
                return this.wizardWindow.executeWizard(0, bl);
            }
        }
        return this.wizardWindow.executeWizard(0);
    }

    @Override
    public boolean finished() {
        if (this.canFinish()) {
            if (this.settingsPanel != null) {
                if (this.importPanel != null) {
                    this.settingsPanel.initTableModel(this.importPanel.getCellIdentifierModel());
                } else if (this.multiModel != null) {
                    this.settingsPanel.initTableModel(this.multiModel);
                }
            }
            return true;
        }
        return false;
    }

    public void finishIdentify(ProgressManager progressManager) {
        if (this.importPanel != null) {
            this.importPanel.finishIdentify(progressManager);
        }
    }

    public String finishImport(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, AbstractDataMatrix abstractDataMatrix) {
        if (cellIdentifierModel instanceof MultiCellIdentifierModel) {
            MultiCellIdentifierModel multiCellIdentifierModel = (MultiCellIdentifierModel)cellIdentifierModel;
            return multiCellIdentifierModel.finishImport(progressManager, abstractDataMatrix);
        }
        Object object = null;
        for (int i = 0; i < this.getPageCount(); ++i) {
            String string;
            if (!(this.getPageAt(i) instanceof WizardPageClass) || (string = this.getWizardPageAt(i).finishImport(progressManager, cellIdentifierModel, abstractDataMatrix)) == null) continue;
            object = object == null ? string : (String)object + string;
        }
        return object;
    }

    public CellIdentifierModel getCellIdentifierModel() {
        return this.getCellIdentifierModel(null);
    }

    public CellIdentifierModel getCellIdentifierModel(ProgressManager progressManager) {
        if (this.importPanel != null) {
            return this.importPanel.getCellIdentifierModel(progressManager);
        }
        return this.multiModel;
    }

    @Override
    public String getDescription() {
        return "Import";
    }

    @Override
    public File[] getFiles() {
        if (this.multiImportPanel != null) {
            return this.multiImportPanel.getFiles();
        }
        return this.openFiles;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    public AbstractImportInfo getImportInfo() {
        if (this.fileChooser == null) {
            return null;
        }
        return this.fileChooser.getImportInfo();
    }

    @Override
    public byte getMergeType() {
        if (this.multiImportPanel != null) {
            return this.multiImportPanel.getMergeType();
        }
        return 0;
    }

    @Override
    public Project_GUI getProjectGUI() {
        return this.project_GUI;
    }

    @Override
    public boolean includeFileNames() {
        if (this.multiImportPanel != null) {
            return this.multiImportPanel.includeFileNames();
        }
        return false;
    }

    @Override
    public boolean isLastPage() {
        return super.isLastPage() && this.currentPage != null && !(this.currentPage instanceof FileChooserPage);
    }

    public void setImportPanel(AbstractImportInfo abstractImportInfo, File[] fileArray) throws Exception {
        this.openFiles = fileArray;
        this.curWizard = new FileInfo(fileArray);
        if (this.multiImportPanel != null) {
            this.multiImportPanel.cleanUp();
            this.multiImportPanel = null;
        }
        this.removePagesKeepOne();
        if (fileArray.length > 1) {
            if (abstractImportInfo.getMultipleMergeTypes() == 0) {
                throw new MergeException("Merge of multiple files is not supported for selected file format(s).\nPlease try to use the \"Merge different files\" tab instead");
            }
            this.multiImportPanel = new MultiImportPanel(abstractImportInfo, fileArray);
            this.addPage(this.multiImportPanel, "Page2");
        }
        if (this.importPanel != null) {
            this.importPanel.cleanUp();
        }
        this.importPanel = abstractImportInfo.getImportPanel(this, null);
        if (this.importPanel.hasSettings()) {
            this.addPage(this.importPanel, "Page3");
        }
        if (this.showAutoIdentify) {
            this.cellIdentifierPanel = new CellIdentifierPanel(this, abstractImportInfo.isMultiLayer(), false, !this.multiimage);
            this.addPage(this.cellIdentifierPanel, "Page4");
        }
        this.addExternalPanels(abstractImportInfo);
        if (this.showAutoIdentify && this.showSettingsPanel && !this.multiimage) {
            this.settingsPanel = new OtherSettingsPanel(this.project_GUI, this, this.calibrationModel, this.importPanel.getFilename(), abstractImportInfo.supportDataSource(), this.importTemplate);
            this.addPage(this.settingsPanel, "Page5");
        }
    }

    public void setMultiImportPanel(AbstractImportInfo abstractImportInfo, CellIdentifierModel cellIdentifierModel) throws Exception {
        this.multiModel = cellIdentifierModel;
        this.removePagesKeepOne();
        abstractImportInfo.getImportPanel(this, null);
        if (this.importPanel != null) {
            this.importPanel.cleanUp();
            this.importPanel = null;
        }
        this.cellIdentifierPanel = new CellIdentifierPanel(this, false, true, !this.multiimage);
        this.addPage(this.cellIdentifierPanel, "Page1");
        this.settingsPanel = new OtherSettingsPanel(this.project_GUI, this, null, "Multi image import", false, this.importTemplate);
        this.addPage(this.settingsPanel, "Page2");
    }

    public void setMultiModel(CellIdentifierModel cellIdentifierModel) {
        this.multiModel = cellIdentifierModel;
    }

    @Override
    public boolean showStepsOnFirstPage() {
        return false;
    }

    public int showWizard() {
        this.wizardWindow = new WizardDialog("Data Import Wizard", this, true, true, false);
        return ((WizardDialog)this.wizardWindow).showWizard();
    }

    @Override
    protected String getHelpID() {
        return "evinceCreateproject";
    }

    @Override
    protected void pageChangedLocal(WizardPageClass wizardPageClass, int n) {
        CleanUpInterface cleanUpInterface;
        if (wizardPageClass instanceof AbstractImportPanel) {
            cleanUpInterface = (AbstractImportPanel)wizardPageClass;
            ((AbstractImportPanel)cleanUpInterface).updateInfo(this);
        }
        if (wizardPageClass instanceof CellIdentifierPanel && this.lastpage < n) {
            if (this.importPanel != null && (cleanUpInterface = this.importPanel.getCashedCiModel()) != null) {
                this.cellIdentifierPanel.setLayoutFromLayers(((CellIdentifierModel)cleanUpInterface).isMultiLayer(), ((CellIdentifierModel)cleanUpInterface).isMultiImport());
            }
            cleanUpInterface = new ProgressManagerImpl(){

                @Override
                public Object doWork() {
                    this.setInfoText("Checking file");
                    CellIdentifierModel cellIdentifierModel = ImportWizard.this.multiModel;
                    if (ImportWizard.this.importPanel != null) {
                        cellIdentifierModel = ImportWizard.this.importPanel.getCellIdentifierModel(this, false);
                    }
                    if (cellIdentifierModel != null) {
                        boolean bl = true;
                        if (ImportWizard.this.importPanel != null) {
                            bl = !ImportWizard.this.getImportInfo().isImage();
                        }
                        ImportWizard.this.cellIdentifierPanel.setTableModel(this, cellIdentifierModel, bl);
                        if (ImportWizard.this.settingsPanel != null) {
                            ImportWizard.this.settingsPanel.setTableModel(cellIdentifierModel);
                        }
                    }
                    ImportWizard.this.updateTitle();
                    ImportWizard.this.updateButtons(false);
                    return null;
                }
            };
            cleanUpInterface.setDeciSeconds(1);
            cleanUpInterface.invokeLater();
        }
        this.lastpage = n;
    }

    private void addExternalPanels(AbstractImportInfo abstractImportInfo) {
        int n = 1;
        List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.PANEL_INFO);
        for (AbstractInfo abstractInfo : list) {
            AbstractPanelInfo abstractPanelInfo = (AbstractPanelInfo)abstractInfo;
            if (!abstractPanelInfo.supportObject(abstractImportInfo)) continue;
            this.addPage(abstractPanelInfo.createPanel(this), "external" + n++);
        }
    }

    private static class FileInfo
    extends AbstractWizardInfo {
        private String name;

        public FileInfo(File[] fileArray) {
            this.name = fileArray.length > 1 ? "Multiple files" : fileArray[0].getName();
        }

        @Override
        public void beginWizard() {
        }

        public Vector createWizard() {
            return null;
        }

        @Override
        public ImageIcon getWizardImage() {
            return null;
        }

        @Override
        public String getWizardInfo() {
            return "";
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        protected void cleanUpChild() {
        }
    }
}

