/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.table.CheckBoxCellRenderer;
import se.prediktera.map.common.swing.table.ProgressBarCellRenderer;
import se.prediktera.map.dataimport.MvInfo;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MissingValuePanel
extends CleanUpPanel {
    private final JSlider jSlider1 = new JSlider();
    private final JScrollPane scrollPane = new JScrollPane();
    private final JLabel mvToleranceLabel = new JLabel();
    private JTable mvTable = null;
    private String title;
    private ArrayList<MvInfo> mvList = null;
    private int checktype = 0;
    private CellIdentifierModel model;

    public MissingValuePanel() {
        super(new BorderLayout());
        this.jbinit();
    }

    public void excludeSelected() {
        if (this.mvList != null) {
            int n = this.checktype == 1 ? 1 : 0;
            for (MvInfo mvInfo : this.mvList) {
                if (!mvInfo.excluded) continue;
                this.model.addInterval(n, mvInfo.index, (byte)2);
            }
        }
    }

    public void setMV(String string, int n, CellIdentifierModel cellIdentifierModel) {
        this.model = cellIdentifierModel;
        this.title = string;
        this.checktype = n;
        this.mvTable = new JTable();
        this.mvTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed()) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    if (jTable.columnAtPoint(mouseEvent.getPoint()) == 2 && MissingValuePanel.this.mvList != null) {
                        int n = jTable.rowAtPoint(mouseEvent.getPoint());
                        MvInfo mvInfo = MissingValuePanel.this.mvList.get(n);
                        mvInfo.excluded = !mvInfo.excluded;
                        MissingValuePanel.this.mvTable.repaint();
                    }
                    mouseEvent.consume();
                }
            }
        });
        this.mvTable.setModel(new TableModel());
        this.mvTable.setRowHeight(22);
        this.mvTable.setDefaultRenderer(JProgressBar.class, new ProgressBarCellRenderer());
        this.mvTable.setDefaultRenderer(JCheckBox.class, new CheckBoxCellRenderer());
        this.scrollPane.getViewport().setView(this.mvTable);
        this.setTolerance(50);
    }

    @Override
    protected void cleanUpChild() {
        this.model = null;
    }

    private void jbinit() {
        this.jSlider1.setMajorTickSpacing(25);
        this.jSlider1.setMinorTickSpacing(5);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MissingValuePanel.this.setTolerance(MissingValuePanel.this.jSlider1.getValue());
            }
        });
        this.jSlider1.addChangeListener(new SliderListener());
        JButton jButton = new JButton("Select All");
        JButton jButton2 = new JButton("Clear All");
        jButton.addActionListener(actionEvent -> this.setExclude(true));
        jButton2.addActionListener(actionEvent -> this.setExclude(false));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Missing Value Cutoff"));
        this.mvToleranceLabel.setMinimumSize(new Dimension(50, 17));
        this.mvToleranceLabel.setPreferredSize(new Dimension(70, 17));
        this.mvToleranceLabel.setHorizontalAlignment(0);
        this.mvToleranceLabel.setHorizontalTextPosition(0);
        this.setMaximumSize(new Dimension(300, 320));
        this.setMinimumSize(new Dimension(300, 320));
        this.setPreferredSize(new Dimension(300, 320));
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)new JLabel("Information"), "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add((Component)this.scrollPane, "Center");
        jPanel2.add((Component)jPanel5, "South");
        jPanel5.add((Component)jButton2, null);
        jPanel5.add((Component)jButton, null);
        jPanel.add((Component)jPanel3, "South");
        jPanel3.add((Component)jPanel4, null);
        jPanel4.add((Component)this.jSlider1, "Center");
        jPanel4.add((Component)this.mvToleranceLabel, "East");
    }

    private void setExclude(boolean bl) {
        if (this.mvList != null) {
            for (MvInfo mvInfo : this.mvList) {
                mvInfo.excluded = bl;
            }
            this.mvTable.repaint();
        }
    }

    private void setTolerance(int n) {
        this.mvToleranceLabel.setText(n + "%");
        this.jSlider1.setValue(n);
        this.mvList = this.model.mvToleranceCheck(n, this.checktype == 1);
        this.mvTable.revalidate();
    }

    class TableModel
    extends AbstractTableModel {
        TableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return switch (n) {
                case 1 -> JProgressBar.class;
                case 2 -> JCheckBox.class;
                default -> String.class;
            };
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            return switch (n) {
                case 1 -> "% missing";
                case 2 -> "Exclude";
                default -> MissingValuePanel.this.title;
            };
        }

        @Override
        public int getRowCount() {
            if (MissingValuePanel.this.mvList == null) {
                return 0;
            }
            return MissingValuePanel.this.mvList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (MissingValuePanel.this.mvList == null) {
                return "";
            }
            MvInfo mvInfo = MissingValuePanel.this.mvList.get(n);
            return switch (n2) {
                case 1 -> (int)mvInfo.percentage;
                case 2 -> mvInfo.excluded;
                default -> {
                    if (MissingValuePanel.this.checktype == 1) {
                        int var4_4 = MissingValuePanel.this.model.getPrimaryRow();
                        if (MissingValuePanel.this.model.getRowType(var4_4) == 0) {
                            yield MissingValuePanel.this.model.getValueAt(var4_4, mvInfo.index);
                        }
                    } else {
                        int var4_5 = MissingValuePanel.this.model.getPrimaryCol();
                        if (MissingValuePanel.this.model.getColumnType(var4_5) == 1) {
                            yield MissingValuePanel.this.model.getValueAt(mvInfo.index, var4_5);
                        }
                    }
                    yield String.valueOf(mvInfo.index + 1);
                }
            };
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof JSlider) {
                JSlider jSlider = (JSlider)object;
                MissingValuePanel.this.mvToleranceLabel.setText(jSlider.getValue() + "%");
            }
        }
    }
}

