/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.simpletableeditor.CellIdentifier;

public class MultiImportPanel
extends WizardPageClass
implements CellIdentifier {
    private final JRadioButton mergeColumnsRadioButton = new JRadioButton();
    private final JLabel mergeColumnsLabel = new JLabel();
    private final JRadioButton mergeRowsRadioButton = new JRadioButton();
    private final JLabel mergeRowsLabel = new JLabel();
    private final JRadioButton mergeLayersRadioButton = new JRadioButton();
    private final JLabel mergeLayersLabel = new JLabel();
    private final JList filesList = new JList();
    private final JCheckBox descCheckBox = new JCheckBox("Include filenames in identifiers", true);
    private File[] files;
    private AbstractImportInfo importInfo;

    public MultiImportPanel(AbstractImportInfo abstractImportInfo, File[] fileArray) {
        this.files = fileArray;
        this.importInfo = abstractImportInfo;
        this.filesList.setModel(new DefaultListModel(){

            @Override
            public Object getElementAt(int n) {
                return MultiImportPanel.this.files[n].getName();
            }

            @Override
            public int getSize() {
                return MultiImportPanel.this.files.length;
            }
        });
        try {
            this.jbInit();
            this.filesList.setSelectedIndex(0);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    public File[] getFiles() {
        return this.files;
    }

    public byte getMergeType() {
        if (this.mergeRowsRadioButton.isSelected()) {
            return 1;
        }
        if (this.mergeColumnsRadioButton.isSelected()) {
            return 2;
        }
        if (this.mergeLayersRadioButton.isSelected()) {
            return 4;
        }
        return 0;
    }

    public boolean includeFileNames() {
        if (this.mergeLayersRadioButton.isSelected()) {
            return false;
        }
        return this.descCheckBox.isSelected();
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.files = null;
        this.importInfo = null;
    }

    private void jbInit() throws Exception {
        JButton jButton = new JButton("Up");
        jButton.setMinimumSize(new Dimension(61, 23));
        jButton.setPreferredSize(new Dimension(61, 23));
        jButton.addActionListener(actionEvent -> {
            int n = this.filesList.getSelectedIndex();
            if (n > 0) {
                this.swap(n, n - 1);
            }
        });
        JButton jButton2 = new JButton("Down");
        jButton2.addActionListener(actionEvent -> {
            int n = this.filesList.getSelectedIndex();
            if (n < this.files.length - 1) {
                this.swap(n, n + 1);
            }
        });
        this.filesList.setSelectionMode(0);
        byte by = this.importInfo.getMultipleMergeTypes();
        this.mergeRowsRadioButton.setEnabled((by & 1) != 0);
        this.mergeColumnsRadioButton.setEnabled((by & 2) != 0);
        this.mergeLayersRadioButton.setEnabled((by & 4) != 0);
        if (this.mergeRowsRadioButton.isEnabled()) {
            this.mergeRowsRadioButton.setSelected(true);
        } else if (this.mergeColumnsRadioButton.isEnabled()) {
            this.mergeColumnsRadioButton.setSelected(true);
        } else {
            this.mergeLayersRadioButton.setSelected(true);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Merge type"));
        jPanel.add((Component)this.mergeRowsRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)this.mergeRowsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)this.mergeColumnsRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 36, 0, 6), 0, 0));
        jPanel.add((Component)this.mergeColumnsLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 36, 0, 6), 0, 0));
        jPanel.add((Component)this.mergeLayersRadioButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 36, 0, 6), 0, 0));
        jPanel.add((Component)this.mergeLayersLabel, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 36, 6, 6), 0, 0));
        this.setLayout(new BorderLayout());
        DisableImageListener disableImageListener = new DisableImageListener();
        this.mergeColumnsRadioButton.setText("Columns");
        this.mergeColumnsRadioButton.addItemListener(disableImageListener);
        this.mergeColumnsLabel.setIcon(new ImageIcon(MultiImportPanel.class.getResource("images/mergecolumns.gif")));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mergeColumnsRadioButton);
        this.mergeRowsRadioButton.setText("Rows");
        this.mergeRowsRadioButton.addItemListener(disableImageListener);
        this.mergeRowsLabel.setIcon(new ImageIcon(MultiImportPanel.class.getResource("images/mergerows.gif")));
        buttonGroup.add(this.mergeRowsRadioButton);
        this.mergeLayersRadioButton.setText("Layers");
        this.mergeLayersRadioButton.addItemListener(disableImageListener);
        this.mergeLayersRadioButton.addItemListener(itemEvent -> this.descCheckBox.setEnabled(!this.mergeLayersRadioButton.isSelected()));
        this.mergeLayersLabel.setIcon(new ImageIcon(MultiImportPanel.class.getResource("images/mergelayers.gif")));
        buttonGroup.add(this.mergeLayersRadioButton);
        disableImageListener.itemStateChanged(null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Files"));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        jPanel2.add((Component)this.descCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.filesList);
        jPanel2.add((Component)jButton2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(6, 6, 6, 6), 0, 0));
        jPanel2.add((Component)jButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(6, 6, 0, 6), 0, 0));
    }

    private void swap(int n, int n2) {
        File file = this.files[n];
        this.files[n] = this.files[n2];
        this.files[n2] = file;
        this.filesList.repaint();
        this.filesList.setSelectedIndex(n2);
    }

    private class DisableImageListener
    implements ItemListener {
        private DisableImageListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            byte by = MultiImportPanel.this.getMergeType();
            MultiImportPanel.this.mergeRowsLabel.setEnabled(by == 1);
            MultiImportPanel.this.mergeColumnsLabel.setEnabled(by == 2);
            MultiImportPanel.this.mergeLayersLabel.setEnabled(by == 4);
        }
    }
}

