/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.color.ColorSpace;
import java.awt.event.ItemEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.extclass.AbstractInfo;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.AbstractImportScriptInfo;
import se.prediktera.map.main.script.AbstractScriptInfo;
import se.prediktera.map.main.script.ScriptFile;
import se.prediktera.map.main.script.ScriptManager;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.modelgenerator.AbstractModelInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class OtherSettingsPanel
extends WizardPageClass {
    private CellIdentifierModel ciModel;
    private final Vector<AbstractModelInfo> modelVector = new Vector();
    private final AbstractModel calibrationModel;
    private int maxdefaultindex = 0;
    private final boolean supportDataSource;
    private JPanel autoCreatePanel;
    private JCheckBox createDatasetTable;
    private JPanel createPanel;
    private JCheckBox createQuickTable;
    private JLabel dataSourceLabel;
    private JPanel dataSourcePanel;
    private JTextArea dataSourceTextArea;
    private JCheckBox datasourceCheckBox;
    private JCheckBox datasourceMatrixCheckBox;
    private JPanel initiationPanels;
    private ButtonGroup modelButtonGroup;
    private JCheckBox modelCheckBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JCheckBox replaceWithMedianBox;
    private JComboBoxCell scriptComboBox;
    private JPanel scriptPanel;
    private JScrollPane scriptScrollPane;
    private JTextArea scriptTextArea;
    private JPanel settingsPanel;
    private final ScriptFile importTemplate;

    public OtherSettingsPanel(Project_GUI project_GUI, AbstractWizard abstractWizard, AbstractModel abstractModel, String string, boolean bl, ScriptFile scriptFile) {
        super((LayoutManager)new GridBagLayout(), abstractWizard);
        this.calibrationModel = abstractModel;
        this.supportDataSource = bl;
        this.importTemplate = scriptFile;
        this.initComponents();
        this.createDatasetTable.setSelected(IniManager.getImportSettings("DATASETTABLE", true));
        this.modelCheckBox.setSelected(IniManager.getImportSettings("CREATEMODEL", true));
        this.datasourceCheckBox.setEnabled(bl);
        this.datasourceMatrixCheckBox.setEnabled(false);
        if (project_GUI != null) {
            AbstractDataNode abstractDataNode = project_GUI.getRootNode();
            this.nameTextField.setText(abstractDataNode.getUniqueName(string));
        } else {
            this.nameTextField.setText(string);
        }
        this.scriptTextArea.setText("No template available");
    }

    @Override
    public boolean finishedPressed() {
        if (this.ciModel != null) {
            this.ciModel.dataSetName = this.nameTextField.getText();
            this.ciModel.createQuickTable = this.createQuickTable.isSelected();
            this.ciModel.createDatasetTable = this.createDatasetTable.isSelected();
            if (this.modelCheckBox.isSelected()) {
                this.ciModel.modelComponent = this.getSelectedModelInfo();
            }
            boolean bl = this.datasourceCheckBox.isSelected() && this.datasourceCheckBox.isEnabled();
            this.ciModel.setDataSource(bl);
            this.ciModel.setDataSourceMatrix(bl && this.datasourceMatrixCheckBox.isSelected());
            this.ciModel.setReplaceMissingWithMedian(this.replaceWithMedianBox.isSelected());
        }
        return super.nextPressed();
    }

    public void initTableModel(CellIdentifierModel cellIdentifierModel) {
        cellIdentifierModel.dataSetName = this.nameTextField.getText();
        cellIdentifierModel.createQuickTable = this.createQuickTable.isSelected();
        cellIdentifierModel.createDatasetTable = this.createDatasetTable.isSelected();
        boolean bl = this.datasourceCheckBox.isSelected() && this.datasourceCheckBox.isEnabled();
        cellIdentifierModel.setDataSource(bl);
        cellIdentifierModel.setDataSourceMatrix(bl && this.datasourceMatrixCheckBox.isSelected());
        cellIdentifierModel.setReplaceMissingWithMedian(this.replaceWithMedianBox.isSelected());
        Object object = this.scriptComboBox.getSelectedItem();
        if (object instanceof AbstractScriptInfo) {
            AbstractScriptInfo abstractScriptInfo = (AbstractScriptInfo)object;
            cellIdentifierModel.setScriptInfo(abstractScriptInfo);
            if (this.calibrationModel == null && object != this.importTemplate) {
                String string = "SCRIPT_IMPORT_" + this.getSubType(cellIdentifierModel).toUpperCase() + "_DEFAULT_" + this.maxdefaultindex;
                IniManager.setScriptSettings(string, abstractScriptInfo.toString());
            }
        }
        if (this.createQuickTable.isEnabled()) {
            IniManager.setImportSettings("QUICKTABLE", cellIdentifierModel.createQuickTable);
        }
        if (this.createDatasetTable.isEnabled()) {
            IniManager.setImportSettings("DATASETTABLE", cellIdentifierModel.createDatasetTable);
        }
        if (this.modelCheckBox.isEnabled()) {
            IniManager.setImportSettings("CREATEMODEL", this.modelCheckBox.isSelected());
        }
    }

    @Override
    public void pageShown() {
        boolean bl = ((ImportWizard)this.wizard).getCellIdentifierModel().isCalibrated();
        boolean bl2 = ((ImportWizard)this.wizard).getCellIdentifierModel().isMultiLayer();
        this.datasourceCheckBox.setEnabled(this.supportDataSource && !bl && !bl2);
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            this.datasourceCheckBox.setEnabled(this.supportDataSource);
        }
        this.modelCheckBox.getItemListeners()[0].itemStateChanged(null);
        this.updateDatasourceImage();
    }

    public void setTableModel(CellIdentifierModel cellIdentifierModel) {
        this.ciModel = cellIdentifierModel;
        if (this.calibrationModel == null) {
            this.maxdefaultindex = ScriptManager.addScriptInfoComboBox(this.scriptComboBox, "import", this.getSubType(cellIdentifierModel), cellIdentifierModel);
            if (this.importTemplate != null) {
                this.scriptComboBox.addItem(this.importTemplate);
                this.scriptComboBox.setSelectedItem(this.importTemplate);
            }
            this.modelVector.clear();
            List<AbstractInfo> list = ExtClassLoader.getAbstractInfoFromType(AbstractInfo.MODEL_INFO);
            for (AbstractModelInfo abstractModelInfo3 : list) {
                String i = abstractModelInfo3.getType();
                if (!i.equals("pca") && !i.equals("pls")) continue;
                this.modelVector.addElement(abstractModelInfo3);
            }
            Collections.sort(this.modelVector, (abstractModelInfo, abstractModelInfo2) -> abstractModelInfo.getType().compareTo(abstractModelInfo2.getType()));
            this.createPanel.removeAll();
            this.modelButtonGroup = new ButtonGroup();
            int n = this.modelVector.size();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                AbstractModelInfo abstractModelInfo3 = this.modelVector.elementAt(i);
                ModelRadioButton modelRadioButton = new ModelRadioButton(abstractModelInfo3.getType().toUpperCase(), abstractModelInfo3.needsDataY());
                if (bl2 && (!modelRadioButton.needsY || cellIdentifierModel.hasDataY())) {
                    modelRadioButton.setSelected(true);
                    bl2 = false;
                }
                modelRadioButton.setEnabled(false);
                this.modelButtonGroup.add(modelRadioButton);
                this.createPanel.add((Component)modelRadioButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 18, 0, 6), 0, 0));
            }
        } else {
            this.createPanel.removeAll();
            cellIdentifierModel.setCalibrationModel(this.calibrationModel);
            this.maxdefaultindex = ScriptManager.addScriptInfoComboBox(this.scriptComboBox, "prediction", cellIdentifierModel);
            cellIdentifierModel.setCalibrationModel(null);
        }
        this.modelCheckBox.setEnabled(this.calibrationModel == null && !this.modelVector.isEmpty());
        this.createDatasetTable.setEnabled(this.calibrationModel == null);
        if (this.calibrationModel != null) {
            this.createDatasetTable.setSelected(false);
        }
    }

    @Override
    public void setWizard(AbstractWizard abstractWizard) {
        super.setWizard(abstractWizard);
        abstractWizard.addNextListener(this.nameTextField);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (!(this.ciModel instanceof AbstractDataSource)) {
            this.ciModel.cleanUp();
        }
        this.ciModel = null;
    }

    private void datasourceCheckBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.updateDatasourceImage();
            this.datasourceMatrixCheckBox.setEnabled(this.datasourceCheckBox.isSelected() && this.datasourceCheckBox.isEnabled());
        }
    }

    private AbstractModelInfo getSelectedModelInfo() {
        Enumeration<AbstractButton> enumeration = this.modelButtonGroup.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.isSelected()) {
                return this.modelVector.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    private String getSubType(CellIdentifierModel cellIdentifierModel) {
        if (cellIdentifierModel.isMultiLayer()) {
            return "image";
        }
        return "normal";
    }

    private void initComponents() {
        this.modelButtonGroup = new ButtonGroup();
        this.settingsPanel = new JPanel();
        this.nameTextField = new JTextField();
        this.nameLabel = new JLabel();
        this.initiationPanels = new JPanel();
        this.scriptPanel = new JPanel();
        this.scriptComboBox = new JComboBoxCell();
        this.scriptScrollPane = new JScrollPane();
        this.scriptTextArea = new JTextArea();
        this.autoCreatePanel = new JPanel();
        this.createQuickTable = new JCheckBox();
        this.createDatasetTable = new JCheckBox();
        this.modelCheckBox = new JCheckBox();
        this.createPanel = new JPanel();
        this.replaceWithMedianBox = new JCheckBox();
        this.dataSourcePanel = new JPanel();
        this.dataSourceTextArea = new JTextArea();
        this.dataSourceLabel = new JLabel();
        this.datasourceCheckBox = new JCheckBox();
        this.datasourceMatrixCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.settingsPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Project settings"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.settingsPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.nameLabel.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.settingsPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.initiationPanels.setLayout(new BorderLayout());
        this.scriptPanel.setLayout(new GridBagLayout());
        this.scriptPanel.setBorder(BorderFactory.createTitledBorder("Choose template"));
        this.scriptComboBox.addItemListener(itemEvent -> this.scriptComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.scriptPanel.add((Component)this.scriptComboBox, gridBagConstraints);
        this.scriptScrollPane.setBorder(null);
        this.scriptScrollPane.setHorizontalScrollBarPolicy(31);
        this.scriptTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.scriptTextArea.setColumns(20);
        this.scriptTextArea.setFont(new Font("Dialog", 0, 11));
        this.scriptTextArea.setLineWrap(true);
        this.scriptTextArea.setRows(5);
        this.scriptTextArea.setWrapStyleWord(true);
        this.scriptScrollPane.setViewportView(this.scriptTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.scriptPanel.add((Component)this.scriptScrollPane, gridBagConstraints);
        this.initiationPanels.add((Component)this.scriptPanel, "Center");
        this.autoCreatePanel.setLayout(new GridBagLayout());
        this.autoCreatePanel.setBorder(BorderFactory.createTitledBorder("Additional template options"));
        this.createQuickTable.setText("Table of imported data");
        this.createQuickTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createQuickTable.setMargin(new Insets(0, 0, 0, 0));
        this.createQuickTable.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.autoCreatePanel.add((Component)this.createQuickTable, gridBagConstraints);
        this.createDatasetTable.setText("DataSet table");
        this.createDatasetTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createDatasetTable.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.autoCreatePanel.add((Component)this.createDatasetTable, gridBagConstraints);
        this.modelCheckBox.setText("Model with plots");
        this.modelCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modelCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.modelCheckBox.addItemListener(itemEvent -> this.modelCheckBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.autoCreatePanel.add((Component)this.modelCheckBox, gridBagConstraints);
        this.createPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.autoCreatePanel.add((Component)this.createPanel, gridBagConstraints);
        this.replaceWithMedianBox.setText("Replace missing values with median of neighbouring values");
        this.replaceWithMedianBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.replaceWithMedianBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.autoCreatePanel.add((Component)this.replaceWithMedianBox, gridBagConstraints);
        this.initiationPanels.add((Component)this.autoCreatePanel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.settingsPanel.add((Component)this.initiationPanels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.settingsPanel, gridBagConstraints);
        this.dataSourcePanel.setLayout(new GridBagLayout());
        this.dataSourcePanel.setBorder(BorderFactory.createTitledBorder("Keep data on disk"));
        this.dataSourceTextArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.dataSourceTextArea.setColumns(20);
        this.dataSourceTextArea.setFont(new Font("Dialog", 0, 11));
        this.dataSourceTextArea.setLineWrap(true);
        this.dataSourceTextArea.setRows(5);
        this.dataSourceTextArea.setText("The 'keep data on disk' feature preserves memory by letting the imported file reside on disk rather than in memory (RAM). Any changes made to the data will also be written to the file and vice versa. The 'keep data on disk' feature is especially useful for very large datasets or when the amount of RAM available to Evince is limited. Enabling 'keep data on disk' will negatively affect the calculation speed.");
        this.dataSourceTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.dataSourcePanel.add((Component)this.dataSourceTextArea, gridBagConstraints);
        this.dataSourceLabel.setIcon(new ImageIcon(Evince.class.getResource("gif/datasource.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.dataSourcePanel.add((Component)this.dataSourceLabel, gridBagConstraints);
        this.datasourceCheckBox.setText("Keep identifiers and auxiliary data on disk");
        this.datasourceCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.datasourceCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.datasourceCheckBox.addItemListener(itemEvent -> this.datasourceCheckBoxItemStateChanged(itemEvent));
        this.updateDatasourceImage();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.dataSourcePanel.add((Component)this.datasourceCheckBox, gridBagConstraints);
        this.datasourceMatrixCheckBox.setText("Keep numerical data on disk");
        this.datasourceMatrixCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.datasourceMatrixCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 24, 12, 0);
        this.dataSourcePanel.add((Component)this.datasourceMatrixCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.dataSourcePanel, gridBagConstraints);
    }

    private void modelCheckBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent == null || itemEvent.getStateChange() == 1) {
            Enumeration<AbstractButton> enumeration = this.modelButtonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                ModelRadioButton modelRadioButton = (ModelRadioButton)enumeration.nextElement();
                modelRadioButton.setEnabled(this.modelCheckBox.isSelected() && this.ciModel != null && (!modelRadioButton.needsY || this.ciModel.hasDataY()));
            }
        }
    }

    private void scriptComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = this.scriptComboBox.getSelectedItem();
            if (object instanceof AbstractScriptInfo) {
                AbstractScriptInfo abstractScriptInfo = (AbstractScriptInfo)object;
                if (object instanceof AbstractImportScriptInfo) {
                    AbstractImportScriptInfo abstractImportScriptInfo = (AbstractImportScriptInfo)object;
                    this.replaceWithMedianBox.setSelected(abstractImportScriptInfo.isReplaceMissingWithMedian() || this.ciModel != null && this.ciModel.isMultiLayer());
                } else {
                    this.replaceWithMedianBox.setSelected(false);
                }
                this.scriptTextArea.setText(abstractScriptInfo.getScriptInfo());
            } else {
                this.replaceWithMedianBox.setSelected(false);
                this.scriptTextArea.setText("No template available");
            }
        }
    }

    private void updateDatasourceImage() {
        try {
            Object object;
            InputStream inputStream = Evince.class.getResourceAsStream("gif/datasource.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            if (!this.datasourceCheckBox.isSelected() || !this.datasourceCheckBox.isEnabled()) {
                object = new BufferedImage(((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null), 2);
                Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                graphics2D.dispose();
                WritableRaster writableRaster = ((BufferedImage)object).getRaster();
                for (int i = 0; i < writableRaster.getHeight(); ++i) {
                    for (int j = 0; j < writableRaster.getWidth(); ++j) {
                        int n = writableRaster.getSample(j, i, 3);
                        writableRaster.setSample(j, i, 3, Math.max(0, n - 100));
                    }
                }
                ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                bufferedImage = colorConvertOp.filter((BufferedImage)object, null);
            }
            object = new ImageIcon(bufferedImage);
            this.dataSourceLabel.setIcon((Icon)object);
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
        }
    }

    private static class ModelRadioButton
    extends JRadioButton {
        private final boolean needsY;

        public ModelRadioButton(String string, boolean bl) {
            super(string);
            this.needsY = bl;
        }
    }
}

