/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.table.CheckBoxCellRenderer;
import se.prediktera.map.dataimport.MvInfo;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class VarianceDialog
extends CleanUpDialog {
    private final JScrollPane scrollPane = new JScrollPane();
    private final JTextFieldButtonUppDown tolerance = new JTextFieldButtonUppDown(0.0, Double.MAX_VALUE, true);
    private JTable table = null;
    private String title;
    private ArrayList<MvInfo> mvList = null;
    private int checktype = 0;
    private CellIdentifierModel model;
    private double[] variances = null;

    public static void autoExclude(int n, CellIdentifierModel cellIdentifierModel) {
        VarianceDialog varianceDialog = new VarianceDialog();
        varianceDialog.set("", n, cellIdentifierModel);
        varianceDialog.excludeSelected();
    }

    public VarianceDialog() {
        super((Frame)null, "Variance", true);
        this.jbInit();
    }

    public void excludeSelected() {
        int n = this.checktype == 1 ? 1 : 0;
        for (MvInfo mvInfo : this.mvList) {
            if (!mvInfo.excluded) continue;
            this.model.addInterval(n, mvInfo.index, (byte)2);
        }
    }

    public void set(String string, int n, CellIdentifierModel cellIdentifierModel) {
        this.model = cellIdentifierModel;
        this.title = string;
        this.checktype = n;
        this.table = new JTable();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed()) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    if (jTable.columnAtPoint(mouseEvent.getPoint()) == 2) {
                        int n = jTable.rowAtPoint(mouseEvent.getPoint());
                        MvInfo mvInfo = VarianceDialog.this.mvList.get(n);
                        mvInfo.excluded = !mvInfo.excluded;
                        jTable.repaint();
                    }
                    mouseEvent.consume();
                }
            }
        });
        this.table.setModel(new TableModel());
        this.table.setRowHeight(22);
        this.table.setDefaultRenderer(JCheckBox.class, new CheckBoxCellRenderer());
        this.scrollPane.getViewport().setView(this.table);
        this.tolerance.setNumber(0.001);
        this.setTolerance(0.001);
    }

    public void showModal(String string, int n, CellIdentifierModel cellIdentifierModel) {
        this.setTitle("Auto-Exclude (" + string + ")");
        this.set(string, n, cellIdentifierModel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    protected void cleanUpChild() {
    }

    private void jbInit() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMaximumSize(new Dimension(300, 320));
        jPanel.setMinimumSize(new Dimension(300, 320));
        jPanel.setPreferredSize(new Dimension(300, 320));
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel.add((Component)jPanel2, "Center");
        JButton jButton = new JButton("Select All");
        JButton jButton2 = new JButton("Clear All");
        jButton.addActionListener(actionEvent -> this.setExclude(true));
        jButton2.addActionListener(actionEvent -> this.setExclude(false));
        JPanel jPanel3 = new JPanel();
        jPanel3.add((Component)jButton2, null);
        jPanel3.add((Component)jButton, null);
        this.tolerance.setStepSize(0.001);
        this.tolerance.setNumberChangedInterface((n, d) -> this.setTolerance(d));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Variance Cutoff"));
        jPanel4.add((Component)this.tolerance, "Center");
        jPanel.add((Component)jPanel4, "South");
        jPanel2.add((Component)this.scrollPane, "Center");
        jPanel2.add((Component)jPanel3, "South");
        JButton jButton3 = new JButton("Cancel");
        JButton jButton4 = new JButton("OK");
        JButton jButton5 = new JButton("Help");
        jButton3.setMnemonic('C');
        jButton3.addActionListener(actionEvent -> this.dispose());
        jButton4.setMnemonic('O');
        jButton4.addActionListener(actionEvent -> {
            this.excludeSelected();
            this.dispose();
        });
        jButton5.setMnemonic('H');
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel5, "South");
        JPanel jPanel6 = new JPanel();
        jPanel5.add((Component)jPanel6, "East");
        jPanel6.add((Component)jButton4, null);
        jPanel6.add((Component)jButton3, null);
        jButton4.requestFocus();
    }

    private void setExclude(boolean bl) {
        for (MvInfo mvInfo : this.mvList) {
            mvInfo.excluded = bl;
        }
        this.table.repaint();
    }

    private void setTolerance(double d) {
        int n;
        int n2;
        if (this.model == null) {
            return;
        }
        boolean bl = this.checktype == 1;
        int n3 = n2 = bl ? this.model.getColumnCount() : this.model.getRowCount();
        if (this.variances == null) {
            this.variances = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.variances[n] = this.model.getVariance(bl, n);
            }
        }
        if (this.mvList == null) {
            this.mvList = new ArrayList(n2);
        } else {
            this.mvList.clear();
        }
        for (n = 0; n < n2; ++n) {
            double d2 = this.variances[n];
            if (!(d2 >= 0.0) || !(d2 < d)) continue;
            this.mvList.add(new MvInfo(d2, n, true));
        }
        this.table.revalidate();
    }

    class TableModel
    extends AbstractTableModel {
        TableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return switch (n) {
                case 2 -> JCheckBox.class;
                default -> String.class;
            };
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            return switch (n) {
                case 1 -> "Variance";
                case 2 -> "Exclude";
                default -> VarianceDialog.this.title;
            };
        }

        @Override
        public int getRowCount() {
            if (VarianceDialog.this.mvList == null) {
                return 0;
            }
            return VarianceDialog.this.mvList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MvInfo mvInfo = VarianceDialog.this.mvList.get(n);
            return switch (n2) {
                case 1 -> String.format("%4f", mvInfo.percentage);
                case 2 -> mvInfo.excluded;
                default -> {
                    if (VarianceDialog.this.checktype == 1) {
                        int var4_4 = VarianceDialog.this.model.getPrimaryRow();
                        if (var4_4 < 0) {
                            yield String.valueOf(mvInfo.index);
                        }
                        if (VarianceDialog.this.model.getRowType(var4_4) == 0) {
                            yield VarianceDialog.this.model.getValueAt(var4_4, mvInfo.index);
                        }
                    } else {
                        int var4_5 = VarianceDialog.this.model.getPrimaryCol();
                        if (var4_5 < 0) {
                            yield String.valueOf(mvInfo.index);
                        }
                        if (VarianceDialog.this.model.getColumnType(var4_5) == 1) {
                            yield VarianceDialog.this.model.getValueAt(mvInfo.index, var4_5);
                        }
                    }
                    yield String.valueOf(mvInfo.index + 1);
                }
            };
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

