/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.arff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ArffDataSource
extends CellIdentifierModel {
    private final List<Relation> relations = new ArrayList<Relation>();
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<DataRow> datas = new ArrayList<DataRow>();

    public ArffDataSource(File[] fileArray, ImportInterface importInterface) throws IOException, IndexOutOfBoundsException {
        super(0, 0);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[0]));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = string.toLowerCase();
                if (string2.startsWith("@relation")) {
                    this.relations.add(new Relation(string));
                    continue;
                }
                if (string2.startsWith("@attribute")) {
                    this.attributes.add(new Attribute(string, this.attributes.size()));
                    continue;
                }
                if (!string2.startsWith("@data")) continue;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.isEmpty()) continue;
                    this.datas.add(new DataRow(string));
                }
            }
        }
        this.rows = 1 + this.datas.size();
        if (!this.datas.isEmpty()) {
            this.columns = this.datas.get(0).getColumns();
        }
    }

    @Override
    public void autoIdentifyData(ProgressManager progressManager, int n) {
        this.addInterval(0, 0, (byte)0);
        this.setPrimaryRow(0);
        for (Attribute attribute : this.attributes) {
            this.addInterval(1, attribute.getIndex(), attribute.getId());
        }
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (n == 0) {
            return fastDecimal.error();
        }
        return fastDecimal.setValue(this.datas.get(n - 1).getDataValue(n2));
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        if (n == 0) {
            return this.attributes.get(n2).getName();
        }
        return this.datas.get(n - 1).getValue(n2);
    }

    private static class Relation {
        private String name;

        public Relation(String string) {
            String[] stringArray = string.split(" ");
            if (stringArray.length >= 2) {
                this.name = stringArray[1];
            }
        }

        public String getName() {
            return this.name;
        }
    }

    private static class Attribute {
        private String name;
        private final int index;
        private byte id;

        public Attribute(String string, int n) {
            this.index = n;
            String[] stringArray = string.replace("\t", " ").split(" ");
            if (stringArray.length >= 3) {
                this.name = stringArray[1];
                this.id = stringArray[2].equalsIgnoreCase("numeric") ? (byte)4 : (byte)3;
            }
        }

        public String getName() {
            return this.name;
        }

        public byte getId() {
            return this.id;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class DataRow {
        private final String[] split;

        public DataRow(String string) {
            this.split = string.split(",");
        }

        public int getColumns() {
            return this.split.length;
        }

        public double getDataValue(int n) {
            return NiceDataFormat.toNumber(this.getValue(n));
        }

        public String getValue(int n) {
            if (n < this.split.length) {
                return this.split[n];
            }
            return "";
        }
    }
}

