/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.breeze.image.count;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import se.prediktera.map.common.jama.MatrixExtensions;
import se.prediktera.map.dataimport.breeze.image.count.ObjectIdentificationHelper;
import se.prediktera.map.dataimport.breeze.image.count.SpatialObject;
import se.prediktera.map.dataimport.image.Pixel;

public class IdentifiedObject
implements SpatialObject,
Cloneable {
    private static final double CONVCRITSQ = 1.0E-12;
    private static final int NITMAX = 200;
    public int id;
    private Object reference;
    private float resolution = 1.0f;
    protected int width;
    protected int height;
    protected int area;
    protected int circumference;
    protected double regularity;
    protected double roundness;
    protected double orientation;
    protected double d1;
    protected double d2;
    public int min;
    public int max;
    public double radius;
    public double areadivcirc;
    public double ssx;
    public List<Pixel> pointList = new LinkedList<Pixel>();
    public List<Pixel> maxPointList = null;
    private Pixel centerPixel = new Pixel();
    private boolean touchborder = false;
    private float xcenter;
    private float ycenter;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private List<Pixel> borderList;

    public IdentifiedObject(int n) {
        this.id = n;
    }

    public IdentifiedObject(int n, int[][] nArray, int n2, int n3, int n4) {
        this.id = n;
        this.max = this.min = n2;
        this.maxPointList = new LinkedList<Pixel>();
        this.add(nArray, n3, n4, n2);
    }

    public IdentifiedObject(int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        this.width = n4;
        this.height = n5;
        this.circumference = n6;
        this.regularity = d3;
        this.roundness = d4;
        this.orientation = d5;
        this.d1 = d;
        this.d2 = d2;
        this.id = n;
        this.min = n2;
        this.max = n3;
        this.radius = d6;
        this.ssx = d7;
        this.areadivcirc = d8;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object object) {
        this.reference = object;
    }

    public void add(IdentifiedObject identifiedObject) {
        List<Pixel> list = identifiedObject.getPointList();
        for (Pixel pixel : list) {
            this.addPixel(pixel);
        }
    }

    public Pixel add(int[][] nArray, int n, int n2, int n3) {
        nArray[n2][n] = this.id;
        Pixel pixel = new Pixel(n, n2, n3);
        this.addPixel(pixel);
        return pixel;
    }

    public void add(int n, int n2) {
        this.pointList.add(new Pixel(n, n2));
    }

    public void analyseObject(boolean bl) {
        this.calculateWidhtHeightAndCenter();
        this.calculateMaxRadiusAndRoundness();
        if (bl) {
            this.rotateObjectUsingPCAandCalculateD1D2Orientation();
        } else {
            this.d1 = Math.max(this.width, this.height);
            this.d2 = Math.min(this.width, this.height);
            this.orientation = 0.0;
        }
        this.calculateCircumferenceAndRegularity();
    }

    private void calculateMaxRadiusAndRoundness() {
        double d;
        double d2 = 0.0;
        for (Pixel pixel : this.pointList) {
            d = (float)pixel.x - this.xcenter;
            double d3 = (float)pixel.y - this.ycenter;
            double d4 = d * d + d3 * d3;
            if (!(d4 > d2)) continue;
            d2 = d4;
        }
        double d5 = this.getArea();
        this.radius = Math.sqrt(d2);
        d = Math.PI * this.radius * this.radius;
        this.roundness = d5 / d;
        if (this.roundness > 1.0) {
            this.roundness = 1.0;
        }
    }

    private void calculateWidhtHeightAndCenter() {
        this.xmin = Integer.MAX_VALUE;
        this.xmax = 0;
        this.ymin = Integer.MAX_VALUE;
        this.ymax = 0;
        int n = 0;
        this.xcenter = 0.0f;
        this.ycenter = 0.0f;
        for (Pixel pixel : this.pointList) {
            if (pixel.x < this.xmin) {
                this.xmin = pixel.x;
            }
            if (pixel.x > this.xmax) {
                this.xmax = pixel.x;
            }
            if (pixel.y < this.ymin) {
                this.ymin = pixel.y;
            }
            if (pixel.y > this.ymax) {
                this.ymax = pixel.y;
            }
            if (pixel.z > n) {
                n = pixel.z;
                this.centerPixel.x = pixel.x;
                this.centerPixel.y = pixel.y;
            }
            this.xcenter = (float)((double)this.xcenter + ((double)pixel.x + 0.5));
            this.ycenter = (float)((double)this.ycenter + ((double)pixel.y + 0.5));
        }
        this.width = this.xmax - this.xmin + 1;
        this.height = this.ymax - this.ymin + 1;
        this.xcenter /= (float)this.pointList.size();
        this.ycenter /= (float)this.pointList.size();
    }

    private void calculateCircumferenceAndRegularity() {
        this.borderList = ObjectIdentificationHelper.followPixelBorder(this.pointList, this.xmin, this.ymin, this.width, this.height);
        if (this.borderList != null) {
            this.circumference = 0;
            for (int i = 1; i < this.borderList.size(); ++i) {
                Pixel pixel = this.borderList.get(i - 1);
                Pixel pixel2 = this.borderList.get(i);
                this.circumference += Math.abs(pixel.x - pixel2.x) + Math.abs(pixel.y - pixel2.y);
            }
            double d = this.getArea();
            double d2 = Math.sqrt(d / Math.PI);
            double d3 = Math.PI * 2 * d2;
            this.regularity = d3 / (double)this.circumference;
            if (this.circumference > 0) {
                this.areadivcirc = d / (double)this.circumference;
            }
        }
    }

    private void rotateObjectUsingPCAandCalculateD1D2Orientation() {
        double d;
        double d2;
        double d3;
        Pixel pixel2;
        DenseMatrix denseMatrix = new DenseMatrix(this.pointList.size(), 2);
        int n = 0;
        for (Pixel pixel2 : this.pointList) {
            d3 = (float)pixel2.x - this.xcenter;
            d2 = (float)pixel2.y - this.ycenter;
            denseMatrix.set(n, 0, d3);
            denseMatrix.set(n, 1, d2);
            ++n;
        }
        DenseVector[][] denseVectorArray = this.createPCA(denseMatrix, 1);
        pixel2 = denseVectorArray[1][0];
        d3 = pixel2.get(0);
        d2 = pixel2.get(1);
        if (d3 < 0.0) {
            d3 *= -1.0;
            d2 *= -1.0;
        }
        if (d2 < 0.0) {
            d3 *= -1.0;
            d2 *= -1.0;
        }
        if ((d = Math.acos(d3 *= -1.0)) >= 0.0) {
            this.orientation = d / Math.PI * 180.0;
            if (this.orientation >= 180.0) {
                this.orientation -= 180.0;
            }
            if (this.orientation < 0.0) {
                this.orientation += 180.0;
            }
        } else {
            this.orientation = 0.0;
        }
        double d4 = 2.147483647E9;
        double d5 = 0.0;
        double d6 = 2.147483647E9;
        double d7 = 0.0;
        double d8 = Math.cos(d);
        double d9 = Math.sin(d);
        for (Pixel pixel3 : this.pointList) {
            double d10 = (float)pixel3.x - this.xcenter;
            double d11 = (float)pixel3.y - this.ycenter;
            double d12 = d10 * d8 - d11 * d9;
            double d13 = d11 * d8 + d10 * d9;
            if (d12 < d4) {
                d4 = d12;
            }
            if (d12 > d5) {
                d5 = d12;
            }
            if (d13 < d6) {
                d6 = d13;
            }
            if (!(d13 > d7)) continue;
            d7 = d13;
        }
        this.d1 = d5 - d4;
        if (this.d1 < 0.0) {
            this.d1 = 0.0;
        }
        this.d2 = d7 - d6;
        if (this.d2 < 0.0) {
            this.d2 = 0.0;
        }
    }

    public boolean checkAndMergeObjects(int[][] nArray, IdentifiedObject identifiedObject, double d) {
        if ((double)this.min + (double)this.max * d >= (double)identifiedObject.getMax()) {
            this.mergeObjects(nArray, identifiedObject);
            return true;
        }
        return false;
    }

    public void mergeObjects(int[][] nArray, IdentifiedObject identifiedObject) {
        List<Pixel> list = identifiedObject.getPointList();
        for (Pixel pixel : list) {
            nArray[pixel.y][pixel.x] = this.id;
        }
        this.pointList.addAll(identifiedObject.getPointList());
        if (this.maxPointList != null && this.max == identifiedObject.getMax()) {
            this.maxPointList.addAll(identifiedObject.getMaxPointList());
        }
        if (identifiedObject.touchborder) {
            this.setTouchBorder(true);
        }
    }

    public void clear(int[][] nArray) {
        for (Pixel pixel : this.pointList) {
            nArray[pixel.y][pixel.x] = 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IdentifiedObject identifiedObject = (IdentifiedObject)super.clone();
        if (this.pointList != null) {
            Collections.copy(identifiedObject.pointList, this.pointList);
        }
        if (this.maxPointList != null) {
            Collections.copy(identifiedObject.maxPointList, this.maxPointList);
        }
        identifiedObject.centerPixel = (Pixel)this.centerPixel.clone();
        return identifiedObject;
    }

    public boolean equals(Object object) {
        if (object instanceof IdentifiedObject) {
            return this.id == ((IdentifiedObject)object).getId() && super.equals(object);
        }
        return super.equals(object);
    }

    @Override
    public int[] getBoundingBox() {
        return new int[]{this.xmin, this.ymin, this.xmax - this.xmin + 1, this.ymax - this.ymin + 1};
    }

    @Override
    public int[][] getPath() {
        int[][] nArray = new int[this.borderList.size()][2];
        for (int i = 0; i < this.borderList.size(); ++i) {
            nArray[i][0] = this.borderList.get((int)i).x + this.xmin;
            nArray[i][1] = this.borderList.get((int)i).y + this.ymin;
        }
        return nArray;
    }

    @Override
    public int getArea() {
        return this.pointList.size();
    }

    public double getAreadivcirc() {
        return this.areadivcirc;
    }

    public boolean isTouchborder() {
        return this.touchborder;
    }

    public int getAreaIn(int n, int n2, int n3, int n4) {
        int n5 = 0;
        for (Pixel pixel : this.pointList) {
            if (pixel.x < n || pixel.x >= n2 || pixel.y < n3 || pixel.y >= n4) continue;
            ++n5;
        }
        return n5;
    }

    @Override
    public float[] getCenterPoint() {
        return new float[]{this.xcenter, this.ycenter};
    }

    public Pixel getCenterPoint2() {
        int n = 0;
        int n2 = 0;
        List<Pixel> list = this.maxPointList;
        if (list == null || list.isEmpty()) {
            list = this.pointList;
        }
        if (!list.isEmpty()) {
            for (Pixel pixel : list) {
                n += pixel.x;
                n2 += pixel.y;
            }
            return new Pixel(n / list.size(), n2 / list.size());
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public int getMax() {
        return this.max;
    }

    public Pixel getMaxPoint() {
        return this.pointList.get(0);
    }

    public List<Pixel> getMaxPointList() {
        return this.maxPointList;
    }

    public int getMin() {
        return this.min;
    }

    public List<Pixel> getPointList() {
        return this.pointList;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSsx() {
        return this.ssx;
    }

    public boolean isMaximum(IdentifiedObject identifiedObject) {
        return this.max > identifiedObject.getMax();
    }

    public void setTouchBorder(boolean bl) {
        this.touchborder = bl;
    }

    public void cleanUp() {
        if (this.pointList != null) {
            this.pointList.clear();
            this.pointList = null;
        }
        if (this.maxPointList != null) {
            this.maxPointList.clear();
            this.maxPointList = null;
        }
        this.centerPixel = null;
    }

    private void addPixel(Pixel pixel) {
        if (this.min > pixel.z) {
            this.min = pixel.z;
        }
        if (this.max < pixel.z) {
            this.max = pixel.z;
        }
        this.pointList.add(pixel);
        if (this.maxPointList != null && pixel.z == this.max) {
            this.maxPointList.add(pixel);
        }
    }

    public BufferedImage createObjectImage() {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (Pixel pixel : this.pointList) {
            if (pixel.x < n) {
                n = pixel.x;
            }
            if (pixel.x > n2) {
                n2 = pixel.x;
            }
            if (pixel.y < n3) {
                n3 = pixel.y;
            }
            if (pixel.y <= n4) continue;
            n4 = pixel.y;
        }
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        BufferedImage bufferedImage = new BufferedImage(n5, n6, 2);
        for (Pixel pixel : this.pointList) {
            bufferedImage.setRGB(pixel.x - n, pixel.y - n3, Color.black.getRGB());
        }
        return bufferedImage;
    }

    private DenseVector[][] createPCA(DenseMatrix denseMatrix, int n) {
        double d = 0.0;
        for (int i = 0; i < denseMatrix.numRows(); ++i) {
            for (int j = 0; j < denseMatrix.numColumns(); ++j) {
                double d2 = denseMatrix.get(i, j);
                d += d2 * d2;
            }
        }
        DenseVector[] denseVectorArray = new DenseVector[n];
        DenseVector[] denseVectorArray2 = new DenseVector[n];
        for (int i = 0; i < n; ++i) {
            double d3;
            double d4;
            int n2 = denseMatrix.numRows();
            DenseVector denseVector = denseVectorArray[i] = new DenseVector(n2);
            for (int j = 0; j < n2; ++j) {
                denseVector.set(j, (denseMatrix.get(j, 0) + denseMatrix.get(j, 1)) / 2.0);
            }
            DenseVector denseVector2 = new DenseVector(n2);
            DenseVector denseVector3 = null;
            DenseVector denseVector4 = denseVectorArray2[i] = new DenseVector(denseMatrix.numColumns());
            int n3 = 0;
            for (double d5 = 42.0; n3 < 200 && d5 > 1.0E-12; d5 /= d4, ++n3) {
                denseVector3 = denseVector2;
                denseVector2 = denseVector;
                denseVector = denseVector3;
                MatrixExtensions.transMult(denseVector4, (Matrix)denseMatrix, denseVector2);
                denseVector4.scale(1.0 / denseVector4.norm(Vector.Norm.Two));
                MatrixExtensions.mult(denseVector, (Matrix)denseMatrix, denseVector4);
                d5 = 0.0;
                double[] dArray = denseVector2.getData();
                double[] dArray2 = denseVector.getData();
                d4 = 0.0;
                d3 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d3 = dArray2[j];
                    d4 += d3 * d3;
                    d5 += (d3 -= dArray[j]) * d3;
                }
            }
            double d6 = 0.0;
            for (int j = 0; j < denseMatrix.numRows(); ++j) {
                for (int k = 0; k < denseMatrix.numColumns(); ++k) {
                    denseMatrix.set(j, k, denseMatrix.get(j, k) - denseVector.get(j) * denseVector4.get(k));
                    d3 = denseMatrix.get(j, k);
                    d6 += d3 * d3;
                }
            }
            this.ssx = d == 0.0 ? 1.0 : (d - d6) / d;
        }
        return new DenseVector[][]{denseVectorArray, denseVectorArray2};
    }

    @Override
    public void forEveryPixel(SpatialObject.ForEveryPixelCallback forEveryPixelCallback) {
        for (Pixel pixel : this.pointList) {
            forEveryPixelCallback.withPixel(pixel.x, pixel.y, pixel.z);
        }
    }

    @Override
    public void setResolution(float f) {
        this.resolution = f;
    }

    @Override
    public float getResolution() {
        return this.resolution;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getCircumference() {
        return this.circumference;
    }

    @Override
    public double getRegularity() {
        return this.regularity;
    }

    @Override
    public double getRoundness() {
        return this.roundness;
    }

    @Override
    public double getOrientation() {
        return this.orientation;
    }

    @Override
    public double getD1() {
        return this.d1;
    }

    @Override
    public double getD2() {
        return this.d2;
    }
}

