/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.breeze.image.count;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.dataimport.breeze.image.count.IdentifiedObject;
import se.prediktera.map.dataimport.image.Pixel;
import se.prediktera.map.datasetcontainer.matrix.MatrixInterface;

public class ObjectIdentificationHelper {
    private static int[][] cursor_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private static int[][] cursor_pixel = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};
    private static int[][] cursor_forward = new int[][]{{-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private static int[][] cursor_backwards = new int[][]{{-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}, {0, 1}, {-1, 1}};
    private static boolean printmatrix = false;
    public static int[][] idMatrix;

    public static List<Pixel> followPixelBorder(List<Pixel> list, int n, int n2, int n3, int n4) {
        boolean bl;
        LinkedList<Pixel> linkedList = new LinkedList<Pixel>();
        int n5 = 0;
        int n6 = -1;
        boolean[][] blArray = new boolean[++n3][++n4];
        int n7 = 0;
        int n8 = Integer.MAX_VALUE;
        for (Pixel pixel : list) {
            blArray[pixel.x - n][pixel.y - n2] = true;
            blArray[pixel.x - n + 1][pixel.y - n2] = true;
            blArray[pixel.x - n][pixel.y - n2 + 1] = true;
            blArray[pixel.x - n + 1][pixel.y - n2 + 1] = true;
            if (pixel.y - n2 >= n8) continue;
            n7 = pixel.x - n;
            n8 = pixel.y - n2;
        }
        int n9 = n7;
        int n10 = n8;
        block1: do {
            bl = false;
            for (int i = 0; i < cursor_pixel.length; ++i) {
                int n11 = ObjectIdentificationHelper.getDirection(n5, i);
                int[] nArray = cursor_pixel[n11];
                int n12 = n9 + nArray[0];
                int n13 = n10 + nArray[1];
                if (n12 < 0 || n13 < 0 || n12 >= n3 || n13 >= n4 || !blArray[n12][n13]) continue;
                bl = true;
                if (n6 != n11) {
                    linkedList.add(new Pixel(n9, n10));
                    n6 = n5 = n11;
                }
                n9 = n12;
                n10 = n13;
                continue block1;
            }
        } while (bl && (n9 != n7 || n10 != n8));
        linkedList.add(new Pixel(n7, n8));
        return linkedList;
    }

    private static int getDirection(int n, int n2) {
        int n3 = n + n2 - 1;
        if (n3 < 0) {
            return n3 + cursor_pixel.length;
        }
        if (n3 >= cursor_pixel.length) {
            return n3 - cursor_pixel.length;
        }
        return n3;
    }

    private static void printIdMatrix(int[][] nArray, int n) {
        if (printmatrix) {
            System.out.println("#### " + n + " ####");
            for (int[] nArray2 : nArray) {
                for (int i = 0; i < nArray2.length; ++i) {
                    System.out.print(nArray2[i] + ", ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
    }

    public static void printMatrixIfDebug(MatrixInterface matrixInterface) {
        if (printmatrix) {
            ObjectIdentificationHelper.printMatrix(matrixInterface);
        }
    }

    public static void printMatrix(MatrixInterface matrixInterface) {
        for (int i = 0; i < matrixInterface.getN(); ++i) {
            for (int j = 0; j < matrixInterface.getK(); ++j) {
                System.out.print(NiceDataFormat.toString(matrixInterface.getValue(i, j), 4) + ", ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public static void printMatrixBinary(MatrixInterface matrixInterface) {
        for (int i = 0; i < matrixInterface.getN(); ++i) {
            for (int j = 0; j < matrixInterface.getK(); ++j) {
                System.out.print(matrixInterface.getValue(i, j) > 0.0 ? "X" : " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public static void printMatrixBinaryMissing(MatrixInterface matrixInterface) {
        for (int i = 0; i < matrixInterface.getN(); ++i) {
            for (int j = 0; j < matrixInterface.getK(); ++j) {
                System.out.print(matrixInterface.isMissing(i, j) ? " " : "X");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public static LinkedList<IdentifiedObject> identifyAreas(MatrixInterface matrixInterface, int n, int n2) {
        int n3 = matrixInterface.getN();
        int n4 = matrixInterface.getK();
        ObjectIdentificationHelper.printMatrixIfDebug(matrixInterface);
        ObjectIdentificationHelper.calculateDistance(matrixInterface, n3, n4);
        if (n > 0) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    matrixInterface.setValue(i, j, Math.max(0.0, matrixInterface.getValue(i, j) - (double)n));
                }
            }
        }
        ObjectIdentificationHelper.printMatrixIfDebug(matrixInterface);
        idMatrix = new int[n3][n4];
        LinkedList<IdentifiedObject> linkedList = new LinkedList<IdentifiedObject>();
        LinkedList<IdentifiedObject> linkedList2 = new LinkedList<IdentifiedObject>();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (!(matrixInterface.getValue(i, j) > 0.0) || idMatrix[i][j] != 0) continue;
                IdentifiedObject identifiedObject = new IdentifiedObject(linkedList.size() + 1);
                LinkedList<Pixel> linkedList3 = new LinkedList<Pixel>();
                linkedList3.add(identifiedObject.add(idMatrix, j, i, 1));
                while (!linkedList3.isEmpty()) {
                    boolean bl;
                    Pixel pixel = (Pixel)linkedList3.remove(0);
                    boolean bl2 = bl = pixel.x == 0 || pixel.y == 0 || pixel.x == n4 - 1 || pixel.y == n3 - 1;
                    if (bl) {
                        identifiedObject.setTouchBorder(bl);
                    }
                    for (int[] nArray : cursor_maximum) {
                        int n5 = pixel.y + nArray[1];
                        int n6 = pixel.x + nArray[0];
                        double d = ObjectIdentificationHelper.min(matrixInterface, n5, n6, n3, n4, 2.147483647E9);
                        if (!(d > 0.0) || idMatrix[n5][n6] != 0) continue;
                        linkedList3.add(identifiedObject.add(idMatrix, n6, n5, (int)d));
                    }
                }
                if (identifiedObject.getArea() >= n2) {
                    linkedList.add(identifiedObject);
                    continue;
                }
                linkedList2.add(identifiedObject);
            }
        }
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            ((IdentifiedObject)iterator.next()).clear(idMatrix);
        }
        return linkedList;
    }

    public static LinkedList<IdentifiedObject> identifyBlobs(MatrixInterface matrixInterface, double d, int n) {
        int n2 = matrixInterface.getN();
        int n3 = matrixInterface.getK();
        ObjectIdentificationHelper.printMatrixIfDebug(matrixInterface);
        ObjectIdentificationHelper.calculateDistance(matrixInterface, n2, n3);
        ObjectIdentificationHelper.printMatrixIfDebug(matrixInterface);
        return ObjectIdentificationHelper.identifyBlobsDistance(matrixInterface, d, n);
    }

    public static LinkedList<IdentifiedObject> identifyBlobsDistance(MatrixInterface matrixInterface, double d, int n) {
        int n2;
        int n3 = matrixInterface.getN();
        int n4 = matrixInterface.getK();
        idMatrix = null;
        int n5 = 0;
        LinkedList<IdentifiedObject> linkedList = new LinkedList<IdentifiedObject>();
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (!(matrixInterface.getValue(i, n2) > 0.0)) continue;
                int n6 = (int)matrixInterface.getValue(i, n2);
                boolean bl = true;
                for (int[] nArray : cursor_maximum) {
                    double d2 = ObjectIdentificationHelper.min(matrixInterface, i + nArray[1], n2 + nArray[0], n3, n4, 2.147483647E9);
                    if (!((double)n6 < d2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (idMatrix == null) {
                    idMatrix = new int[n3][n4];
                }
                if (n5 < n6) {
                    n5 = n6;
                }
                linkedList.add(new IdentifiedObject(linkedList.size() + 1, idMatrix, n6, n2, i));
            }
        }
        if (!linkedList.isEmpty()) {
            ObjectIdentificationHelper.printIdMatrix(idMatrix, n5 + 1);
            LinkedList<Pixel> linkedList2 = new LinkedList<Pixel>();
            for (n2 = n5; n2 > 0; --n2) {
                Object object;
                LinkedList<Pixel> linkedList3 = new LinkedList<Pixel>();
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    object = (IdentifiedObject)iterator.next();
                    if (((IdentifiedObject)object).getMax() != n2) continue;
                    linkedList2.add(new Pixel(((IdentifiedObject)object).getMaxPoint()));
                }
                iterator = linkedList2.iterator();
                while (iterator.hasNext()) {
                    object = (Pixel)iterator.next();
                    if (((Pixel)object).z != n2) continue;
                    int n7 = idMatrix[((Pixel)object).y][((Pixel)object).x];
                    IdentifiedObject identifiedObject = ObjectIdentificationHelper.getObjectFromId(linkedList, n7);
                    for (Object object2 : (int[])cursor_maximum) {
                        boolean bl;
                        int n8 = ((Pixel)object).y + object2[1];
                        int n9 = ((Pixel)object).x + object2[0];
                        double d3 = ObjectIdentificationHelper.min(matrixInterface, n8, n9, n3, n4, 2.147483647E9);
                        if (!(d3 > 0.0) || !(d3 <= (double)n2) || idMatrix[n8][n9] == n7) continue;
                        if (idMatrix[n8][n9] > 0) {
                            IdentifiedObject identifiedObject2 = ObjectIdentificationHelper.getObjectFromId(linkedList, idMatrix[n8][n9]);
                            if (identifiedObject.isMaximum(identifiedObject2)) {
                                if (!identifiedObject.checkAndMergeObjects(idMatrix, identifiedObject2, d)) continue;
                                linkedList.remove(identifiedObject2);
                                continue;
                            }
                            if (!identifiedObject2.checkAndMergeObjects(idMatrix, identifiedObject, d)) continue;
                            linkedList.remove(identifiedObject);
                            identifiedObject = identifiedObject2;
                            n7 = identifiedObject.getId();
                            continue;
                        }
                        boolean bl2 = bl = n9 == 0 || n8 == 0 || n9 == n4 - 1 || n8 == n3 - 1;
                        if (bl) {
                            identifiedObject.setTouchBorder(bl);
                        }
                        linkedList3.add(identifiedObject.add(idMatrix, n9, n8, (int)d3));
                    }
                    iterator.remove();
                }
                ObjectIdentificationHelper.printIdMatrix(idMatrix, n2);
                linkedList2.addAll(linkedList3);
            }
        }
        if (n > 0) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IdentifiedObject identifiedObject = (IdentifiedObject)iterator.next();
                if (identifiedObject.getArea() >= n) continue;
                identifiedObject.clear(idMatrix);
                iterator.remove();
            }
        }
        for (IdentifiedObject identifiedObject : linkedList) {
            Pixel pixel = identifiedObject.getCenterPoint2();
            matrixInterface.setValue(pixel.y, pixel.x, 50.0);
        }
        return linkedList;
    }

    public static void calculateDistance(MatrixInterface matrixInterface, int n, int n2) {
        double d;
        int n3;
        int n4;
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(matrixInterface.getValue(n4, n3) > 0.0)) continue;
                d = 2.147483647E9;
                for (int[] nArray : cursor_forward) {
                    d = ObjectIdentificationHelper.min(matrixInterface, n4 + nArray[1], n3 + nArray[0], n, n2, d);
                }
                matrixInterface.setValue(n4, n3, d + 1.0);
            }
        }
        for (n4 = n - 1; n4 >= 0; --n4) {
            for (n3 = n2 - 1; n3 >= 0; --n3) {
                if (!(matrixInterface.getValue(n4, n3) > 0.0)) continue;
                d = 2.147483647E9;
                for (int[] nArray : cursor_backwards) {
                    d = ObjectIdentificationHelper.min(matrixInterface, n4 + nArray[1], n3 + nArray[0], n, n2, d);
                }
                matrixInterface.setValue(n4, n3, d + 1.0);
            }
        }
    }

    private static IdentifiedObject getObjectFromId(List<IdentifiedObject> list, int n) {
        for (IdentifiedObject identifiedObject : list) {
            if (identifiedObject.getId() != n) continue;
            return identifiedObject;
        }
        return null;
    }

    private static double min(MatrixInterface matrixInterface, int n, int n2, int n3, int n4, double d) {
        if (n >= 0 && n2 >= 0 && n < n3 && n2 < n4) {
            double d2 = matrixInterface.getValue(n, n2);
            if (d2 < d) {
                return d2;
            }
            return d;
        }
        return 0.0;
    }

    public static String toDirection(double d, double d2) {
        if (d2 > 0.95) {
            return "C";
        }
        double d3 = 22.5;
        String[] stringArray = new String[]{"NE", "N", "NW", "W", "SW", "S", "SE"};
        int n = 0;
        while (n < stringArray.length) {
            if (d >= d3 && d < d3 + 45.0) {
                return stringArray[n];
            }
            ++n;
            d3 += 45.0;
        }
        return "E";
    }

    public static int[][] getCleanedIdMatrix(List<IdentifiedObject> list) {
        int n = idMatrix.length;
        int n2 = idMatrix[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                IdentifiedObject identifiedObject = ObjectIdentificationHelper.getObjectFromId(list, idMatrix[i][j]);
                ObjectIdentificationHelper.idMatrix[i][j] = identifiedObject != null ? identifiedObject.getId() : 0;
            }
        }
        ObjectIdentificationHelper.printIdMatrix(idMatrix, 1);
        return idMatrix;
    }
}

