/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.breeze.image.process;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import se.prediktera.map.common.Threader;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.MatrixInterface;

public class ImageProcessHelper {
    public static final byte MIN = 0;
    public static final byte MAX = 1;
    public static final byte AVERAGE = 2;
    public static final byte MEDIAN = 3;
    public static final byte DERIVATE = 4;
    public static final byte THRESHOLD = 5;
    public static final byte ERODE = 6;
    public static final byte DILATE = 7;
    public static final byte FILL = 8;
    public static final byte REMOVE_BORDER = 9;
    public static final String[] METHOD_NAME = new String[]{"Min", "Max", "Average", "Median", "Derivate", "Threshold", "Erode", "Dilate", "Fill", "Remove Border"};
    private static int[][] kernel_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};

    public static void fillMatrix(MatrixInterface matrixInterface, MatrixInterface matrixInterface2) {
        for (int i = 0; i < matrixInterface.getN(); ++i) {
            for (int j = 0; j < matrixInterface2.getK(); ++j) {
                matrixInterface2.setValue(i, j, matrixInterface.getValue(i, j));
            }
        }
        ImageProcessHelper.fillMatrix(matrixInterface2);
    }

    public static void fillMatrix(MatrixInterface matrixInterface) {
        int n = matrixInterface.getN();
        int n2 = matrixInterface.getK();
        boolean[][] blArray = new boolean[n2][n];
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (blArray[j][i] || matrixInterface.getValue(i, j) != 0.0 || matrixInterface.isMissing(i, j)) continue;
                arrayList.clear();
                arrayList.add(new Point(j, i));
                int n3 = 0;
                for (int k = 0; k < arrayList.size(); ++k) {
                    Point point = (Point)arrayList.get(k);
                    if (blArray[point.x][point.y]) continue;
                    blArray[point.x][point.y] = true;
                    for (int i2 = 0; i2 < kernel_maximum.length; i2 += 2) {
                        int n4 = point.x + kernel_maximum[i2][0];
                        int n5 = point.y + kernel_maximum[i2][1];
                        if (n4 >= 0 && n4 < n2 && n5 >= 0 && n5 < n && !matrixInterface.isMissing(n5, n4)) {
                            if (blArray[n4][n5] || matrixInterface.getValue(n5, n4) != 0.0) continue;
                            arrayList.add(new Point(n4, n5));
                            continue;
                        }
                        ++n3;
                    }
                }
                if (!((double)n3 < 50.0)) continue;
                for (Point point : arrayList) {
                    matrixInterface.setValue(point.y, point.x, 1.0);
                }
            }
        }
    }

    public static MatrixInterface processImageLocal(final ProgressManager progressManager, final MatrixInterface matrixInterface, final MatrixInterface matrixInterface2, final byte by, final double d, final int n) {
        final int n2 = n / 2;
        final int n3 = n * n;
        final int n4 = matrixInterface.getN();
        final int n5 = matrixInterface.getK();
        progressManager.setMaximumAndReset(n4);
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n6, int n22) {
                double[] dArray = new double[n3];
                for (int i = n6; i < n22; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        double d7 = matrixInterface.getValue(i, j);
                        boolean bl2 = matrixInterface.isMissing(i, j);
                        if (by == 5) {
                            if (!bl2 && d7 > d) {
                                matrixInterface2.setValue(i, j, 1.0);
                                continue;
                            }
                            matrixInterface2.setValue(i, j, 0.0, true);
                            continue;
                        }
                        double d2 = 0.0;
                        double d3 = 2.147483647E9;
                        double d4 = -2.147483647E9;
                        double d5 = 0.0;
                        int n32 = 0;
                        if (!bl2 || bl2 && by == 7) {
                            for (int k = 0; k < n; ++k) {
                                for (int i2 = 0; i2 < n; ++i2) {
                                    int n42 = j + k - n2;
                                    int n52 = i + i2 - n2;
                                    if (n42 < 0 || n42 >= n5 || n52 < 0 || n52 >= n4) continue;
                                    double d6 = matrixInterface.getValue(n52, n42);
                                    if (matrixInterface.isMissing(n52, n42)) continue;
                                    dArray[n32] = d6;
                                    d2 += d6;
                                    d3 = Math.min(d3, d6);
                                    d4 = Math.max(d4, d6);
                                    d5 = Math.max(0.0, Math.max(d5, d7 - d6));
                                    ++n32;
                                }
                            }
                        }
                        if (n32 > 0) {
                            switch (by) {
                                case 0: {
                                    matrixInterface2.setValue(i, j, d3);
                                    break;
                                }
                                case 1: {
                                    matrixInterface2.setValue(i, j, d4);
                                    break;
                                }
                                case 2: {
                                    matrixInterface2.setValue(i, j, d2 / (double)n32);
                                    break;
                                }
                                case 3: {
                                    Arrays.sort(dArray, 0, n32);
                                    matrixInterface2.setValue(i, j, dArray[n32 / 2]);
                                    break;
                                }
                                case 6: {
                                    if (n32 == n3) {
                                        matrixInterface2.setValue(i, j, d7);
                                        break;
                                    }
                                    matrixInterface2.setValue(i, j, 0.0, true);
                                    break;
                                }
                                case 7: {
                                    if (bl2) {
                                        matrixInterface2.removeMissing(i, j);
                                        matrixInterface2.setValue(i, j, 1.0);
                                    }
                                    matrixInterface2.setValue(i, j, 1.0);
                                    break;
                                }
                                case 4: {
                                    matrixInterface2.setValue(i, j, d5);
                                    break;
                                }
                                case 9: {
                                    if (n32 == n3) {
                                        matrixInterface2.setValue(i, j, d7);
                                        break;
                                    }
                                    matrixInterface2.setValue(i, j, 0.0, true);
                                }
                            }
                            continue;
                        }
                        matrixInterface2.setValue(i, j, 0.0, true);
                    }
                    progressManager.incStep();
                }
            }
        };
        threader.execute(n4);
        return matrixInterface2;
    }

    public static MatrixInterface processImageAverageKernel(final MatrixInterface matrixInterface, final MatrixInterface matrixInterface2, final int n) {
        final int n2 = n / 2;
        final int n3 = matrixInterface.getN();
        final int n4 = matrixInterface.getK();
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n6, int n22) {
                for (int i = n6; i < n22; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        int n32 = 0;
                        double d = 0.0;
                        if (!matrixInterface.isMissing(i, j)) {
                            for (int k = 0; k < n; ++k) {
                                for (int i2 = 0; i2 < n; ++i2) {
                                    int n42 = j + k - n2;
                                    int n5 = i + i2 - n2;
                                    if (n42 < 0 || n42 >= n4 || n5 < 0 || n5 >= n3) continue;
                                    double d2 = matrixInterface.getValue(n5, n42);
                                    if (matrixInterface.isMissing(n5, n42)) continue;
                                    d += d2;
                                    ++n32;
                                }
                            }
                        }
                        if (n32 > 0) {
                            matrixInterface2.setValue(i, j, d / (double)n32);
                            continue;
                        }
                        matrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        threader.execute(n3);
        return matrixInterface2;
    }

    public static MatrixInterface processImageMedianKernel(final MatrixInterface matrixInterface, final MatrixInterface matrixInterface2, final int n) {
        final int n2 = n / 2;
        final int n3 = n * n;
        final int n4 = matrixInterface.getN();
        final int n5 = matrixInterface.getK();
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n6, int n22) {
                double[] dArray = new double[n3];
                for (int i = n6; i < n22; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        int n32 = 0;
                        if (!matrixInterface.isMissing(i, j)) {
                            for (int k = 0; k < n; ++k) {
                                for (int i2 = 0; i2 < n; ++i2) {
                                    int n42 = j + k - n2;
                                    int n52 = i + i2 - n2;
                                    if (n42 < 0 || n42 >= n5 || n52 < 0 || n52 >= n4) continue;
                                    double d = matrixInterface.getValue(n52, n42);
                                    if (matrixInterface.isMissing(n52, n42)) continue;
                                    dArray[n32] = d;
                                    ++n32;
                                }
                            }
                        }
                        if (n32 > 0) {
                            Arrays.sort(dArray, 0, n32);
                            matrixInterface2.setValue(i, j, dArray[n32 / 2]);
                            continue;
                        }
                        matrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        threader.execute(n4);
        return matrixInterface2;
    }

    public static MatrixInterface processImageDerivateKernel(final MatrixInterface matrixInterface, final MatrixInterface matrixInterface2, final int n) {
        final int n2 = n / 2;
        final int n3 = matrixInterface.getN();
        final int n4 = matrixInterface.getK();
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n6, int n22) {
                for (int i = n6; i < n22; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        double d = 0.0;
                        int n32 = 0;
                        if (!matrixInterface.isMissing(i, j)) {
                            double d2 = matrixInterface.getValue(i, j);
                            for (int k = 0; k < n; ++k) {
                                for (int i2 = 0; i2 < n; ++i2) {
                                    int n42 = j + k - n2;
                                    int n5 = i + i2 - n2;
                                    if (n42 < 0 || n42 >= n4 || n5 < 0 || n5 >= n3) continue;
                                    double d3 = matrixInterface.getValue(n5, n42);
                                    if (matrixInterface.isMissing(n5, n42)) continue;
                                    d = Math.max(0.0, Math.max(d, d2 - d3));
                                    ++n32;
                                }
                            }
                        }
                        if (n32 > 0) {
                            matrixInterface2.setValue(i, j, d);
                            continue;
                        }
                        matrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        threader.execute(n3);
        return matrixInterface2;
    }

    public static MatrixInterface processThreshold(final MatrixInterface matrixInterface, final MatrixInterface matrixInterface2, final double d) {
        int n = matrixInterface.getN();
        final int n2 = matrixInterface.getK();
        Threader threader = new Threader(){

            @Override
            protected void doOp(boolean bl, int n, int n22) {
                for (int i = n; i < n22; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        double d2 = matrixInterface.getValue(i, j);
                        boolean bl2 = matrixInterface.isMissing(i, j);
                        if (!bl2 && d2 > d) {
                            matrixInterface2.setValue(i, j, 1.0);
                            continue;
                        }
                        matrixInterface2.setValue(i, j, 0.0);
                    }
                }
            }
        };
        threader.execute(n);
        return matrixInterface2;
    }
}

