/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.database;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.database.DatabaseTableModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class DatabaseImportPanel
extends AbstractImportPanel {
    private final JComboBox tableSelection = new JComboBox();
    private final JTextField what = new JTextField("*", 30);
    private final Connection connection;
    private final String connectionString;
    private final String user;
    private int rows = 0;
    private int columns = 0;
    private String query = null;

    public DatabaseImportPanel(Connection connection, String string, String string2) {
        super((File[])null);
        Object object;
        this.connection = connection;
        this.connectionString = string;
        this.user = string2;
        try {
            object = connection.getMetaData();
            ResultSet resultSet = object.getTables(null, null, null, null);
            while (resultSet.next()) {
                this.tableSelection.addItem(resultSet.getString("TABLE_NAME"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setBorder(EvinceBorderFactory.createEvinceBorder("Database Query"));
        this.add((Component)object, "Center");
        ((Container)object).add((Component)new JLabel("SELECT"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 8, 0));
        ((Container)object).add((Component)this.what, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 8, 0));
        ((Container)object).add((Component)new JLabel("FROM"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 8, 0));
        ((Container)object).add((Component)this.tableSelection, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 8, 0));
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public boolean canNext() {
        return this.tableSelection.getItemCount() > 0 && this.what.getText().length() > 0;
    }

    public int getColumns() {
        return this.columns;
    }

    @Override
    public String getFilename() {
        return this.tableSelection.getSelectedItem().toString();
    }

    public int getRows() {
        int n = 0;
        try {
            String string = this.what.getText().split(";")[0];
            this.query = "SELECT " + string + " FROM " + String.valueOf(this.tableSelection.getSelectedItem());
            PreparedStatement preparedStatement = this.connection.prepareStatement(this.query);
            this.columns = preparedStatement.getMetaData().getColumnCount();
            ResultSet resultSet = preparedStatement.executeQuery();
            n = 0;
            while (resultSet.next()) {
                ++n;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public String getType() {
        return "Database";
    }

    @Override
    public boolean hasSettings() {
        return true;
    }

    @Override
    public boolean nextPressed() {
        this.rows = this.getRows();
        return this.rows > 0;
    }

    @Override
    protected CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        return new DatabaseTableModel(this.connection, this.connectionString, this.user, this.query, this.rows, this.columns);
    }
}

