/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.database;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.main.IniManager;

public class DatabaseSelectionPanel
extends CleanUpPanel {
    private static String[] drivers = new String[]{"org.gjt.mm.mysql.Driver", "sun.jdbc.odbc.JdbcOdbcDriver"};
    private Connection connection = null;
    private final JComboBox typeSelection = new JComboBox();
    private final JComboBox dbUrl = new JComboBox();
    private final JTextField dbUser = new JTextField(20);
    private final JPasswordField dbPass = new JPasswordField(20);
    private final JTextArea status = new JTextArea("Waiting for input", 20, 5);
    private String connectionString;
    private final AbstractWizard wizard;

    public static void addDrivers() {
        for (String string : drivers) {
            DatabaseSelectionPanel.addDriver(string);
        }
    }

    private static void addDriver(String string) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public DatabaseSelectionPanel(AbstractWizard abstractWizard) {
        this((LayoutManager)new GridBagLayout(), abstractWizard);
    }

    public DatabaseSelectionPanel(LayoutManager layoutManager, AbstractWizard abstractWizard) {
        super(layoutManager);
        this.wizard = abstractWizard;
        DatabaseSelectionPanel.addDrivers();
        this.dbUrl.setEditable(true);
        Iterator<String> iterator = IniManager.getRecentDatabase().iterator();
        while (iterator.hasNext()) {
            this.dbUrl.addItem(iterator.next());
        }
        if (this.dbUrl.getItemCount() <= 0) {
            this.dbUrl.addItem("//localhost/database");
        }
        this.status.setLineWrap(true);
        this.status.setBackground(this.getBackground());
        this.typeSelection.addItem(new ComboItem("MySQL", "jdbc:mysql"));
        JButton jButton = new JButton("Try to connect");
        jButton.addActionListener(actionEvent -> {
            JButton jButton = (JButton)actionEvent.getSource();
            this.status.setForeground(Color.black);
            this.status.setText("Trying to connect...");
            this.connectionString = ((ComboItem)this.typeSelection.getSelectedItem()).object + ":" + String.valueOf(this.dbUrl.getSelectedItem());
            char[] cArray = this.dbPass.getPassword();
            String string = new String(cArray);
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
            jButton.setEnabled(false);
            try {
                this.connection = DriverManager.getConnection(this.connectionString, this.dbUser.getText(), string);
                this.status.setText("Connected");
                List<String> list = IniManager.getRecentDatabase();
                list.remove(this.dbUrl.getSelectedItem());
                list.add(0, this.dbUrl.getSelectedItem().toString());
                IniManager.SaveIni();
            }
            catch (SQLException sQLException) {
                this.status.setText(sQLException.getMessage());
                this.status.setForeground(Color.red);
            }
            this.wizard.updateButtons();
            jButton.setEnabled(true);
            string = null;
        });
        this.status.setBorder(EvinceBorderFactory.createEvinceBorder("Status"));
        this.add((Component)this.typeSelection, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 12, 0, 0), 8, 0));
        this.add((Component)this.dbUrl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 6, 0, 12), 8, 0));
        this.add((Component)new JLabel("Database user:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 8, 0));
        this.add((Component)this.dbUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 8, 0));
        this.add((Component)new JLabel("Password:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 8, 0));
        this.add((Component)this.dbPass, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 12), 8, 0));
        this.add((Component)jButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 12, 0, 0), 8, 0));
        this.add((Component)this.status, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 12, 12), 8, 0));
    }

    public boolean canNext() {
        return this.connection != null;
    }

    public Connection getDatabaseConnection() {
        return this.connection;
    }

    public String getDatabaseConnectionString() {
        return this.connectionString;
    }

    public String getDatabaseUser() {
        return this.dbUser.getText();
    }

    @Override
    protected void cleanUpChild() {
        this.connection = null;
    }

    private static class ComboItem {
        private final String text;
        public String object;

        public ComboItem(String string, String string2) {
            this.text = string;
            this.object = string2;
        }

        public String toString() {
            return this.text;
        }
    }
}

