/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.database;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.database.DatabaseSelectionPanel;
import se.prediktera.map.main.Main_GUI;

public class DatabaseTableModel
extends AbstractDataSource {
    private Connection connection = null;
    private String connectionString = null;
    private String user = null;
    private String query = null;
    private int currentStartRow = -1;
    private int maxResultSize = 1000;
    private ResultSet results = null;
    private ResultSetMetaData metaData = null;

    public DatabaseTableModel(Connection connection, String string, String string2, String string3, int n, int n2) {
        super((byte)0);
        this.rows = n;
        this.columns = n2;
        this.maxResultSize = 20000 / n2;
        this.connection = connection;
        this.connectionString = string;
        this.user = string2;
        this.query = string3;
    }

    public DatabaseTableModel(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        DatabaseSelectionPanel.addDrivers();
        this.user = mapProperty.getPropertyStringUTF("dbUser");
        this.connectionString = mapProperty.getPropertyStringUTF("dbConnect");
        this.query = mapProperty.getPropertyStringUTF("dbQuery");
    }

    @Override
    public void closeConnections() {
    }

    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getInformation() {
        return "";
    }

    @Override
    public String getName() {
        return "Database connection";
    }

    @Override
    public byte getTreeType() {
        return 2;
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        if (!this.checkConnection(null)) {
            return "No connection";
        }
        if (n == 0) {
            try {
                if (this.metaData != null) {
                    return this.metaData.getColumnName(n2 + 1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return null;
        }
        if (this.results == null || n < this.currentStartRow || n >= this.currentStartRow + this.maxResultSize) {
            try {
                String string = this.query + " LIMIT " + (n - 1) + "," + this.maxResultSize;
                System.out.println(string);
                this.results = this.connection.createStatement(0, 1007).executeQuery(string);
                this.results.next();
                this.currentStartRow = n;
            }
            catch (SQLException sQLException) {
                return null;
            }
        }
        try {
            this.results.absolute(n - this.currentStartRow + 1);
            return this.results.getString(n2 + 1);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public boolean isVisibleInTree() {
        return false;
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
        if (this.checkConnection(progressManager.getWindow())) {
            try {
                PreparedStatement preparedStatement = this.connection.prepareStatement(this.query);
                this.columns = preparedStatement.getMetaData().getColumnCount();
                this.maxResultSize = 20000 / this.columns;
                ResultSet resultSet = preparedStatement.executeQuery();
                this.rows = 0;
                while (resultSet.next()) {
                    ++this.rows;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("dbUser", this.user);
        randomOutputStream.writePropertyStringUTF("dbConnect", this.connectionString);
        randomOutputStream.writePropertyStringUTF("dbQuery", this.query);
    }

    @Override
    protected void ClearDataLocal() throws IOException {
        super.ClearDataLocal();
        this.results = null;
    }

    private boolean checkConnection(Window window) {
        Object object;
        if (this.connection == null) {
            this.rows = 0;
            this.columns = 0;
            if (window == null) {
                window = Main_GUI.get();
            }
            object = window instanceof JDialog ? new PasswordDialog((JDialog)window) : new PasswordDialog((JFrame)window);
            ((CleanUpDialog)object).setVisible(true);
            ((CleanUpDialog)object).cleanUp();
        }
        if (this.connection != null && this.metaData == null) {
            try {
                this.metaData = this.connection.prepareStatement(this.query).getMetaData();
                object = this.connection.prepareStatement(this.query);
                this.columns = object.getMetaData().getColumnCount();
                this.maxResultSize = 20000 / this.columns;
                ResultSet resultSet = object.executeQuery();
                this.rows = 0;
                while (resultSet.next()) {
                    ++this.rows;
                }
                return true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.metaData != null;
    }

    private class PasswordDialog
    extends CleanUpDialog {
        private final JPasswordField dbPass;

        public PasswordDialog(JDialog jDialog) {
            super(jDialog, "Database password required!", true);
            this.dbPass = new JPasswordField(20);
            this.init();
        }

        public PasswordDialog(JFrame jFrame) {
            super(jFrame, "Database password required!", true);
            this.dbPass = new JPasswordField(20);
            this.init();
        }

        @Override
        protected void cleanUpChild() {
        }

        private void init() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)new JLabel("Database:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 8, 0));
            this.getContentPane().add((Component)new JLabel(DatabaseTableModel.this.connectionString), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 8, 0));
            this.getContentPane().add((Component)new JLabel("User:"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 8, 0));
            this.getContentPane().add((Component)new JLabel(DatabaseTableModel.this.user), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 8, 0));
            this.getContentPane().add((Component)new JLabel("Password:"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 8, 0));
            this.getContentPane().add((Component)this.dbPass, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 8, 0));
            JButton jButton = new JButton("Connect");
            jButton.addActionListener(actionEvent -> {
                try {
                    this.dispose();
                    char[] cArray = this.dbPass.getPassword();
                    String string = new String(cArray);
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = '\u0000';
                    }
                    DatabaseTableModel.this.connection = DriverManager.getConnection(DatabaseTableModel.this.connectionString, DatabaseTableModel.this.user, string);
                    string = null;
                }
                catch (SQLException sQLException) {
                    return;
                }
            });
            this.getContentPane().add((Component)jButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 8, 0));
            JButton jButton2 = new JButton("Purge case");
            jButton2.setEnabled(false);
            this.getContentPane().add((Component)jButton2, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 8, 0));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
    }
}

