/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.identifier;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.JValidateNumberField;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.AbstractWizard;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.MissingValueDialog;
import se.prediktera.map.dataimport.VarianceDialog;
import se.prediktera.map.dataimport.identifier.ImageIdentifierPanel;
import se.prediktera.map.dataimport.identifier.InsertListener;
import se.prediktera.map.dataimport.identifier.PasteListener;
import se.prediktera.map.dataimport.identifier.ShiftListener;
import se.prediktera.map.dataimport.identifier.SpectralPanel;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;
import se.prediktera.map.simpletableeditor.DescriptionListener;
import se.prediktera.map.simpletableeditor.ExtendScrollTable;
import se.prediktera.map.simpletableeditor.ExtendTableModel;
import se.prediktera.map.simpletableeditor.TableActions;

public class CellIdentifierPanel
extends WizardPageClass
implements DataTypeInterface {
    private static final byte EVEN = 1;
    private CellIdentifierModel ciModel = null;
    private ExtendScrollTable extendTable;
    private ImageIdentifierPanel imageIdentifierPanel;
    private final JSplitPane imageSplitPane = new JSplitPane();
    private final JTabbedPane tableTabbPanel = new JTabbedPane(3);
    private final JCheckBox transpose = new JCheckBox("Transpose Data");
    private final ColorButton buttonObservation = new ColorButton(true, new IdType(1, 2));
    private final ColorButton buttonVariable = new ColorButton(true, new IdType(0, 1));
    private final ColorButton buttonPrimaryObs = new ColorButton(true, new IdType(1, 2), true);
    private final ColorButton buttonPrimaryVar = new ColorButton(true, new IdType(0, 1), true);
    private final ColorButton buttonClass = new ColorButton(true, new IdType(3, 3));
    private final ColorButton setExclude = new ColorButton(true, new IdType(2, 3));
    private final ColorButton setInclude = new ColorButton(true, new IdType(11, 3));
    private final ColorButton setExcludeLayer = new ColorButton(true, new IdType(2, 3));
    private final ColorButton setIncludeLayer = new ColorButton(true, new IdType(4, 3));
    private final JButton buttonSet = new JButton("Set");
    private final JComboBox boxDataType = new JComboBox();
    private final JValidateNumberField mvOtherNumberField = new JValidateNumberField(true);
    private final JLabel labelNrObsText = new JLabel("Observations:");
    private final JLabel labelNrObs = new JLabel("N/A");
    private final JLabel labelNrVarText = new JLabel("Variables:");
    private final JLabel labelNrVar = new JLabel("N/A");
    private final JLabel labelNrLayersText = new JLabel("Channels:");
    private final JLabel labelNrLayers = new JLabel("N/A");
    private final JScrollPane scrollPane = new JScrollPane();
    private final JTabbedPane tabbPanel = new JTabbedPane();
    private final JTabbedPane tabbLayer = new JTabbedPane();
    private final JLabel labelDataSize = new JLabel("N/A");
    private final JPanel settingsPanel = new JPanel();
    private TableActions tableActions = null;
    private boolean created = false;
    private Boolean multiLayer = null;
    private boolean iseditable = true;
    private final MyDescriptionListener descriptionListener = new MyDescriptionListener();

    public CellIdentifierPanel(AbstractWizard abstractWizard, boolean bl, boolean bl2, boolean bl3) {
        super((LayoutManager)new BorderLayout(), abstractWizard);
        this.iseditable = bl3;
        this.jbInit();
        this.setLayoutFromLayers(bl, bl2);
    }

    @Override
    public boolean canFinish() {
        return this.ciModel != null && super.canFinish();
    }

    @Override
    public boolean canNext() {
        return this.ciModel != null && super.canNext();
    }

    public void clear(boolean bl) {
        this.ciModel.clear(false);
        this.mvOtherNumberField.setText("");
        if (bl) {
            this.ciModel.autoIdentifyData(null, Integer.MAX_VALUE);
        }
        this.updateTable(false);
    }

    @Override
    public boolean finishedPressed() {
        if (this.imageIdentifierPanel != null) {
            this.imageIdentifierPanel.interruptThreadSpectra();
        }
        return this.nextPressed();
    }

    public CellIdentifier getCellIdentifier() {
        return this.ciModel;
    }

    public CellIdentifierModel getCiModel() {
        return this.ciModel;
    }

    public ExtendScrollTable getExtendTable() {
        return this.extendTable;
    }

    public ExtendTableModel getTableModel() {
        return this.ciModel;
    }

    public boolean hasMultilayer() {
        return this.multiLayer != null && this.multiLayer != false;
    }

    @Override
    public boolean nextPressed() {
        int n;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = this.getDataSize();
        if (l2 * (long)this.ciModel.getDataTypeSize() > l) {
            JOptionPane.showConfirmDialog(this, "The imported data size will exceed the total memory available in Evince.\nTry to exclude data or reduce the dimensions of the data.\nFor information on how to run Evince in 64-bit mode, please see Help Appendix III", "Warning", -1, 2);
        } else if (l2 * (long)this.ciModel.getDataTypeSize() + l2 * (long)TYPE_SIZE[4] > l && (n = JOptionPane.showConfirmDialog(this, "The estimated data usage will exceed the total memory available in Evince.\nIt is recommended to try to exclude data or reduce the dimensions of the data.\nFor information on how to run Evince in 64-bit mode, please see Help Appendix III\n\nDo you want to continue?", "Information", 0, 1)) != 0) {
            return false;
        }
        if (this.imageIdentifierPanel != null) {
            this.imageIdentifierPanel.interruptThreadSpectra();
        }
        this.setMissing();
        return super.nextPressed();
    }

    @Override
    public void pageShown() {
        if (this.ciModel != null) {
            if (this.multiLayer != null) {
                this.tableTabbPanel.setSelectedIndex(this.multiLayer != false ? 1 : 0);
            }
            this.updateTable(false);
        }
    }

    public void setLayerIncluded(boolean bl) {
        this.setLayerWithType(new IdType(bl ? (byte)4 : 2, 3));
    }

    public void setLayoutFromLayers(boolean bl, boolean bl2) {
        if (this.multiLayer != null && this.multiLayer == bl) {
            return;
        }
        this.multiLayer = bl;
        this.settingsPanel.remove(this.tabbLayer);
        this.tabbPanel.removeAll();
        this.tabbLayer.removeAll();
        if (bl) {
            this.tableTabbPanel.setSelectedIndex(1);
            this.tabbPanel.addTab("Pixels", this.createFirstPanel(bl, bl2));
            this.tabbPanel.addTab("Data", this.createResolutionPanel());
            this.tabbPanel.addTab("Tools", this.createSecondPanel(bl));
            this.tabbLayer.addTab("Channels", this.createLayerPanel());
            if (this.iseditable) {
                this.settingsPanel.add((Component)this.tabbLayer, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.4, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            SpectralPanel spectralPanel = this.imageIdentifierPanel.getSpectralPanel();
            spectralPanel.setPreferredSize(new Dimension(0, 200));
            spectralPanel.setMinimumSize(new Dimension(0, 200));
            this.imageSplitPane.setDividerSize(5);
            this.imageSplitPane.setDividerLocation(this.imageSplitPane.getHeight() - 200);
            this.imageSplitPane.setRightComponent(spectralPanel);
            this.imageSplitPane.setOneTouchExpandable(true);
            this.labelNrVarText.setText("Columns:");
            this.labelNrObsText.setText("Rows:");
        } else {
            this.tableTabbPanel.setSelectedIndex(0);
            this.tabbPanel.addTab("Identifiers", this.createFirstPanel(bl, bl2));
            this.tabbPanel.addTab("Tools", this.createSecondPanel(bl));
            JPanel jPanel = new JPanel();
            jPanel.setMaximumSize(new Dimension(0, 0));
            this.imageSplitPane.setDividerSize(0);
            this.imageSplitPane.setDividerLocation(Integer.MAX_VALUE);
            this.imageSplitPane.setRightComponent(jPanel);
            this.labelNrVarText.setText("Variables:");
            this.labelNrObsText.setText("Observations:");
        }
        this.settingsPanel.invalidate();
        this.settingsPanel.doLayout();
        this.labelNrLayers.setVisible(bl);
        this.labelNrLayersText.setVisible(bl);
    }

    public void setRowColIncluded(boolean bl) {
        this.setRowColWithType(new IdType(bl ? (byte)11 : 2, 3));
    }

    public void setTableModel(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, boolean bl) {
        this.ciModel = cellIdentifierModel;
        cellIdentifierModel.init(progressManager);
        this.updateTable(false);
        this.transpose.setSelected(false);
        this.setLayoutFromLayers(cellIdentifierModel.isMultiLayer(), cellIdentifierModel.isMultiImport());
        this.extendTable.setModel(cellIdentifierModel);
        int n = this.extendTable.getRowHeight();
        this.extendTable.setRowHeight(10);
        this.extendTable.setRowHeight(n);
        this.tableActions = new TableActions(this.extendTable, true, true);
        this.transpose.setSelected(cellIdentifierModel.getTranspose());
        this.transpose.setEnabled(!cellIdentifierModel.isMultiLayer());
        if (cellIdentifierModel.isMissing(1)) {
            this.mvOtherNumberField.setNumber(cellIdentifierModel.getOther());
        } else {
            this.mvOtherNumberField.setText("");
        }
        if (this.iseditable && bl && !cellIdentifierModel.isValid()) {
            cellIdentifierModel.autoIdentifyData(progressManager, 100000);
            this.updateTable(false);
        }
        if (this.multiLayer.booleanValue()) {
            this.imageIdentifierPanel.setTableModel(progressManager);
            SwingUtilities.invokeLater(() -> this.imageIdentifierPanel.setCreated());
        }
        this.updateTable(true);
        this.created = true;
    }

    public void spectralSelectionChanged(boolean bl) {
        this.setExcludeLayer.setEnabled(bl);
        this.setIncludeLayer.setEnabled(bl);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.extendTable != null) {
            if (this.ciModel instanceof AbstractDataSource) {
                this.extendTable.setModel(new DefaultTableModel());
            }
            this.extendTable.cleanUp();
            this.extendTable = null;
        }
        this.ciModel = null;
    }

    protected void updateTable(boolean bl) {
        this.extendTable.setSelectState(-1);
        this.extendTable.clearSelections();
        if (bl) {
            for (int i = 0; i < this.extendTable.getColumnCount(); ++i) {
                this.extendTable.getColumnModel().getColumn(i).setPreferredWidth(50);
            }
        }
        this.labelNrObs.setText(this.getSizeInfo(0));
        this.labelNrVar.setText(this.getSizeInfo(1));
        this.labelNrLayers.setText(this.getSizeInfo(2));
        long l = this.getDataSize();
        this.labelDataSize.setText(IniManager.getFineSize(l * (long)this.ciModel.getDataTypeSize() + l * (long)TYPE_SIZE[4]));
        this.extendTable.updateTable();
        this.extendTable.updateColumnRenderer();
        if (bl) {
            this.imageIdentifierPanel.contentPaint();
        } else {
            this.imageIdentifierPanel.repaint();
        }
    }

    private void addResolutionSettings(JPanel jPanel, int n, String string) {
        JTextFieldButtonUppDown jTextFieldButtonUppDown = new JTextFieldButtonUppDown(1.0, 100.0, false);
        jTextFieldButtonUppDown.setNumberChangedInterface((n2, d) -> {
            this.ciModel.setResolution(n, (int)d);
            this.updateTable(false);
            this.imageIdentifierPanel.contentPaint();
        });
        jPanel.add((Component)new JLabel(string), new GridBagConstraints(0, n + 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 12, 2, 2), 0, 0));
        jPanel.add((Component)jTextFieldButtonUppDown, new GridBagConstraints(1, n + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 6), 0, 0));
    }

    private JPopupMenu columnHeaderPopup(Point point) {
        JTableHeader jTableHeader = this.extendTable.getTableHeader();
        int n = jTableHeader.columnAtPoint(point);
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.extendTable.getSelectedColumnCount() <= 1) {
            this.extendTable.setColumnSelectionInterval(n, n);
            this.extendTable.setSelectState(1);
            AbstractAction abstractAction = new AbstractAction("Primary Observation Id"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = (Integer)this.getValue("col");
                    CellIdentifierPanel.this.ciModel.setPrimaryCol(n);
                    CellIdentifierPanel.this.setRowColWithType(new IdType(1, 2));
                }
            };
            abstractAction.putValue("col", n);
            jPopupMenu.add(abstractAction);
        }
        jPopupMenu.add(new AbstractAction("Observation Id"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(1, 2));
            }
        });
        jPopupMenu.add(new AbstractAction("Category"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(3, 2));
            }
        });
        jPopupMenu.add(new AbstractAction("X Data"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(4, 2));
            }
        });
        jPopupMenu.add(new AbstractAction("Y Data"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(10, 2));
            }
        });
        jPopupMenu.add(new AbstractAction("SMILES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(5, 2));
            }
        });
        jPopupMenu.add(new AbstractAction("Image"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(14, 2));
            }
        });
        jPopupMenu.add(new AbstractAction("Link"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(15, 2));
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(new AbstractAction("Include"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(11, 2));
            }
        });
        jPopupMenu.add(new AbstractAction("Exclude"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(2, 2));
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ShiftListener(this, "Shift up", 2, -1, n));
        jPopupMenu.add(new ShiftListener(this, "Shift down", 3, -1, n));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new PasteListener(this, "Paste column(s)", 1, -1, n));
        jPopupMenu.add(new InsertListener(this, "column(s)", 1, -1, n));
        jPopupMenu.add(new ShiftListener(this, "Delete column(s)", 5, -1, n, this.extendTable.getSelectedColumns()));
        return jPopupMenu;
    }

    private JPanel createFirstPanel(boolean bl, boolean bl2) {
        JPanel jPanel;
        ButtonListener buttonListener = new ButtonListener();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        int n = 0;
        if (!bl) {
            jPanel = new JPanel(new GridLayout(5, 1, 5, 5));
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Identifier"));
            this.buttonObservation.setText("Secondary Obs");
            this.buttonObservation.addActionListener(buttonListener);
            this.buttonVariable.setText("Secondary Var");
            this.buttonVariable.addActionListener(buttonListener);
            this.buttonClass.setText("Category");
            this.buttonClass.addActionListener(buttonListener);
            jPanel.add((Component)this.buttonPrimaryVar, null);
            jPanel.add((Component)this.buttonVariable, null);
            jPanel.add((Component)this.buttonPrimaryObs, null);
            jPanel.add((Component)this.buttonObservation, null);
            jPanel.add((Component)this.buttonClass, null);
            this.buttonPrimaryVar.setText("Primary Var");
            this.buttonPrimaryVar.addActionListener(actionEvent -> this.setPrimary(actionEvent));
            this.buttonPrimaryObs.setText("Primary Obs");
            this.buttonPrimaryObs.addActionListener(actionEvent -> this.setPrimary(actionEvent));
            jPanel2.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (!bl) {
            jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
            jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Datatype"));
            jPanel.add((Component)this.boxDataType, null);
            this.buttonSet.setEnabled(false);
            jPanel.add((Component)this.buttonSet, null);
            this.buttonSet.addActionListener(actionEvent -> this.setRowColWithType((IdType)this.boxDataType.getSelectedItem()));
            this.boxDataType.addItem(new IdType(4, 3, "X Data"));
            this.boxDataType.addItem(new IdType(10, 2, "Y Data"));
            this.boxDataType.addItem(new IdType(5, 2, "SMILES"));
            this.boxDataType.addItem(new IdType(14, 2, "Image"));
            this.boxDataType.addItem(new IdType(16, 2, "Descriptor"));
            this.boxDataType.addItem(new IdType(15, 2, "Link"));
            this.boxDataType.setRenderer(new DataTypeListCellRenderer());
            jPanel2.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Inclusion"));
        this.setExclude.setText("Exclude");
        this.setExclude.addActionListener(buttonListener);
        this.setInclude.setText("Include");
        this.setInclude.addActionListener(buttonListener);
        jPanel.add((Component)this.setInclude, null);
        jPanel.add((Component)this.setExclude, null);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(EvinceBorderFactory.createEvinceBorder("Color legend"));
        DataTypeListCellRenderer dataTypeListCellRenderer = new DataTypeListCellRenderer(new IdType(-2, -1, "Missing Value"));
        jPanel3.add((Component)dataTypeListCellRenderer, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(6, 0, 6, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (bl) {
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Selection"));
            jPanel2.add((Component)jPanel4, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.imageIdentifierPanel.setSelectionMode((byte)0);
            ButtonGroup buttonGroup = new ButtonGroup();
            JToggleButton jToggleButton = new JToggleButton();
            jToggleButton.setMargin(new Insets(0, 0, 0, 0));
            jToggleButton.setPreferredSize(new Dimension(22, 22));
            jToggleButton.setMinimumSize(new Dimension(22, 22));
            jToggleButton.setMaximumSize(new Dimension(22, 22));
            jToggleButton.setToolTipText("Rectangle Selection");
            jToggleButton.setSelected(true);
            jToggleButton.setIcon(new ImageIcon(Main_GUI.class.getResource("button/selrec.gif")));
            jToggleButton.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.imageIdentifierPanel.setSelectionMode((byte)0);
                }
            });
            jPanel4.add((Component)jToggleButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            jPanel4.add((Component)new JLabel("Area"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            buttonGroup.add(jToggleButton);
            JToggleButton jToggleButton2 = new JToggleButton();
            jToggleButton2.setMargin(new Insets(0, 0, 0, 0));
            jToggleButton2.setPreferredSize(new Dimension(22, 22));
            jToggleButton2.setMinimumSize(new Dimension(22, 22));
            jToggleButton2.setMaximumSize(new Dimension(22, 22));
            jToggleButton2.setToolTipText("Horizontal or Vertical Selection");
            jToggleButton2.setIcon(new ImageIcon(Main_GUI.class.getResource("button/selhorizontal.gif")));
            jToggleButton2.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.imageIdentifierPanel.setSelectionMode((byte)1);
                }
            });
            jPanel4.add((Component)jToggleButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            jPanel4.add((Component)new JLabel("Hor/Vert"), new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            buttonGroup.add(jToggleButton2);
            if (bl2) {
                jToggleButton2.setSelected(true);
            }
            JPanel jPanel5 = new JPanel(new GridBagLayout());
            jPanel5.setBorder(EvinceBorderFactory.createEvinceBorder("Zoom"));
            jPanel2.add((Component)jPanel5, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            JToggleButton jToggleButton3 = new JToggleButton();
            jToggleButton3.setMargin(new Insets(0, 0, 0, 0));
            jToggleButton3.setPreferredSize(new Dimension(22, 22));
            jToggleButton3.setMinimumSize(new Dimension(22, 22));
            jToggleButton3.setMaximumSize(new Dimension(22, 22));
            jToggleButton3.setToolTipText("Zoom Rectangle");
            jToggleButton3.setSelected(true);
            jToggleButton3.setIcon(new ImageIcon(Main_GUI.class.getResource("button/zoomarea.png")));
            jToggleButton3.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.imageIdentifierPanel.setSelectionMode((byte)2);
                }
            });
            buttonGroup.add(jToggleButton3);
            jPanel5.add((Component)jToggleButton3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            jPanel5.add((Component)new JLabel("Zoom"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            JToggleButton jToggleButton4 = new JToggleButton();
            jToggleButton4.setMargin(new Insets(0, 0, 0, 0));
            jToggleButton4.setPreferredSize(new Dimension(22, 22));
            jToggleButton4.setMinimumSize(new Dimension(22, 22));
            jToggleButton4.setMaximumSize(new Dimension(22, 22));
            jToggleButton4.setToolTipText("Pan View");
            jToggleButton4.setSelected(true);
            jToggleButton4.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/pan_view.png")));
            jToggleButton4.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.imageIdentifierPanel.setSelectionMode((byte)3);
                }
            });
            buttonGroup.add(jToggleButton4);
            jPanel5.add((Component)jToggleButton4, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            jPanel5.add((Component)new JLabel("Pan"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            JButton jButton = new JButton();
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setPreferredSize(new Dimension(22, 22));
            jButton.setMinimumSize(new Dimension(22, 22));
            jButton.setMaximumSize(new Dimension(22, 22));
            jButton.setToolTipText("Rectangle Selection");
            jButton.setSelected(true);
            jButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/zoom.png")));
            jButton.addActionListener(actionEvent -> this.imageIdentifierPanel.zoomAll());
            jPanel5.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
            jPanel5.add((Component)new JLabel("Reset zoom"), new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        jPanel2.add((Component)new JLabel(""), new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel2;
    }

    private JComponent createLayerPanel() {
        LayerButtonListener layerButtonListener = new LayerButtonListener();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Inclusion"));
        this.setExcludeLayer.setText("Exclude");
        this.setExcludeLayer.addActionListener(layerButtonListener);
        this.setIncludeLayer.setText("Include");
        this.setIncludeLayer.addActionListener(layerButtonListener);
        jPanel2.add((Component)this.setIncludeLayer, null);
        jPanel2.add((Component)this.setExcludeLayer, null);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createResolutionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Memory"));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JLabel("Estimated usage:"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.labelDataSize, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 12, 2, 2), 0, 0));
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        jPanel2.add((Component)new JLabel("(" + IniManager.getFineSize(l) + ")"), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(EvinceBorderFactory.createEvinceBorder("Resolution"));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel("Reduce image dimensions"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 6, 2), 0, 0));
        this.addResolutionSettings(jPanel3, 0, "Rows");
        this.addResolutionSettings(jPanel3, 1, "Columns");
        this.addResolutionSettings(jPanel3, 2, "Channels");
        return jPanel;
    }

    private JPanel createSecondPanel(boolean bl) {
        JButton jButton;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(EvinceBorderFactory.createEvinceBorder("Identification"));
        if (!bl) {
            jButton = new JButton("Auto Identify");
            jButton.setMnemonic('D');
            jButton.addActionListener(actionEvent -> this.clear(true));
            jPanel2.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 4, 0), 0, 0));
        }
        jButton = new JButton("Clear");
        jButton.addActionListener(actionEvent -> this.clear(false));
        jPanel2.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, null);
        if (!bl) {
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)new JLabel("Denoted by: "), "West");
            jPanel3.add((Component)this.mvOtherNumberField, "Center");
            this.mvOtherNumberField.setCanBeEmpty();
            this.mvOtherNumberField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        CellIdentifierPanel.this.missingStateChanged();
                    }
                }
            });
            this.mvOtherNumberField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    CellIdentifierPanel.this.missingStateChanged();
                }
            });
            JPanel jPanel4 = new JPanel(new GridLayout(1, 1, 0, 0));
            jPanel4.setBorder(EvinceBorderFactory.createEvinceBorder("Missing values"));
            JPanel jPanel5 = new JPanel(new GridLayout(2, 1, 5, 5));
            jPanel5.setBorder(EvinceBorderFactory.createEvinceBorder("Auto-exclude"));
            JButton jButton2 = new JButton("Observations");
            jButton2.addActionListener(actionEvent -> {
                MissingValueDialog missingValueDialog = new MissingValueDialog(null, true);
                missingValueDialog.showModal("Observations", 0, this.ciModel);
                missingValueDialog.cleanUp();
                this.extendTable.repaint();
                this.updateTable(false);
            });
            JButton jButton3 = new JButton("Variables");
            jButton3.addActionListener(actionEvent -> {
                MissingValueDialog missingValueDialog = new MissingValueDialog(null, true);
                missingValueDialog.showModal("Variables", 1, this.ciModel);
                missingValueDialog.cleanUp();
                this.extendTable.repaint();
                this.updateTable(false);
            });
            jPanel5.add(jButton2);
            jPanel5.add(jButton3);
            JPanel jPanel6 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 11;
            jPanel6.add((Component)jPanel3, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 11;
            jPanel6.add((Component)jPanel5, gridBagConstraints2);
            jPanel4.add(jPanel6);
            jPanel4.setMaximumSize(new Dimension(1000, this.mvOtherNumberField.getHeight() + jButton3.getHeight() * 2 + 20));
            JPanel jPanel7 = new JPanel(new GridLayout(2, 1, 5, 5));
            jPanel7.setBorder(EvinceBorderFactory.createEvinceBorder("Variance Auto-exclude"));
            JButton jButton4 = new JButton("Observations");
            jButton4.addActionListener(actionEvent -> {
                VarianceDialog varianceDialog = new VarianceDialog();
                varianceDialog.showModal("Observations", 0, this.ciModel);
                varianceDialog.cleanUp();
                this.extendTable.repaint();
            });
            JButton jButton5 = new JButton("Variables");
            jButton5.addActionListener(actionEvent -> {
                VarianceDialog varianceDialog = new VarianceDialog();
                varianceDialog.showModal("Variables", 1, this.ciModel);
                varianceDialog.cleanUp();
                this.extendTable.repaint();
            });
            jPanel7.add(jButton4);
            jPanel7.add(jButton5);
            jPanel7.setMaximumSize(new Dimension(1000, jButton4.getHeight() * 2 + 10));
            jPanel2.setMaximumSize(jPanel7.getMaximumSize());
            jPanel.add((Component)jPanel4, null);
            jPanel.add((Component)jPanel7, null);
        } else {
            JPanel jPanel8 = new JPanel(new GridBagLayout());
            jPanel8.setBorder(EvinceBorderFactory.createEvinceBorder("Change contrast"));
            JTextFieldButtonUppDown jTextFieldButtonUppDown = this.imageIdentifierPanel.getContrastNumberField();
            jTextFieldButtonUppDown.setNumber(100.0);
            jTextFieldButtonUppDown.setNumberChangedInterface((n, d) -> this.imageIdentifierPanel.setMaxRatio(d));
            jPanel8.add((Component)new JLabel("Max intensity (0-100)%"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
            jPanel8.add((Component)jTextFieldButtonUppDown, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
            jPanel.add((Component)jPanel8, null);
        }
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private long getDataSize() {
        long l = 1L;
        int[][] nArray = this.ciModel.getMatrixInfo();
        for (int i = 0; i < 3; ++i) {
            l *= (long)nArray[i][0] / (long)this.ciModel.getResolution(i);
        }
        return l;
    }

    private String getSizeInfo(int n) {
        int n2 = this.ciModel.getResolution(n);
        int[][] nArray = this.ciModel.getMatrixInfo();
        return nArray[n][0] / n2 + (String)(nArray[n][1] / n2 > 0 ? " (" + nArray[n][1] / n2 + " excluded)" : "");
    }

    private void jbInit() {
        this.labelNrLayersText.setVisible(false);
        this.labelNrLayers.setVisible(false);
        this.extendTable = new ExtendScrollTable(null, this.scrollPane, false, false, true, true){

            @Override
            public boolean addToPopup(Project_GUI project_GUI, DataTreeInterface dataTreeInterface, Point point, JPopupMenu jPopupMenu, boolean bl) {
                return false;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnAtPoint(point);
                int n2 = this.rowAtPoint(point);
                if (CellIdentifierPanel.this.ciModel != null && n > -1 && n2 > -1) {
                    return CellIdentifierPanel.this.ciModel.getTypeDescription(n2, n, this.getValueAt(n2, n));
                }
                return null;
            }
        };
        this.extendTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            private void showPopupMenu(MouseEvent mouseEvent) {
                if (CellIdentifierPanel.this.iseditable && mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    int n = CellIdentifierPanel.this.extendTable.getSelectedColumnCount();
                    if (n == 0 || n == CellIdentifierPanel.this.extendTable.getColumnCount()) {
                        try {
                            int n2 = CellIdentifierPanel.this.extendTable.columnAtPoint(mouseEvent.getPoint());
                            CellIdentifierPanel.this.extendTable.setRowSelectionInterval(0, CellIdentifierPanel.this.extendTable.getRowCount() - 1);
                            CellIdentifierPanel.this.extendTable.setColumnSelectionInterval(n2, n2);
                        }
                        catch (Exception exception) {
                            ErrorHandler.logAndReportException(exception);
                        }
                    }
                    JPopupMenu jPopupMenu = CellIdentifierPanel.this.columnHeaderPopup(mouseEvent.getPoint());
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.extendTable.getRowHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            private void showPopupMenu(MouseEvent mouseEvent) {
                if (CellIdentifierPanel.this.iseditable && mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    int n = CellIdentifierPanel.this.extendTable.getSelectedRowCount();
                    if (n == 0 || n == CellIdentifierPanel.this.extendTable.getRowCount()) {
                        int n2 = CellIdentifierPanel.this.extendTable.rowAtPoint(mouseEvent.getPoint());
                        CellIdentifierPanel.this.extendTable.setColumnSelectionInterval(0, CellIdentifierPanel.this.extendTable.getColumnCount() - 1);
                        CellIdentifierPanel.this.extendTable.setRowSelectionInterval(n2, n2);
                    }
                    JPopupMenu jPopupMenu = CellIdentifierPanel.this.rowHeaderPopup(mouseEvent.getPoint());
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.extendTable.setDefaultRenderer(String.class, new CustomTableCellRenderer());
        this.extendTable.setAutoResizeMode(0);
        this.extendTable.addDescriptionListener(this.descriptionListener);
        this.extendTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            private void showPopupMenu(MouseEvent mouseEvent) {
                if (CellIdentifierPanel.this.iseditable && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    Point point = mouseEvent.getPoint();
                    if (CellIdentifierPanel.this.tableActions != null) {
                        CellIdentifierPanel.this.tableActions.addToPopupMenu(jPopupMenu, false);
                        jPopupMenu.addSeparator();
                    }
                    CMenu cMenu = new CMenu("Select", false);
                    CMenuItem cMenuItem = new CMenuItem((Object)"Evenly spread");
                    cMenuItem.addActionListener(actionEvent -> CellIdentifierPanel.this.selectFilesFromMenu((byte)1));
                    cMenu.add(cMenuItem);
                    jPopupMenu.add(cMenu);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new ShiftListener(CellIdentifierPanel.this, "Shift left", 0, point));
                    jPopupMenu.add(new ShiftListener(CellIdentifierPanel.this, "Shift right", 1, point));
                    jPopupMenu.add(new ShiftListener(CellIdentifierPanel.this, "Shift up", 2, point));
                    jPopupMenu.add(new ShiftListener(CellIdentifierPanel.this, "Shift down", 3, point));
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new ShiftListener(CellIdentifierPanel.this, "Delete", 4, point));
                    jPopupMenu.show(CellIdentifierPanel.this.extendTable, point.x, point.y);
                }
            }
        });
        this.extendTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (this.imageIdentifierPanel != null) {
                this.imageIdentifierPanel.setSpectralData(this.extendTable, -1, -1);
            }
        });
        this.extendTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (this.imageIdentifierPanel != null) {
                this.imageIdentifierPanel.setSpectralData(this.extendTable, -1, -1);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.extendTable);
        this.imageIdentifierPanel = new ImageIdentifierPanel(this, this.iseditable);
        ToolTipManager.sharedInstance().registerComponent(this.imageIdentifierPanel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Data summary"));
        this.transpose.addItemListener(itemEvent -> this.transposeStateChanged(itemEvent));
        jPanel.add((Component)this.labelNrObsText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        jPanel.add((Component)this.labelNrObs, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 2), 0, 0));
        jPanel.add((Component)this.labelNrVarText, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        jPanel.add((Component)this.labelNrVar, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 2), 0, 0));
        jPanel.add((Component)this.labelNrLayersText, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        jPanel.add((Component)this.labelNrLayers, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 2), 0, 0));
        jPanel.add((Component)this.transpose, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.tabbPanel.setPreferredSize(new Dimension(160, 10));
        this.settingsPanel.setLayout(new GridBagLayout());
        this.settingsPanel.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.iseditable) {
            this.settingsPanel.add((Component)this.tabbPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.settingsPanel.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.settingsPanel, "West");
        this.tableTabbPanel.addTab("Values", this.scrollPane);
        this.tableTabbPanel.addTab("Image", this.imageSplitPane);
        this.tableTabbPanel.addChangeListener(changeEvent -> {
            if (this.created && this.tableTabbPanel.getSelectedIndex() == 1 && this.imageIdentifierPanel.getModel() == null) {
                ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(){

                    @Override
                    public Object doWork() {
                        this.setInfoText("Rendering image");
                        CellIdentifierPanel.this.imageIdentifierPanel.setTableModel(this);
                        CellIdentifierPanel.this.imageIdentifierPanel.setCreated();
                        return null;
                    }
                };
                progressManagerImpl.setDeciSeconds(1);
                SwingUtilities.invokeLater(progressManagerImpl);
            }
        });
        this.imageSplitPane.setOrientation(0);
        this.imageSplitPane.setResizeWeight(1.0);
        this.imageSplitPane.setLeftComponent(this.imageIdentifierPanel);
        this.imageSplitPane.setDividerSize(0);
        this.imageSplitPane.setDividerLocation(Integer.MAX_VALUE);
        this.add((Component)this.tableTabbPanel, "Center");
    }

    private void missingStateChanged() {
        this.setMissing();
        this.updateTable(false);
    }

    private int[] prepareSelected(int[] nArray, int n, boolean bl) {
        if (bl) {
            int[] nArray2 = new int[n - nArray.length];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                boolean bl2 = false;
                for (int n3 : nArray) {
                    if (n3 != i) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                nArray2[n2++] = i;
            }
            return nArray2;
        }
        return nArray;
    }

    private JPopupMenu rowHeaderPopup(Point point) {
        JList jList = this.extendTable.getRowHeader();
        int n = jList.locationToIndex(point);
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.extendTable.getSelectedRowCount() <= 1) {
            this.extendTable.setRowSelectionInterval(n, n);
            this.extendTable.setSelectState(0);
            AbstractAction abstractAction = new AbstractAction("Primary Variable Id"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = (Integer)this.getValue("row");
                    CellIdentifierPanel.this.ciModel.setPrimaryRow(n);
                    CellIdentifierPanel.this.setRowColWithType(new IdType(0, 1));
                }
            };
            abstractAction.putValue("row", n);
            jPopupMenu.add(abstractAction);
        }
        jPopupMenu.add(new AbstractAction("Variable Id"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(0, 1));
            }
        });
        jPopupMenu.add(new AbstractAction("Category"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(3, 1));
            }
        });
        jPopupMenu.add(new AbstractAction("Numerical Data"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(4, 1));
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(new AbstractAction("Include"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(11, 1));
            }
        });
        jPopupMenu.add(new AbstractAction("Exclude"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellIdentifierPanel.this.setRowColWithType(new IdType(2, 1));
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ShiftListener(this, "Shift left", 0, n, -1));
        jPopupMenu.add(new ShiftListener(this, "Shift right", 1, n, -1));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new PasteListener(this, "Paste row(s)", 3, n, -1));
        jPopupMenu.add(new InsertListener(this, "row(s)", 3, n, -1));
        jPopupMenu.add(new ShiftListener(this, "Delete row(s)", 6, n, -1, this.extendTable.getSelectedRows()));
        return jPopupMenu;
    }

    private void selectFilesFromMenu(byte by) {
        String string = JOptionPane.showInputDialog(this, (Object)"Enter intervall between selection");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                int n2 = this.extendTable.getRowCount();
                n = Math.min(n, n2);
                this.extendTable.clearSelection();
                if (by == 1) {
                    this.extendTable.addColumnSelectionInterval(0, this.extendTable.getColumnCount() - 1);
                    for (int i = 0; i < n2; i += n) {
                        this.extendTable.addRowSelectionInterval(i, i);
                    }
                } else {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
                    for (int i = 0; i < n2; ++i) {
                        arrayList.add(i);
                    }
                    Random random = new Random();
                    for (int i = 0; i < n; ++i) {
                        int n3 = random.nextInt(arrayList.size());
                        this.extendTable.addRowSelectionInterval(n3, n3);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showConfirmDialog(this, "Not a valid number", "Invalid input", -1, 2);
            }
        }
    }

    private void setLayerWithType(IdType idType) {
        boolean[] blArray = this.imageIdentifierPanel.getSelectedLayer();
        if (blArray != null) {
            byte by = idType.getType();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                this.ciModel.addInterval(2, i, by);
            }
        }
        int[][] nArray = this.ciModel.getMatrixInfo();
        this.labelNrLayers.setText(nArray[2][0] + (String)(nArray[2][1] > 0 ? " (" + nArray[2][1] + " excluded)" : ""));
        this.imageIdentifierPanel.getSpectralPanel().clearSelection();
        this.spectralSelectionChanged(false);
        this.updateTable(false);
    }

    private void setMissing() {
        this.ciModel.setMissing(1, this.mvOtherNumberField.getText().length() > 0, this.mvOtherNumberField.getNumber());
    }

    private void setPrimary(ActionEvent actionEvent) {
        ColorButton colorButton = (ColorButton)actionEvent.getSource();
        IdType idType = colorButton.getIdType();
        if (this.extendTable.getSelectState() == 0 && (idType.getTag() & 1) == 1) {
            this.ciModel.setPrimaryRow(this.extendTable.getSelectedRow());
        } else if (this.extendTable.getSelectState() == 1 && (idType.getTag() & 2) == 2) {
            this.ciModel.setPrimaryCol(this.extendTable.getSelectedColumn());
        }
        this.setRowColWithType(idType);
    }

    private void setRowColWithType(IdType idType) {
        this.setRowColWithType(idType, false, true);
    }

    private void setRowColWithType(IdType idType, boolean bl, boolean bl2) {
        int[] nArray = null;
        if (this.extendTable.getSelectState() == 0 && (idType.getTag() & 1) == 1) {
            nArray = this.prepareSelected(this.extendTable.getSelectedRows(), this.extendTable.getRowCount(), bl);
        } else if (this.extendTable.getSelectState() == 1 && (idType.getTag() & 2) == 2) {
            nArray = this.prepareSelected(this.extendTable.getSelectedColumns(), this.extendTable.getColumnCount(), bl);
        } else {
            if (this.extendTable.getSelectState() == 3) {
                this.ciModel.clear(false);
                this.extendTable.setSelectState(0);
                this.setRowColWithType(new IdType(2, 3), true, false);
                this.extendTable.setSelectState(1);
                this.setRowColWithType(new IdType(2, 3), true, true);
                this.extendTable.setSelectState(-1);
                return;
            }
            return;
        }
        byte by = idType.getType();
        for (int n : nArray) {
            if (by == 11) {
                this.ciModel.addInterval(this.extendTable.getSelectState(), n, (byte)4);
                continue;
            }
            this.ciModel.addInterval(this.extendTable.getSelectState(), n, by);
        }
        if (bl2) {
            if (!this.hasMultilayer()) {
                this.imageIdentifierPanel.contentPaint();
            }
            this.updateTable(false);
        }
    }

    private void transposeStateChanged(ItemEvent itemEvent) {
        boolean bl = ((JCheckBox)itemEvent.getSource()).isSelected();
        if (this.ciModel.getTranspose() != bl) {
            this.extendTable.clearSelections();
            this.ciModel.setTranspose(bl);
            ((DefaultTableModel)this.extendTable.getModel()).fireTableStructureChanged();
            this.updateTable(true);
            this.scrollPane.getRowHeader().revalidate();
        }
    }

    class ColorButton
    extends JButton {
        private final boolean paintBox;
        private final IdType idtype;
        private final boolean primary;

        public ColorButton(boolean bl, IdType idType) {
            this(bl, idType, false);
        }

        public ColorButton(boolean bl, IdType idType, boolean bl2) {
            this.paintBox = bl;
            this.idtype = idType;
            this.primary = bl2;
            this.setFocusPainted(false);
            this.setEnabled(false);
        }

        public IdType getIdType() {
            return this.idtype;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.paintBox) {
                Color color = CellIdentifierModel.getColorByType(this.idtype.getType(), this.primary);
                graphics.setColor(color);
                graphics.fillRect(5, this.getHeight() / 2 - 6, 12, 12);
                graphics.setColor(Color.black);
                graphics.drawRect(5, this.getHeight() / 2 - 6, 11, 11);
            }
        }
    }

    static class IdType {
        private final byte type;
        private final byte tag;
        private final String string;

        public IdType(byte by, byte by2) {
            this(by, by2, "");
        }

        public IdType(byte by, byte by2, String string) {
            this.type = by;
            this.tag = by2;
            this.string = string;
        }

        public byte getTag() {
            return this.tag;
        }

        public byte getType() {
            return this.type;
        }

        public String toString() {
            return this.string;
        }
    }

    private class MyDescriptionListener
    implements DescriptionListener {
        private MyDescriptionListener() {
        }

        @Override
        public void ColHeaderSelected(int[] nArray) {
            CellIdentifierPanel.this.buttonObservation.setEnabled(nArray.length > 0);
            CellIdentifierPanel.this.buttonPrimaryObs.setEnabled(nArray.length == 1);
            CellIdentifierPanel.this.buttonVariable.setEnabled(false);
            CellIdentifierPanel.this.buttonPrimaryVar.setEnabled(false);
            CellIdentifierPanel.this.buttonSet.setEnabled(nArray.length > 0);
            this.globalSelection();
        }

        @Override
        public void RowHeaderSelected(int[] nArray) {
            CellIdentifierPanel.this.buttonVariable.setEnabled(nArray.length > 0);
            CellIdentifierPanel.this.buttonPrimaryVar.setEnabled(nArray.length == 1);
            CellIdentifierPanel.this.buttonClass.setEnabled(nArray.length > 0);
            CellIdentifierPanel.this.buttonObservation.setEnabled(false);
            CellIdentifierPanel.this.buttonPrimaryObs.setEnabled(false);
            CellIdentifierPanel.this.buttonSet.setEnabled(false);
            this.globalSelection();
        }

        private void globalSelection() {
            boolean bl = CellIdentifierPanel.this.extendTable.getSelectedColumnCount() > 0;
            CellIdentifierPanel.this.buttonClass.setEnabled(bl);
            int n = CellIdentifierPanel.this.extendTable.getSelectState();
            boolean bl2 = n == 3;
            CellIdentifierPanel.this.setExclude.setEnabled(bl && !bl2);
            CellIdentifierPanel.this.setInclude.setEnabled(bl);
            if (n == 3 && bl) {
                CellIdentifierPanel.this.setInclude.setText("Include only");
            } else {
                CellIdentifierPanel.this.setInclude.setText("Include");
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorButton colorButton = (ColorButton)actionEvent.getSource();
            CellIdentifierPanel.this.setRowColWithType(colorButton.getIdType());
        }
    }

    class DataTypeListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private IdType idtype = null;

        public DataTypeListCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public DataTypeListCellRenderer(IdType idType) {
            this();
            this.idtype = idType;
            this.setText("      " + idType.toString());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.idtype = (IdType)object;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText("      " + this.idtype.toString());
            return this;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.idtype != null) {
                graphics.setColor(CellIdentifierModel.getColorByType(this.idtype.getType()));
                graphics.fillRect(1, this.getHeight() / 2 - 6, 12, 12);
                graphics.setColor(Color.black);
                graphics.drawRect(1, this.getHeight() / 2 - 6, 11, 11);
            }
        }
    }

    class LayerButtonListener
    implements ActionListener {
        LayerButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorButton colorButton = (ColorButton)actionEvent.getSource();
            CellIdentifierPanel.this.setLayerWithType(colorButton.getIdType());
        }
    }

    public class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = CellIdentifierPanel.this.ciModel.getType(n, n2);
            if (n3 >= 4 && CellIdentifierPanel.this.ciModel.checkMissing(n, n2, (String)object, n3)) {
                component.setBackground(CellIdentifierModel.getColorByType(-2));
            } else {
                boolean bl3 = n3 == 0 && CellIdentifierPanel.this.ciModel.getPrimaryRow() == n || n3 == 1 && CellIdentifierPanel.this.ciModel.getPrimaryCol() == n2;
                component.setBackground(CellIdentifierModel.getColorByType(n3, bl3));
            }
            if (bl) {
                component.setBackground(component.getBackground().darker());
            }
            return component;
        }
    }
}

