/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.identifier;

import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ImageIdentifierHelper
implements CellIdentifier {
    private double min;
    private double max;
    private double saturatedValue;
    private boolean first = true;

    public void calcHistogram(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel, int n) {
        FastDecimal fastDecimal = new FastDecimal();
        int n2 = cellIdentifierModel.getColumnCount();
        int n3 = cellIdentifierModel.getResolution(1);
        int n4 = cellIdentifierModel.getRowCount();
        int n5 = cellIdentifierModel.getResolution(0);
        this.saturatedValue = cellIdentifierModel.getSaturatedValue() - 1.0;
        progressManager.setMaximumAndReset(n4 * n2 / (n5 * n3));
        progressManager.setInfoText("Rendering image");
        int[] nArray = cellIdentifierModel.getDataOrder();
        int[] nArray2 = new int[3];
        int n6 = nArray[2];
        int n7 = this.count(cellIdentifierModel, n6);
        int n8 = cellIdentifierModel.getResolution(n6);
        for (int i = 0; i < n7; i += n8) {
            nArray2[n6] = i;
            int n9 = nArray[1];
            int n10 = this.count(cellIdentifierModel, n9);
            int n11 = cellIdentifierModel.getResolution(n9);
            for (int j = 0; j < n10; j += n11) {
                nArray2[n9] = j;
                int n12 = nArray[0];
                int n13 = this.count(cellIdentifierModel, n12);
                int n14 = cellIdentifierModel.getResolution(n12);
                for (int k = 0; k < n13; k += n14) {
                    nArray2[n12] = k;
                    this.setMinMax(n, cellIdentifierModel.getDirectDoubleAt(nArray2[0], nArray2[1], n, fastDecimal));
                    progressManager.incStep();
                }
            }
        }
    }

    private int count(CellIdentifierModel cellIdentifierModel, int n) {
        if (n == 2) {
            return 1;
        }
        return cellIdentifierModel.getCount(n);
    }

    private void setMinMax(int n, FastDecimal fastDecimal) {
        if (fastDecimal.isMissing()) {
            return;
        }
        double d = fastDecimal.getValue();
        if (d >= this.saturatedValue) {
            return;
        }
        if (this.first) {
            this.min = d;
            this.max = d;
            this.first = false;
        } else {
            if (this.min > d) {
                this.min = d;
            }
            if (this.max < d) {
                this.max = d;
            }
        }
    }
}

