/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.identifier;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.JTextFieldButtonUppDown;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.identifier.CellIdentifierPanel;
import se.prediktera.map.dataimport.identifier.SpectralPanel;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;
import se.prediktera.map.simpletableeditor.ExtendScrollTable;

public class ImageIdentifierPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
CellIdentifier {
    public static final byte RECT_SELECTION = 0;
    protected static final byte HOR_SELECTION = 1;
    protected static final byte RECT_ZOOM = 2;
    protected static final byte PAN_ZOOM = 3;
    private static File cropfolder = null;
    private CellIdentifierPanel cipanel;
    private CellIdentifierModel ciModel;
    private ImportWizard importWizard;
    private final JTextFieldButtonUppDown contrastNumberField = new JTextFieldButtonUppDown(0.0, 100.0, false);
    private BufferedImage image = null;
    private final FastDecimal sampleDecimal = new FastDecimal();
    private Thread threadSpectra;
    private final int[] rgba = new int[4];
    private final int[] white_rgba = new int[]{255, 255, 255, 255};
    private final int[] missing_rgba = new int[]{255, 0, 0, 255};
    private final int MAXTYPE = 3;
    private final int[] start = new int[3];
    private final int[] stop = new int[3];
    private double[] min;
    private double[] max;
    private double[] abs;
    private double maxratio = 1.0;
    private boolean[] first;
    private int[] defaultband;
    private boolean aspectratio = false;
    private boolean showaltitude = false;
    private boolean created = false;
    private Point startPoint;
    private Point endPoint;
    private byte selectionmode = 0;
    private boolean rectselection = false;
    private SpectralPanel spectralPanel = null;
    private boolean iseditable = true;
    private double saturatedValue = Double.MAX_VALUE;
    private int zoomx;
    private int zoomy;
    private int zoomwidth;
    private int zoomheight;
    private double maxcols;
    private double maxrows;

    public ImageIdentifierPanel() {
    }

    public ImageIdentifierPanel(CellIdentifierPanel cellIdentifierPanel, boolean bl) {
        this.cipanel = cellIdentifierPanel;
        this.iseditable = bl;
        this.spectralPanel = new SpectralPanel(this, bl);
        final Timer timer = new Timer(200, actionEvent -> this.contentPaint());
        timer.setRepeats(false);
        this.addComponentListener(new ComponentAdapter(this){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                timer.restart();
            }
        });
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void clearImage() {
        this.ciModel = null;
        this.image = null;
        if (this.importWizard != null) {
            this.importWizard.cleanUp();
            this.importWizard = null;
        }
        this.repaint();
    }

    public void contentPaint() {
        if (this.created && this.ciModel != null) {
            this.contentPaintNoCheck();
        }
    }

    public synchronized void contentPaintNoCheck() {
        if (this.ciModel == null) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        double d = this.getColumnCount();
        double d2 = this.getRowCount();
        double d3 = (double)n / d;
        double d4 = (double)n2 / d2;
        if (this.aspectratio) {
            if (d3 > d4) {
                n = (int)((double)n / d3 * d4);
                d3 = d4;
            } else {
                n2 = (int)((double)n2 / d4 * d3);
                d4 = d3;
            }
        }
        d4 *= -1.0;
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        this.image = new BufferedImage(n, n2, 2);
        boolean[][] blArray = new boolean[n + 1][n2 + 1];
        double d5 = 1.0 / d3 * (double)this.ciModel.getResolution(0);
        double d6 = -1.0 / d4 * (double)this.ciModel.getResolution(1);
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        if (d6 < 1.0) {
            d6 = 1.0;
        }
        double[] dArray = new double[]{this.zoomy, this.zoomx, 0.0};
        double[] dArray2 = new double[]{d6, d5, 1.0};
        int[] nArray = new int[]{n2, n, 1};
        WritableRaster writableRaster = this.image.getRaster();
        int[] nArray2 = this.ciModel.getDataOrder();
        double[] dArray3 = new double[3];
        int n3 = nArray2[2];
        this.start[n3] = 0;
        double d7 = this.count(n3);
        for (double d8 = 0.0; d8 < d7; d8 += dArray2[n3]) {
            dArray3[n3] = d8;
            this.stop[n3] = this.minCeil((dArray3[n3] + dArray2[n3]) / d7, nArray[n3]);
            if (n3 != 2 && this.start[n3] == this.stop[n3]) continue;
            int n4 = nArray2[1];
            int n5 = this.count(n4);
            this.start[n4] = 0;
            for (double d9 = 0.0; d9 < (double)n5; d9 += dArray2[n4]) {
                dArray3[n4] = d9;
                this.stop[n4] = this.minCeil((dArray3[n4] + dArray2[n4]) / (double)n5, nArray[n4]);
                if (n4 != 2 && this.start[n4] == this.stop[n4]) continue;
                int n6 = nArray2[0];
                int n7 = this.count(n6);
                this.start[n6] = 0;
                for (double d10 = 0.0; d10 < (double)n7; d10 += dArray2[n6]) {
                    dArray3[n6] = d10;
                    this.stop[n6] = this.minCeil((dArray3[n6] + dArray2[n6]) / (double)n7, nArray[n6]);
                    if (n6 != 2 && this.start[n6] == this.stop[n6]) continue;
                    if (this.start[1] < blArray.length && this.start[0] < blArray[this.start[1]].length && (blArray[this.start[1]][this.start[0]] || this.setSamples(writableRaster, (int)(dArray3[0] + dArray[0]), (int)(dArray3[1] + dArray[1]), (int)(dArray3[2] + dArray[2])))) {
                        blArray[this.start[1]][this.start[0]] = true;
                    }
                    this.start[n6] = this.stop[n6];
                }
                this.start[n4] = this.stop[n4];
            }
            this.start[n3] = this.stop[n3];
        }
        this.ciModel.setCurrentLayer(0);
        this.repaint();
    }

    public int getColumnType(int n) {
        return this.ciModel.getColumnType(this.zoomx + n);
    }

    public ImportWizard getImportWizard() {
        return this.importWizard;
    }

    public CellIdentifierModel getModel() {
        return this.ciModel;
    }

    public int getRowType(int n) {
        return this.ciModel.getRowType(this.zoomy + n);
    }

    public boolean[] getSelectedLayer() {
        return this.spectralPanel.getSelectedLayer();
    }

    public SpectralPanel getSpectralPanel() {
        return this.spectralPanel;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.image != null) {
            int n = this.calcImageXstart();
            int n2 = this.calcImageYstart();
            double d = this.getRowCount();
            double d2 = this.getColumnCount();
            int n3 = (int)((double)(mouseEvent.getY() - n2) / (double)this.image.getHeight() * d);
            int n4 = (int)((double)(mouseEvent.getX() - n) / (double)this.image.getWidth() * d2);
            if (this.ciModel != null && n4 > -1 && n3 > -1) {
                if (this.cipanel.hasMultilayer()) {
                    this.setSpectraOnPoint(mouseEvent.getPoint());
                } else {
                    return this.ciModel.getTypeDescription(n3, n4, this.ciModel.getValueAt(n3, n4));
                }
            }
        }
        return null;
    }

    public void interruptThreadSpectra() {
        if (this.threadSpectra != null && this.threadSpectra.isAlive()) {
            this.threadSpectra.interrupt();
            this.threadSpectra = null;
        }
    }

    public boolean isAspectratio() {
        return this.aspectratio;
    }

    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            ExtendScrollTable extendScrollTable = this.cipanel.getExtendTable();
            extendScrollTable.clearSelection();
            this.repaint();
            if (this.cipanel.hasMultilayer()) {
                this.setSpectraOnPoint(mouseEvent.getPoint());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            graphics2D.setXORMode(this.getBackground());
            if (this.startPoint != null && this.endPoint != null) {
                this.drawSelection(graphics2D, this.startPoint, this.endPoint);
            }
            this.endPoint = mouseEvent.getPoint();
            boolean bl = this.rectselection = this.selectionmode == 0 || this.selectionmode == 2;
            if (mouseEvent.isShiftDown()) {
                this.rectselection = !this.rectselection;
            }
            this.drawSelection(graphics2D, this.startPoint, this.endPoint);
            graphics2D.dispose();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.startPoint = mouseEvent.getPoint();
            this.endPoint = null;
        } else if (this.iseditable && SwingUtilities.isRightMouseButton(mouseEvent)) {
            CMenuItem cMenuItem;
            CMenuItem cMenuItem2;
            JPopupMenu jPopupMenu = new JPopupMenu();
            ExtendScrollTable extendScrollTable = this.cipanel.getExtendTable();
            int n = extendScrollTable.getSelectState();
            if (n == 3) {
                cMenuItem2 = new CMenuItem("Include only", false);
                cMenuItem2.addActionListener(actionEvent -> this.setRowColIncluded(true));
                jPopupMenu.add(cMenuItem2);
            } else {
                cMenuItem2 = new CMenuItem("Include", false);
                cMenuItem2.addActionListener(actionEvent -> this.setRowColIncluded(true));
                jPopupMenu.add(cMenuItem2);
                cMenuItem = new CMenuItem("Exclude", false);
                cMenuItem.addActionListener(actionEvent -> this.setRowColIncluded(false));
                jPopupMenu.add(cMenuItem);
            }
            jPopupMenu.addSeparator();
            cMenuItem2 = new CMenuItem("Clear", false);
            cMenuItem2.addActionListener(actionEvent -> this.cipanel.clear(false));
            jPopupMenu.add(cMenuItem2);
            cMenuItem = new CMenuItem("Reset zoom", false);
            cMenuItem.addActionListener(actionEvent -> this.zoomAll());
            jPopupMenu.add(cMenuItem);
            jPopupMenu.addSeparator();
            CMenuItem cMenuItem3 = new CMenuItem("Change contrast", false);
            cMenuItem3.addActionListener(actionEvent -> {
                String string = JOptionPane.showInputDialog(this, "Set max intensity (0-100)%", NiceDataFormat.toString(this.maxratio * 100.0));
                if (string != null) {
                    try {
                        double d = Double.parseDouble(string);
                        this.setMaxRatio(d);
                        this.contrastNumberField.setValue(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            jPopupMenu.add(cMenuItem3);
            jPopupMenu.addSeparator();
            CMenuItem cMenuItem4 = new CMenuItem("Crop As...", false);
            cMenuItem4.addActionListener(actionEvent -> {
                Object object;
                File file;
                File file2 = file = this.ciModel.getRootFolder();
                if (cropfolder != null) {
                    file2 = cropfolder;
                }
                String string = jopensaveDialog.getFileName(file);
                File file3 = null;
                int n = 1;
                do {
                    object = string + "_" + n;
                    file3 = new File(file2, (String)object + "\\" + (String)object + ".raw");
                    ++n;
                } while (file3.exists());
                object = new jopensaveDialog("Choose file name", this);
                ((jopensaveDialog)object).setCurrentDirectory(file2);
                ((jopensaveDialog)object).setFileName(jopensaveDialog.getFileName(file3) + "\\" + file3.getName());
                if (((jopensaveDialog)object).saveshow()) {
                    final File file4 = ((JFileChooser)object).getSelectedFile();
                    File file5 = file4.getParentFile().getParentFile();
                    if (!file2.equals(file5)) {
                        cropfolder = file5;
                    }
                    ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
                        final /* synthetic */ ImageIdentifierPanel this$0;
                        {
                            this.this$0 = imageIdentifierPanel;
                        }

                        @Override
                        public Object doWork() {
                            try {
                                int n = Math.max(0, this.this$0.zoomx);
                                int n2 = Math.max(0, this.this$0.zoomy);
                                int n3 = Math.min(this.this$0.ciModel.getColumnCount(), this.this$0.zoomx + this.this$0.zoomwidth) - n;
                                int n4 = Math.min(this.this$0.ciModel.getRowCount(), this.this$0.zoomy + this.this$0.zoomheight) - n2;
                                if (n < this.this$0.ciModel.getColumnCount() && n2 < this.this$0.ciModel.getRowCount() && n3 > 0 && n4 > 0) {
                                    this.this$0.ciModel.crop(this, file4, n, n2, n3, n4);
                                }
                            }
                            catch (Exception exception) {
                                ErrorHandler.logAndReportException(exception);
                            }
                            return null;
                        }
                    };
                    progressManagerImpl.invokeLater();
                }
            });
            jPopupMenu.add(cMenuItem4);
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.startPoint != null && this.endPoint != null && this.image != null) {
            ExtendScrollTable extendScrollTable = this.cipanel.getExtendTable();
            double d = this.getColumnCount();
            double d2 = this.getRowCount();
            double d3 = d / (double)this.getWidth();
            double d4 = d2 / (double)this.getHeight();
            if (this.aspectratio) {
                if (d3 < d4) {
                    d3 = d4;
                } else {
                    d4 = d3;
                }
            }
            int n = this.calcImageXstart();
            int n2 = this.calcImageYstart();
            int n3 = Math.min(this.startPoint.x, this.endPoint.x);
            int n4 = Math.max(this.startPoint.x, this.endPoint.x);
            int n5 = Math.min(this.startPoint.y, this.endPoint.y);
            int n6 = Math.max(this.startPoint.y, this.endPoint.y);
            int n7 = Math.abs(this.endPoint.x - this.startPoint.x);
            int n8 = Math.abs(this.endPoint.y - this.startPoint.y);
            int n9 = (int)((double)(n3 - n) * d3) + this.zoomx;
            int n10 = (int)((double)(n4 - n) * d3) + this.zoomx;
            int n11 = (int)((double)(n5 - n2) * d4) + this.zoomy;
            int n12 = (int)((double)(n6 - n2) * d4) + this.zoomy;
            if (this.selectionmode <= 1) {
                boolean bl = mouseEvent.isControlDown();
                if (!this.rectselection) {
                    if (n7 > n8) {
                        if (extendScrollTable.setSelectState(1)) {
                            bl = false;
                        }
                        extendScrollTable.setRowSelectionInterval(0, (int)this.maxrows - 1);
                        this.setColumn(extendScrollTable, bl, n9, n10, 0.0, this.maxcols - 1.0);
                    } else {
                        if (extendScrollTable.setSelectState(0)) {
                            bl = false;
                        }
                        extendScrollTable.setColumnSelectionInterval(0, (int)this.maxcols - 1);
                        this.setRow(extendScrollTable, bl, n11, n12, 0.0, this.maxrows - 1.0);
                    }
                } else {
                    if (extendScrollTable.setSelectState(3)) {
                        bl = false;
                    }
                    this.setColumn(extendScrollTable, bl, n9, n10, 0.0, this.maxcols - 1.0);
                    this.setRow(extendScrollTable, bl, n11, n12, 0.0, this.maxrows - 1.0);
                }
                this.repaint();
            } else {
                if (this.selectionmode == 2) {
                    this.zoomx = n9;
                    this.zoomy = n11;
                    this.zoomwidth = n10 - n9;
                    this.zoomheight = n12 - n11;
                } else if (this.selectionmode == 3) {
                    int n13 = this.startPoint.x < this.endPoint.x ? -1 : 1;
                    this.zoomx += (n10 - n9) * n13;
                    int n14 = this.startPoint.y < this.endPoint.y ? -1 : 1;
                    this.zoomy += (n12 - n11) * n14;
                }
                this.contentPaint();
            }
        }
        this.startPoint = null;
        this.endPoint = null;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.image != null) {
            boolean bl;
            int n;
            int n2 = this.calcImageXstart();
            int n3 = this.calcImageYstart();
            graphics.drawImage(this.image, n2, n3, null);
            ExtendScrollTable extendScrollTable = this.cipanel != null ? this.cipanel.getExtendTable() : null;
            double d = this.getWidth();
            double d2 = this.getHeight();
            double d3 = this.getColumnCount();
            double d4 = this.getRowCount();
            double d5 = d / d3;
            double d6 = d2 / d4;
            if (this.aspectratio) {
                if (d5 > d6) {
                    d5 = d6;
                } else {
                    d6 = d5;
                }
            }
            int n4 = -1;
            int n5 = 0;
            int n6 = 0;
            while ((double)n6 <= d4) {
                n = this.getRowType(n6);
                if (n4 != n || (double)n6 == d4) {
                    if (n4 == 2) {
                        bl = n4 == 0 && this.ciModel.getPrimaryCol() == n6;
                        graphics.setColor(CellIdentifierModel.getColorByType(n4, bl));
                        graphics.fillRect(n2, (int)Math.floor((double)n5 * d6) + n3, this.image.getWidth(), (int)Math.ceil((double)(n6 - n5) * d6));
                    }
                    n5 = n6;
                    n4 = n;
                }
                ++n6;
            }
            n4 = -1;
            n5 = 0;
            n6 = 0;
            while ((double)n6 <= d3) {
                n = this.getColumnType(n6);
                if (n4 != n || (double)n6 == d3) {
                    if (n4 == 2) {
                        bl = n4 == 1 && this.ciModel.getPrimaryCol() == n6;
                        graphics.setColor(CellIdentifierModel.getColorByType(n4, bl));
                        graphics.fillRect((int)Math.floor((double)n5 * d5) + n2, n3, (int)Math.ceil((double)(n6 - n5) * d5), this.image.getHeight());
                    }
                    n5 = n6;
                    n4 = n;
                }
                ++n6;
            }
            if (extendScrollTable != null) {
                Color color = new Color(255, 255, 0, 100);
                int[] nArray = extendScrollTable.getSelectedRows();
                int[] nArray2 = extendScrollTable.getSelectedColumns();
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 0; j < nArray2.length; ++j) {
                        int n7;
                        if (i != 0 && nArray[i] == nArray[i - 1] + 1 || j != 0 && nArray2[j] == nArray2[j - 1] + 1) continue;
                        int n8 = j + 1;
                        for (n7 = i + 1; n7 < nArray.length && nArray[n7] == nArray[n7 - 1] + 1; ++n7) {
                        }
                        while (n8 < nArray2.length && nArray2[n8] == nArray2[n8 - 1] + 1) {
                            ++n8;
                        }
                        graphics.setColor(color);
                        graphics.fillRect((int)Math.floor((double)(nArray2[j] - this.zoomx) * d5) + n2, (int)Math.floor((double)(nArray[i] - this.zoomy) * d6) + n3, (int)(Math.ceil(n8 - j) * d5), (int)(Math.ceil(n7 - i) * d6));
                    }
                }
            }
        }
    }

    public void setAspectratio(boolean bl) {
        this.aspectratio = bl;
    }

    public void setCreated() {
        if (!this.created) {
            this.contentPaintNoCheck();
            this.created = true;
        }
    }

    public void setLayerIncluded(boolean bl) {
        this.cipanel.setLayerIncluded(bl);
    }

    public void setMaxRatio(double d) {
        this.maxratio = d / 100.0;
        this.contentPaint();
    }

    public void setRowColIncluded(boolean bl) {
        this.cipanel.setRowColIncluded(bl);
    }

    public void setSelectionMode(byte by) {
        this.selectionmode = by;
        if (by <= 1) {
            ExtendScrollTable extendScrollTable = this.cipanel.getExtendTable();
            extendScrollTable.clearSelection();
            this.repaint();
        }
        if (by == 3) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setSpectralData(final ExtendScrollTable extendScrollTable, final int n, final int n2) {
        if (this.spectralPanel != null && this.ciModel != null && extendScrollTable != null) {
            this.interruptThreadSpectra();
            this.spectralPanel.setGeneratingSpectra();
            this.threadSpectra = new Thread(this){
                final /* synthetic */ ImageIdentifierPanel this$0;
                {
                    this.this$0 = imageIdentifierPanel;
                }

                @Override
                public void run() {
                    int[] nArray;
                    int[] nArray2;
                    ArrayList<DataWrapper> arrayList = new ArrayList<DataWrapper>();
                    int n9 = this.this$0.ciModel.getLayerCount();
                    if (n < 0 || n2 < 0) {
                        nArray2 = extendScrollTable.getSelectedRows();
                        nArray = extendScrollTable.getSelectedColumns();
                    } else {
                        nArray2 = new int[]{n};
                        nArray = new int[]{n2};
                    }
                    int n22 = nArray2.length * nArray.length;
                    if (n22 > 0) {
                        int n3 = this.this$0.ciModel.getResolution(2);
                        int[] nArray3 = this.this$0.ciModel.getDataOrder();
                        FastDecimal fastDecimal = new FastDecimal();
                        double d = Math.max((double)n22 / 10.0, 1.0);
                        if (nArray3[1] == 2) {
                            for (double d2 = 0.0; d2 < (double)n22; d2 += d) {
                                int n4;
                                int n5;
                                if (nArray3[0] == 0) {
                                    n5 = (int)(d2 / (double)nArray.length);
                                    n4 = (int)(d2 % (double)nArray.length);
                                } else {
                                    n4 = (int)(d2 / (double)nArray2.length);
                                    n5 = (int)(d2 % (double)nArray2.length);
                                }
                                if (this.isInterrupted()) {
                                    return;
                                }
                                DataWrapper dataWrapper = new DataWrapper(n9, "");
                                for (int i = 0; i < n9; i += n3) {
                                    this.this$0.ciModel.getDoubleAt(nArray2[n5], nArray[n4], i, fastDecimal);
                                    dataWrapper.setYvalueAt(i, (float)fastDecimal.getValue());
                                }
                                arrayList.add(dataWrapper);
                            }
                        } else {
                            for (double d3 = 0.0; d3 < (double)n22; d3 += d) {
                                DataWrapper dataWrapper = new DataWrapper(n9, "");
                                arrayList.add(dataWrapper);
                            }
                            for (int i = 0; i < n9; i += n3) {
                                int n6 = 0;
                                for (double d4 = 0.0; d4 < (double)n22; d4 += d) {
                                    int n7;
                                    int n8;
                                    if (nArray3[0] == 0) {
                                        n8 = (int)(d4 / (double)nArray.length);
                                        n7 = (int)(d4 % (double)nArray.length);
                                    } else {
                                        n7 = (int)(d4 / (double)nArray2.length);
                                        n8 = (int)(d4 % (double)nArray2.length);
                                    }
                                    if (this.isInterrupted()) {
                                        return;
                                    }
                                    this.this$0.ciModel.getDoubleAt(nArray2[n8], nArray[n7], i, fastDecimal);
                                    DataWrapper dataWrapper = (DataWrapper)arrayList.get(n6++);
                                    dataWrapper.setYvalueAt(i, (float)fastDecimal.getValue());
                                }
                            }
                        }
                        this.this$0.ciModel.setCurrentLayer(0);
                    }
                    this.this$0.spectralPanel.setData(arrayList);
                }
            };
            this.threadSpectra.start();
        }
    }

    public void setTableModel(final ImportWizard importWizard) {
        this.importWizard = importWizard;
        ProgressManagerImpl progressManagerImpl = new ProgressManagerImpl(this){
            final /* synthetic */ ImageIdentifierPanel this$0;
            {
                this.this$0 = imageIdentifierPanel;
            }

            @Override
            public Object doWork() {
                CellIdentifierModel cellIdentifierModel = importWizard.getCellIdentifierModel(this);
                if (cellIdentifierModel != null) {
                    this.this$0.setTableModel(this, cellIdentifierModel);
                } else {
                    this.this$0.clearImage();
                }
                return null;
            }
        };
        progressManagerImpl.invokeNow();
    }

    public void setTableModel(ProgressManager progressManager) {
        this.setTableModel(progressManager, this.cipanel.getCiModel());
    }

    public void spectralSelectionChanged(boolean bl) {
        this.cipanel.spectralSelectionChanged(bl);
    }

    public void zoomAll() {
        this.zoomy = 0;
        this.zoomx = 0;
        this.zoomwidth = this.ciModel.getColumnCount();
        this.zoomheight = this.ciModel.getRowCount();
        this.contentPaint();
    }

    private int calcImageXstart() {
        if (this.image != null) {
            return (int)((double)this.getWidth() / 2.0 - (double)this.image.getWidth() / 2.0);
        }
        return 0;
    }

    private int calcImageYstart() {
        if (this.image != null) {
            return (int)((double)this.getHeight() / 2.0 - (double)this.image.getHeight() / 2.0);
        }
        return 0;
    }

    private int count(int n) {
        return switch (n) {
            case 0 -> this.getRowCount();
            case 1 -> this.getColumnCount();
            case 2 -> this.defaultband.length;
            default -> 0;
        };
    }

    private void drawSelection(Graphics2D graphics2D, Point point, Point point2) {
        if (this.selectionmode != 3 && point != null && point2 != null) {
            graphics2D.setStroke(AbstractRubberband.robberStroke);
            int n = Math.abs(point2.x - point.x);
            int n2 = Math.abs(point2.y - point.y);
            if (!this.rectselection) {
                if (n > n2) {
                    if (point.x < point2.x) {
                        graphics2D.drawRect(point.x, this.calcImageYstart(), n, this.image.getHeight() - 1);
                    } else {
                        graphics2D.drawRect(point2.x, this.calcImageYstart(), n, this.image.getHeight() - 1);
                    }
                } else if (point.y < point2.y) {
                    graphics2D.drawRect(this.calcImageXstart(), point.y, this.image.getWidth() - 1, n2);
                } else {
                    graphics2D.drawRect(this.calcImageXstart(), point2.y, this.image.getWidth() - 1, n2);
                }
            } else {
                graphics2D.drawRect(Math.min(point.x, point2.x), Math.min(point.y, point2.y), n, n2);
            }
        }
    }

    private int getColumnCount() {
        return this.zoomwidth;
    }

    private int getRowCount() {
        return this.zoomheight;
    }

    private int minCeil(double d, int n) {
        return (int)Math.min(Math.ceil(d * (double)n), (double)n);
    }

    private void setAllSamples(WritableRaster writableRaster, int[] nArray) {
        for (int i = 0; i < 3; ++i) {
            this.setSample(writableRaster, i, nArray[i]);
        }
    }

    private void setColumn(ExtendScrollTable extendScrollTable, boolean bl, double d, double d2, double d3, double d4) {
        if (d > d4 || d2 < d3) {
            return;
        }
        d = Math.max(d, d3);
        d2 = Math.min(d2, d4);
        if (bl) {
            extendScrollTable.addColumnSelectionInterval((int)d, (int)d2);
        } else {
            extendScrollTable.setColumnSelectionInterval((int)d, (int)d2);
        }
    }

    private void setMinMax(int n, FastDecimal fastDecimal) {
        if (fastDecimal.isMissing()) {
            return;
        }
        double d = fastDecimal.getValue();
        if (d >= this.saturatedValue) {
            return;
        }
        if (this.first[n]) {
            this.min[n] = d;
            this.max[n] = d;
            this.first[n] = false;
        } else {
            if (this.min[n] > d) {
                this.min[n] = d;
            }
            if (this.max[n] < d) {
                this.max[n] = d;
            }
        }
    }

    private void setMinMax(ProgressManager progressManager) {
        int n;
        int n2;
        int n3;
        int n4;
        FastDecimal fastDecimal = new FastDecimal();
        int n5 = this.ciModel.getColumnCount();
        int n6 = this.ciModel.getResolution(1);
        int n7 = this.ciModel.getRowCount();
        int n8 = this.ciModel.getResolution(0);
        this.saturatedValue = this.ciModel.getSaturatedValue() - 1.0;
        progressManager.setMaximumAndReset(this.defaultband.length * n7 * n5 / (n8 * n6));
        progressManager.setInfoText("Rendering image");
        int[] nArray = this.ciModel.getDataOrder();
        int[] nArray2 = new int[3];
        int n9 = nArray[2];
        int n10 = this.count(n9);
        int n11 = this.ciModel.getResolution(n9);
        boolean bl = this.ciModel.isMultiLayer();
        for (int i = 0; i < n10; i += n11) {
            nArray2[n9] = i;
            n4 = nArray[1];
            n3 = this.count(n4);
            n2 = this.ciModel.getResolution(n4);
            for (n = 0; n < n3; n += n2) {
                nArray2[n4] = n;
                int n12 = nArray[0];
                int n13 = this.count(n12);
                int n14 = this.ciModel.getResolution(n12);
                for (int j = 0; j < n13; j += n14) {
                    nArray2[n12] = j;
                    if (bl) {
                        this.setMinMax(this.defaultband[nArray2[2]], this.ciModel.getDirectDoubleAt(nArray2[0], nArray2[1], this.defaultband[nArray2[2]], fastDecimal));
                    } else {
                        this.setMinMax(this.defaultband[nArray2[2]], this.ciModel.getDoubleAt(nArray2[0], nArray2[1], this.defaultband[nArray2[2]], fastDecimal));
                    }
                    progressManager.incStep();
                }
            }
        }
        int[] nArray3 = this.defaultband;
        n4 = nArray3.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n = n2 = nArray3[n3];
            this.abs[n] = this.max[n] - this.min[n];
        }
    }

    private void setRow(ExtendScrollTable extendScrollTable, boolean bl, double d, double d2, double d3, double d4) {
        if (d > d4 || d2 < d3) {
            return;
        }
        d = Math.max(d, d3);
        d2 = Math.min(d2, d4);
        if (bl) {
            extendScrollTable.addRowSelectionInterval((int)d, (int)d2);
        } else {
            extendScrollTable.setRowSelectionInterval((int)d, (int)d2);
        }
    }

    private void setSample(WritableRaster writableRaster, int n, int n2) {
        for (int i = this.start[0]; i < this.stop[0]; ++i) {
            for (int j = this.start[1]; j < this.stop[1]; ++j) {
                writableRaster.setSample(j, i, n, n2);
                writableRaster.setSample(j, i, 3, 255);
            }
        }
    }

    private boolean setSamples(WritableRaster writableRaster, int n, int n2, int n3) {
        int n4 = this.ciModel.getType(n, n2);
        if (n4 != 4 && n4 != 2) {
            boolean bl = n4 == 0 && this.ciModel.getPrimaryRow() == n || n4 == 1 && this.ciModel.getPrimaryCol() == n2;
            Color color = CellIdentifierModel.getColorByType(n4, bl);
            this.rgba[0] = color.getRed();
            this.rgba[1] = color.getGreen();
            this.rgba[2] = color.getBlue();
            this.rgba[3] = 255;
            this.setAllSamples(writableRaster, this.rgba);
            return true;
        }
        int n5 = this.defaultband[n3];
        if (n < 0 || n2 < 0 || (double)n >= this.maxrows || (double)n2 >= this.maxcols) {
            this.sampleDecimal.error();
        } else {
            this.ciModel.getDoubleAt(n, n2, n5, this.sampleDecimal);
        }
        if (this.sampleDecimal.isMissing()) {
            this.setAllSamples(writableRaster, this.missing_rgba);
            return true;
        }
        if (this.showaltitude) {
            int n6 = (int)((this.sampleDecimal.getValue() - this.min[n5]) / (this.abs[n5] * this.maxratio) * 255.0);
            if (n6 > 255) {
                n6 = 255;
            }
            this.setSample(writableRaster, n3, n6);
            return false;
        }
        this.setAllSamples(writableRaster, this.white_rgba);
        return true;
    }

    private void setSpectraOnPoint(Point point) {
        if (this.spectralPanel != null && this.image != null) {
            int n = this.calcImageXstart();
            int n2 = this.calcImageYstart();
            double d = this.ciModel.getRowCount();
            double d2 = this.ciModel.getColumnCount();
            int n3 = (int)((point.getY() - (double)n2) / (double)this.image.getHeight() * d);
            int n4 = (int)((point.getX() - (double)n) / (double)this.image.getWidth() * d2);
            if (this.ciModel != null && n4 >= 0 && n3 >= 0 && (double)n4 < d2 && (double)n3 < d) {
                this.setSpectralData(this.cipanel.getExtendTable(), n3, n4);
            } else {
                this.spectralPanel.setData(new ArrayList<DataWrapper>());
            }
        }
    }

    private void setTableModel(ProgressManager progressManager, CellIdentifierModel cellIdentifierModel) {
        int n;
        this.ciModel = cellIdentifierModel;
        cellIdentifierModel.init(progressManager);
        int n2 = cellIdentifierModel.getLayerCount();
        this.defaultband = cellIdentifierModel.getDefaultBand();
        if (this.defaultband == null) {
            this.defaultband = new int[Math.min(n2, 3)];
            for (var4_4 = 0; var4_4 < this.defaultband.length; ++var4_4) {
                if (cellIdentifierModel.isMultiLayer()) {
                    n = cellIdentifierModel.getLayerCount() / 4;
                    this.defaultband[var4_4] = n * var4_4 + n;
                    continue;
                }
                this.defaultband[var4_4] = var4_4;
            }
        } else {
            for (var4_4 = 0; var4_4 < this.defaultband.length; ++var4_4) {
                this.defaultband[var4_4] = Math.min(this.defaultband[var4_4], n2 - 1);
            }
        }
        if (cellIdentifierModel.isMultiLayer()) {
            this.aspectratio = true;
            this.showaltitude = true;
            if (this.spectralPanel != null) {
                this.spectralPanel.setTableModel(progressManager);
            }
        }
        this.min = new double[n2];
        this.max = new double[n2];
        this.abs = new double[n2];
        this.first = new boolean[n2];
        Arrays.fill(this.first, true);
        this.maxcols = cellIdentifierModel.getColumnCount();
        this.maxrows = cellIdentifierModel.getRowCount();
        this.zoomy = 0;
        this.zoomx = 0;
        this.zoomwidth = cellIdentifierModel.getColumnCount();
        this.zoomheight = cellIdentifierModel.getRowCount();
        if (this.showaltitude) {
            int[] nArray = cellIdentifierModel.getMinMax();
            if (nArray != null) {
                for (n = 0; n < n2; ++n) {
                    this.min[n] = nArray[0];
                    this.max[n] = nArray[1];
                    this.abs[n] = this.max[n] - this.min[n];
                }
            } else {
                this.setMinMax(progressManager);
            }
        }
        this.contentPaint();
        this.setSpectralData(null, -1, -1);
    }

    public JTextFieldButtonUppDown getContrastNumberField() {
        return this.contrastNumberField;
    }
}

