/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.identifier;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.identifier.ImageIdentifierPanel;
import se.prediktera.map.plot.axisplot.rubberband.AbstractRubberband;
import se.prediktera.map.plot.spectral.DataWrapper;
import se.prediktera.map.plot.spectral.SpectralPlot;
import se.prediktera.map.simpletableeditor.CellIdentifier;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class SpectralPanel
extends JPanel
implements CellIdentifier {
    private final ImportSpectralPlot spectralPlot = new ImportSpectralPlot();
    private final ImageIdentifierPanel imagePanel;
    private boolean[] selband;
    private String informationText = "Select pixels to show spectra";
    private final boolean iseditable;

    public SpectralPanel(ImageIdentifierPanel imageIdentifierPanel, boolean bl) {
        this.imagePanel = imageIdentifierPanel;
        this.iseditable = bl;
        ToolTipManager.sharedInstance().registerComponent(this.spectralPlot);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void clearSelection() {
        this.selband = null;
        this.repaint();
    }

    public void contentPaint() {
        this.spectralPlot.contentPaint();
    }

    public boolean[] getSelectedLayer() {
        return this.selband;
    }

    public void setData(List<DataWrapper> list) {
        this.informationText = "Select pixels to show spectra";
        this.spectralPlot.setData(list);
    }

    public void setGeneratingSpectra() {
        this.informationText = "Generating spectral information";
        this.spectralPlot.setData(new ArrayList<DataWrapper>());
    }

    public void setTableModel(ProgressManager progressManager) {
        this.spectralPlot.setTableModel(progressManager);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.spectralPlot, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(6, 6, 6, 6), 0, 0));
    }

    class ImportSpectralPlot
    extends SpectralPlot {
        private Point startPoint;
        private Point endPoint;

        ImportSpectralPlot() {
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            CellIdentifierModel cellIdentifierModel = SpectralPanel.this.imagePanel.getModel();
            double d = cellIdentifierModel.getLayerCount();
            double[] dArray = new double[2];
            this.Screen2Real(dArray, mouseEvent.getX(), 0.0);
            if (dArray[0] > 0.0 && dArray[0] < d) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
                stringBuilder.append("<tr><td>").append("Channel:").append("</td>");
                stringBuilder.append("<td>").append(cellIdentifierModel.getLayerName((int)dArray[0])).append("</td></tr>");
                stringBuilder.append("</table></html>");
                return stringBuilder.toString();
            }
            return super.getToolTipText(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                SpectralPanel.this.selband = null;
                this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.hasData()) {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                graphics2D.setXORMode(this.getBackground());
                if (this.startPoint != null && this.endPoint != null) {
                    this.drawSelection(graphics2D, this.startPoint, this.endPoint);
                }
                this.endPoint = mouseEvent.getPoint();
                this.drawSelection(graphics2D, this.startPoint, this.endPoint);
                graphics2D.dispose();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.startPoint = mouseEvent.getPoint();
                this.endPoint = null;
            }
            if (SpectralPanel.this.iseditable && SwingUtilities.isRightMouseButton(mouseEvent)) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                CMenuItem cMenuItem = new CMenuItem("Include", false);
                cMenuItem.addActionListener(actionEvent -> SpectralPanel.this.imagePanel.setLayerIncluded(true));
                jPopupMenu.add(cMenuItem);
                CMenuItem cMenuItem2 = new CMenuItem("Exclude", false);
                cMenuItem2.addActionListener(actionEvent -> SpectralPanel.this.imagePanel.setLayerIncluded(false));
                jPopupMenu.add(cMenuItem2);
                jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.startPoint != null && this.endPoint != null) {
                CellIdentifierModel cellIdentifierModel = SpectralPanel.this.imagePanel.getModel();
                double d = cellIdentifierModel.getLayerCount();
                double[] dArray = new double[2];
                double[] dArray2 = new double[2];
                if (this.startPoint.x < this.endPoint.x) {
                    this.Screen2Real(dArray, this.startPoint.x, 0.0);
                    this.Screen2Real(dArray2, this.endPoint.x, 0.0);
                } else {
                    this.Screen2Real(dArray, this.endPoint.x, 0.0);
                    this.Screen2Real(dArray2, this.startPoint.x, 0.0);
                }
                this.setBand(mouseEvent, dArray[0], dArray2[0], 0.0, d);
                this.repaint();
                SpectralPanel.this.imagePanel.spectralSelectionChanged(SpectralPanel.this.selband != null);
            }
            this.startPoint = null;
            this.endPoint = null;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            CellIdentifierModel cellIdentifierModel = SpectralPanel.this.imagePanel.getModel();
            if (cellIdentifierModel != null) {
                double d = cellIdentifierModel.getLayerCount();
                Color color = CellIdentifierModel.getColorByType(2, false);
                int n = 0;
                while ((double)n < d) {
                    if (cellIdentifierModel.getLayerType(n) == 2) {
                        int n2 = n + 1;
                        while ((double)n2 < d && cellIdentifierModel.getLayerType(n2) == 2) {
                            ++n2;
                        }
                        this.Real2Screen(dArray, n, 0.0);
                        this.Real2Screen(dArray2, n2, 0.0);
                        graphics.setColor(color);
                        graphics.fillRect((int)dArray[0], this.sy, (int)(dArray2[0] - dArray[0]), this.height - 1);
                        n = n2 - 1;
                    }
                    ++n;
                }
            }
            if (SpectralPanel.this.selband != null) {
                Color color = new Color(255, 255, 0, 100);
                for (int i = 0; i < SpectralPanel.this.selband.length; ++i) {
                    int n;
                    if (!SpectralPanel.this.selband[i] || i != 0 && SpectralPanel.this.selband[i] == SpectralPanel.this.selband[i - 1]) continue;
                    for (n = i + 1; n < SpectralPanel.this.selband.length && SpectralPanel.this.selband[n] == SpectralPanel.this.selband[n - 1]; ++n) {
                    }
                    this.Real2Screen(dArray, i, 0.0);
                    this.Real2Screen(dArray2, n, 0.0);
                    graphics.setColor(color);
                    graphics.fillRect((int)dArray[0], this.sy, (int)(dArray2[0] - dArray[0]), this.height - 1);
                }
            }
        }

        public void setTableModel(ProgressManager progressManager) {
            CellIdentifierModel cellIdentifierModel = SpectralPanel.this.imagePanel.getModel();
            int n = cellIdentifierModel.getLayerCount();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = cellIdentifierModel.getLayerName(i);
            }
            this.setValues(stringArray);
        }

        @Override
        protected String getNoSpectraDesc() {
            return SpectralPanel.this.informationText;
        }

        private void drawSelection(Graphics2D graphics2D, Point point, Point point2) {
            if (point != null && point2 != null) {
                graphics2D.setStroke(AbstractRubberband.robberStroke);
                int n = Math.abs(point2.x - point.x);
                if (point.x < point2.x) {
                    graphics2D.drawRect(point.x, this.sy, n, this.height - 1);
                } else {
                    graphics2D.drawRect(point2.x, this.sy, n, this.height - 1);
                }
            }
        }

        private void setBand(MouseEvent mouseEvent, double d, double d2, double d3, double d4) {
            if (d > d4 || d2 < d3) {
                if (!mouseEvent.isControlDown()) {
                    SpectralPanel.this.selband = null;
                }
                return;
            }
            if ((d = Math.max(d, d3)) == (d2 = Math.min(d2, d4))) {
                if (!mouseEvent.isControlDown()) {
                    SpectralPanel.this.selband = null;
                }
                return;
            }
            if (SpectralPanel.this.selband == null || !mouseEvent.isControlDown()) {
                SpectralPanel.this.selband = new boolean[(int)d4];
            }
            int n = (int)d;
            while ((double)n < d2) {
                SpectralPanel.this.selband[n] = true;
                ++n;
            }
        }
    }
}

