/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Properties;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.breeze.Interleave;
import se.prediktera.map.dataimport.image.hdr.HdrImageImportInfo;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.extclass.DataTreeExtLibInterface;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.main.script.ImportClass;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public abstract class AbstractHeaderDataSource
extends AbstractDataSource
implements DataTreeExtLibInterface {
    protected String description;
    protected String interleaveString;
    protected File headerFile;
    protected double[] wavelength;
    protected String[] bandnames;
    protected RandomInputStream inStream;
    protected boolean swapByteOrder = true;
    protected byte[] bytes = new byte[8];
    protected Interleave interleave = Interleave.BSQ_COL;
    protected long imageStart;
    protected int imageWidth;
    protected int imageHeight;
    protected int layerCount = 0;
    protected byte fileDataType;
    protected int sampleSize;
    protected int currentLayer = -1;
    protected int[] defaultband;
    protected boolean fileUnsigned = true;
    protected File file;
    private final double maxbyte = 256.0;
    private final double maxshort = 65536.0;
    private final long maxinteger = 0x100000000L;
    private long cacheStart = Long.MAX_VALUE;
    private final int cacheLength = 4096;
    private final byte[] cache = new byte[4096];
    private boolean flipwavelength = false;
    protected int shiftwavelength = 0;

    public AbstractHeaderDataSource(File file, byte by) throws IOException {
        super(by);
        this.file = file;
        this.openConnections();
        this.setForceMultiLayer(true);
    }

    public AbstractHeaderDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.imageStart = mapProperty.getPropertyLong("is");
        this.imageWidth = mapProperty.getPropertyInt("iw");
        this.imageHeight = mapProperty.getPropertyInt("ih");
        this.layerCount = mapProperty.getPropertyInt("lc");
        this.fileDataType = mapProperty.getPropertyByte("fdt");
        this.sampleSize = mapProperty.getPropertyInt("ssize");
        this.defaultband = mapProperty.getPropertyIntArray("dband", null);
        switch (mapProperty.getPropertyInt("interleave")) {
            case 0: {
                this.interleave = Interleave.BSQ;
                break;
            }
            case 1: {
                this.interleave = Interleave.BIL;
                break;
            }
            case 2: {
                this.interleave = Interleave.BIP;
                break;
            }
            case 3: {
                this.interleave = Interleave.BSQ_COL;
            }
        }
        this.fileUnsigned = mapProperty.getPropertyBoolean("fu", true);
        String string = mapProperty.getPropertyStringUTF("fpath");
        if (string != null) {
            this.file = new File(string);
        }
    }

    @Override
    public void closeConnections() {
        if (this.inStream != null) {
            try {
                this.inStream.close();
                this.inStream = null;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    public void crop(ProgressManager progressManager, File file, int n, int n2, int n3, int n4) throws Exception {
        int[] nArray = this.getDataOrder();
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[]{n2, n, 0};
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int[] nArray4 = this.getDataIndex(n5);
        int[] nArray5 = this.getDataIndex(n6);
        int[] nArray6 = this.getDataIndex(n7);
        int n8 = this.getLayerCount();
        n4 = Math.min(this.getRowCount(), n4);
        int[] nArray7 = new int[]{n4, n3, n8};
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileChannel fileChannel = fileOutputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 * n4 * n8 * 2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        progressManager.setInfoText("Croping file");
        progressManager.setMaximumAndReset(nArray6.length * nArray5.length);
        for (int i = 0; i < nArray7[n7]; ++i) {
            nArray2[n7] = nArray6[i] + nArray3[n7];
            for (int j = 0; j < nArray7[n6]; ++j) {
                nArray2[n6] = nArray5[j] + nArray3[n6];
                for (int k = 0; k < nArray7[n5]; ++k) {
                    nArray2[n5] = nArray4[k] + nArray3[n5];
                    this.setCurrentLayer(nArray2[2]);
                    short s = (short)this.getDirectDoubleAtNoMissing(nArray2[0], nArray2[1]);
                    byteBuffer.putShort(s);
                }
                progressManager.incStep(nArray4.length);
            }
        }
        byteBuffer.position(0);
        fileChannel.write(byteBuffer);
        fileChannel.close();
        fileOutputStream.close();
        this.writeHeader(file, n3, n4, n8);
        File[] fileArray = HdrImageImportInfo.getReferenceFiles(this.file);
        File file2 = fileArray[0];
        File file3 = fileArray[0];
        File[] fileArray2 = new File[]{file3, file2};
        String[] stringArray = new String[]{"whiteref_", "darkref_"};
        if (!this.file.getAbsolutePath().equals(file3.getAbsolutePath()) && !this.file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file4 = fileArray2[i];
                if (!file4.exists()) continue;
                AbstractImportInfo abstractImportInfo = LoadHelper.getImportInfo(null, file4);
                AbstractImportPanel abstractImportPanel = abstractImportInfo.getImportPanel(new ImportClass(new File[]{file4}, 0, false, false), null);
                CellIdentifierModel cellIdentifierModel = abstractImportPanel.getCellIdentifierModel(progressManager, false);
                cellIdentifierModel.crop(progressManager, new File(file.getParentFile(), stringArray[i] + file.getName()), n, 0, n3, Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public int[] getDataOrder() {
        int[] nArray;
        switch (this.interleave) {
            default: {
                throw new MatchException(null, null);
            }
            case BSQ_COL: {
                int[] nArray2 = new int[3];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray = nArray2;
                nArray2[2] = 2;
                break;
            }
            case BSQ: {
                int[] nArray3 = new int[3];
                nArray3[0] = 1;
                nArray3[1] = 0;
                nArray = nArray3;
                nArray3[2] = 2;
                break;
            }
            case BIL: {
                int[] nArray4 = new int[3];
                nArray4[0] = 1;
                nArray4[1] = 2;
                nArray = nArray4;
                nArray4[2] = 0;
                break;
            }
            case BIP: {
                int[] nArray5 = new int[3];
                nArray5[0] = 2;
                nArray5[1] = 1;
                nArray = nArray5;
                nArray5[2] = 0;
            }
        }
        return nArray;
    }

    @Override
    public Interleave getInterleave() {
        return this.interleave;
    }

    @Override
    public File getDataSourceFile() {
        return this.file;
    }

    @Override
    public int[] getDefaultBand() {
        return this.defaultband;
    }

    @Override
    public void setDefaultBand(int[] nArray) {
        this.defaultband = nArray;
    }

    @Override
    public final double getDirectDoubleAtNoMissing(int n, int n2) {
        long l = switch (this.interleave) {
            default -> throw new MatchException(null, null);
            case Interleave.BSQ_COL -> this.imageStart + ((long)this.currentLayer * (long)this.imageWidth * (long)this.imageHeight + (long)(n2 * this.imageHeight) + (long)n) * (long)this.sampleSize;
            case Interleave.BSQ -> this.imageStart + ((long)this.currentLayer * (long)this.imageWidth * (long)this.imageHeight + (long)(n * this.imageWidth) + (long)n2) * (long)this.sampleSize;
            case Interleave.BIL -> this.imageStart + ((long)n * (long)this.imageWidth * (long)this.layerCount + (long)(this.currentLayer * this.imageWidth) + (long)n2) * (long)this.sampleSize;
            case Interleave.BIP -> this.imageStart + ((long)n * (long)this.layerCount * (long)this.imageWidth + (long)(n2 * this.layerCount) + (long)this.currentLayer) * (long)this.sampleSize;
        };
        try {
            if (l < this.cacheStart || l > this.cacheStart + 4096L - (long)this.sampleSize) {
                if (l != this.cacheStart + 4096L) {
                    this.inStream.seek(l);
                }
                this.inStream.read(this.cache);
                this.cacheStart = l;
            }
            int n3 = (int)(l - this.cacheStart);
            switch (this.fileDataType) {
                case 0: {
                    double d = this.correctByteOrderByte(this.cache, n3);
                    if (this.unsigned && d < 0.0) {
                        d += 256.0;
                    }
                    return d;
                }
                case 1: {
                    double d = this.correctByteOrderShort(this.cache, n3);
                    if (this.unsigned && d < 0.0) {
                        d += 65536.0;
                    }
                    return d;
                }
                case 2: {
                    double d = this.correctByteOrderInt(this.cache, n3);
                    if (this.unsigned && d < 0.0) {
                        d += 4.294967296E9;
                    }
                    return d;
                }
                case 3: {
                    double d = this.correctByteOrderLong(this.cache, n3);
                    if (this.unsigned && d < 0.0) {
                        d += 9.223372036854776E18;
                    }
                    return d;
                }
                case 4: {
                    return this.correctByteOrderFloat(this.cache, n3);
                }
                case 5: {
                    return this.correctByteOrderDouble(this.cache, n3);
                }
            }
            return Double.NaN;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public final synchronized FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        double d = this.getDirectDoubleAtNoMissing(n, n2);
        if (Double.isNaN(d)) {
            return fastDecimal.error();
        }
        return fastDecimal.setValue(d);
    }

    @Override
    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.IMAGE;
    }

    @Override
    public String getInformation() {
        StringBuilder stringBuilder = new StringBuilder("<HTML><BODY><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" >");
        if (this.file != null) {
            stringBuilder.append("<TR><TD>File:</TD><TD>").append(this.file.getAbsolutePath()).append("</TD></TR>");
        }
        stringBuilder.append("</TABLE></BODY></HTML>");
        return stringBuilder.toString();
    }

    @Override
    public final int getLayerCount() {
        return this.layerCount;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public File getRootFolder() {
        if (this.file != null) {
            return this.file.getParentFile();
        }
        return null;
    }

    @Override
    public double getSaturatedValue() {
        if (this.unsigned) {
            return this.getSaturatedValueLocal();
        }
        return this.getSaturatedValueLocal() / 2.0;
    }

    public double getSaturatedValueLocal() {
        return switch (this.fileDataType) {
            case 0 -> 256.0;
            case 1 -> 65536.0;
            case 2 -> 4.294967296E9;
            case 3 -> 9.223372036854776E18;
            case 4 -> 3.4028234663852886E38;
            default -> Double.MAX_VALUE;
        };
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        this.getDoubleAt_Transpose(n, n2, this.fastDecimal);
        return String.valueOf(this.fastDecimal.getValue());
    }

    @Override
    public boolean isVisibleInTree() {
        return true;
    }

    @Override
    public void openConnections() throws IOException {
        if (this.file != null) {
            this.inStream = new RandomInputStream(this.file, null);
        }
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyLong("is", this.imageStart);
        randomOutputStream.writePropertyInt("iw", this.imageWidth);
        randomOutputStream.writePropertyInt("ih", this.imageHeight);
        randomOutputStream.writePropertyInt("lc", this.layerCount);
        randomOutputStream.writePropertyByte("fdt", this.fileDataType);
        randomOutputStream.writePropertyInt("ssize", this.sampleSize);
        randomOutputStream.writePropertyIntArray("dband", this.defaultband);
        randomOutputStream.writePropertyInt("interleave", this.interleave.ordinal());
        randomOutputStream.writePropertyBoolean("fu", this.fileUnsigned);
        if (this.file != null) {
            randomOutputStream.writePropertyStringUTF("fpath", this.file.getAbsolutePath());
        }
    }

    @Override
    public final void setCurrentLayer(int n) {
        this.currentLayer = this.flipwavelength ? this.layerCount - n : n;
        this.currentLayer += this.shiftwavelength;
    }

    @Override
    public void setProperties(Properties properties) {
        if (properties != null) {
            if (ScriptHelper.hasKey(properties, "flipwavelength")) {
                this.flipwavelength = ScriptHelper.getPropertyBool(properties, "flipwavelength");
            }
            if (ScriptHelper.hasKey(properties, "shiftwavelength")) {
                this.shiftwavelength = ScriptHelper.getPropertyInt(properties, "shiftwavelength");
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        try {
            this.closeConnections();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    protected final byte correctByteOrderByte(byte[] byArray, int n) {
        return byArray[n];
    }

    protected double correctByteOrderDouble(byte[] byArray, int n) throws IOException {
        return Double.longBitsToDouble(this.correctByteOrderLong(byArray, n));
    }

    protected float correctByteOrderFloat(byte[] byArray, int n) throws IOException {
        return Float.intBitsToFloat(this.correctByteOrderInt(byArray, n));
    }

    protected final int correctByteOrderInt(byte[] byArray, int n) {
        if (this.swapByteOrder) {
            return byArray[n + 3] << 24 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
        }
        return byArray[n] << 24 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    protected final long correctByteOrderLong(byte[] byArray, int n) {
        long l = this.correctByteOrderInt(byArray, n + 4);
        long l2 = this.correctByteOrderInt(byArray, n);
        if (this.swapByteOrder) {
            return l << 32 | l2 & 0xFFFFFFFFL;
        }
        return l2 << 32 | l & 0xFFFFFFFFL;
    }

    protected final short correctByteOrderShort(byte[] byArray, int n) {
        if (this.swapByteOrder) {
            return (short)(byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF);
        }
        return (short)(byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF);
    }

    protected abstract void readHeader() throws IOException;

    private void writeHeader(File file, int n, int n2, int n3) throws Exception {
        int n4;
        FileWriter fileWriter = new FileWriter(file.getParentFile().getAbsolutePath() + IniManager.getFileSeparator() + jopensaveDialog.getFileName(file) + ".hdr");
        CustomBufferedWriter customBufferedWriter = new CustomBufferedWriter(this, fileWriter);
        customBufferedWriter.writeLine("ENVI");
        customBufferedWriter.writeLine("description = { Evince Crop }");
        customBufferedWriter.writeLine("file type = ENVI");
        customBufferedWriter.newLine();
        customBufferedWriter.writeLine("interleave = " + this.interleaveString);
        customBufferedWriter.writeLine("samples = " + n);
        customBufferedWriter.writeLine("lines   = " + n2);
        customBufferedWriter.writeLine("bands   = " + n3);
        if (this.defaultband != null) {
            customBufferedWriter.write("default bands = {");
            for (n4 = 0; n4 < this.defaultband.length; ++n4) {
                customBufferedWriter.write(String.valueOf(this.defaultband[n4]));
                if (n4 == this.defaultband.length - 1) continue;
                customBufferedWriter.write(", ");
            }
            customBufferedWriter.writeLine("}");
        }
        customBufferedWriter.writeLine("header offset = 0");
        customBufferedWriter.write("data type = ");
        customBufferedWriter.writeLine("2");
        customBufferedWriter.writeLine("byte order = 0");
        customBufferedWriter.newLine();
        customBufferedWriter.writeLine("errors = {none}");
        customBufferedWriter.newLine();
        if (this.wavelength != null) {
            customBufferedWriter.writeLine("Wavelength = {");
            for (n4 = 0; n4 < this.wavelength.length; ++n4) {
                customBufferedWriter.writeLine(this.wavelength[n4] + (n4 != this.wavelength.length - 1 ? ", " : ""));
            }
            customBufferedWriter.writeLine("}");
        }
        customBufferedWriter.close();
        fileWriter.close();
    }

    public String getDescription() {
        return this.description;
    }

    public byte getFileDataType() {
        return this.fileDataType;
    }

    public File getHeaderFile() {
        return this.headerFile;
    }

    private class CustomBufferedWriter
    extends BufferedWriter {
        public CustomBufferedWriter(AbstractHeaderDataSource abstractHeaderDataSource, Writer writer) {
            super(writer);
        }

        public void writeLine(String string) throws Exception {
            this.write(string);
            this.newLine();
        }
    }
}

