/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.hdr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.breeze.Interleave;
import se.prediktera.map.dataimport.image.AbstractHeaderDataSource;
import se.prediktera.map.register.RegisterKeyManager;

public class HdrDataSource
extends AbstractHeaderDataSource {
    private static double[] SWIRwavelength = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1000.4, 1006.75, 1013.09, 1019.44, 1025.79, 1032.13, 1038.47, 1044.82, 1051.16, 1057.5, 1063.85, 1070.19, 1076.53, 1082.87, 1089.21, 1095.55, 1101.89, 1108.23, 1114.57, 1120.91, 1127.25, 1133.59, 1139.92, 1146.26, 1152.6, 1158.93, 1165.27, 1171.6, 1177.94, 1184.27, 1190.61, 1196.94, 1203.27, 1209.6, 1215.94, 1222.27, 1228.6, 1234.93, 1241.26, 1247.59, 1253.92, 1260.25, 1266.58, 1272.9, 1279.23, 1285.56, 1291.88, 1298.21, 1304.54, 1310.86, 1317.19, 1323.51, 1329.83, 1336.16, 1342.48, 1348.8, 1355.13, 1361.45, 1367.77, 1374.09, 1380.41, 1386.73, 1393.05, 1399.37, 1405.69, 1412.0, 1418.32, 1424.64, 1430.96, 1437.27, 1443.59, 1449.9, 1456.22, 1462.53, 1468.85, 1475.16, 1481.47, 1487.79, 1494.1, 1500.41, 1506.72, 1513.03, 1519.34, 1525.65, 1531.96, 1538.27, 1544.58, 1550.89, 1557.2, 1563.51, 1569.81, 1576.12, 1582.43, 1588.73, 1595.04, 1601.34, 1607.65, 1613.95, 1620.25, 1626.56, 1632.86, 1639.16, 1645.46, 1651.76, 1658.06, 1664.36, 1670.66, 1676.96, 1683.26, 1689.56, 1695.86, 1702.16, 1708.45, 1714.75, 1721.05, 1727.34, 1733.64, 1739.93, 1746.23, 1752.52, 1758.82, 1765.11, 1771.4, 1777.69, 1783.99, 1790.28, 1796.57, 1802.86, 1809.15, 1815.44, 1821.73, 1828.02, 1834.3, 1840.59, 1846.88, 1853.17, 1859.45, 1865.74, 1872.02, 1878.31, 1884.59, 1890.88, 1897.16, 1903.45, 1909.73, 1916.01, 1922.29, 1928.57, 1934.86, 1941.14, 1947.42, 1953.7, 1959.98, 1966.25, 1972.53, 1978.81, 1985.09, 1991.37, 1997.64, 2003.92, 2010.2, 2016.47, 2022.75, 2029.02, 2035.29, 2041.57, 2047.84, 2054.11, 2060.39, 2066.66, 2072.93, 2079.2, 2085.47, 2091.74, 2098.01, 2104.28, 2110.55, 2116.82, 2123.08, 2129.35, 2135.62, 2141.88, 2148.15, 2154.42, 2160.68, 2166.95, 2173.21, 2179.47, 2185.74, 2192.0, 2198.26, 2204.52, 2210.79, 2217.05, 2223.31, 2229.57, 2235.83, 2242.09, 2248.35, 2254.6, 2260.86, 2267.12, 2273.38, 2279.63, 2285.89, 2292.15, 2298.4, 2304.66, 2310.91, 2317.16, 2323.42, 2329.67, 2335.92, 2342.18, 2348.43, 2354.68, 2360.93, 2367.18, 2373.43, 2379.68, 2385.93, 2392.18, 2398.43, 2404.67, 2410.92, 2417.17, 2423.41, 2429.66, 2435.91, 2442.15, 2448.4, 2454.64, 2460.88, 2467.13, 2473.37, 2479.61, 2485.85, 2492.1, 2498.34, 0.0, 0.0, 0.0};
    private int sampleid = 0;

    public HdrDataSource(File[] fileArray, byte by) throws IOException {
        super(fileArray[0], by);
        String string = jopensaveDialog.getFileExtension(fileArray[0]);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("drw", "dhd");
        hashMap.put("wrw", "whd");
        String string2 = hashMap.containsKey(string.toLowerCase()) ? (String)hashMap.get(string.toLowerCase()) : "hdr";
        this.headerFile = new File(fileArray[0].getParentFile(), jopensaveDialog.getFileName(fileArray[0]) + "." + string2);
        if (!this.headerFile.exists()) {
            this.headerFile = new File(fileArray[0].getParentFile(), fileArray[0].getName() + "." + string2);
        }
        if (!this.headerFile.exists()) {
            throw new IOException("Cannot locate header file");
        }
        this.readHeader();
    }

    public HdrDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        String string = mapProperty.getPropertyStringUTF("hfile");
        if (string != null) {
            this.headerFile = new File(string);
        }
        this.wavelength = mapProperty.getPropertyDoubleArray("wavelength");
        this.bandnames = mapProperty.getPropertyStringUTFArray("bandnames");
    }

    protected HdrDataSource(File file, byte by) throws IOException {
        super(file, by);
    }

    @Override
    public String getLayerName(int n) {
        if (this.wavelength != null) {
            if (n < this.wavelength.length) {
                return String.valueOf(this.wavelength[n]);
            }
            if (this.wavelength.length >= 2) {
                int n2 = this.wavelength.length - 2;
                double d = this.wavelength[n2];
                int n3 = this.wavelength.length - 1;
                double d2 = this.wavelength[n3];
                double d3 = d2 - d;
                int n4 = n - n3;
                return String.valueOf(d2 + d3 * (double)n4);
            }
        }
        if (this.bandnames != null && n < this.bandnames.length) {
            return this.bandnames[n];
        }
        if (RegisterKeyManager.isPredikteraDevelopmentLicense()) {
            int n5 = this.getLayerCount();
            int n6 = SWIRwavelength.length - (n5 - n);
            if (n6 >= 0 && n6 < SWIRwavelength.length) {
                return String.valueOf(SWIRwavelength[n6]);
            }
            return "N/A";
        }
        return "Layer " + (n + 1);
    }

    @Override
    public int getMaskSampleId() {
        return this.sampleid;
    }

    @Override
    public String getName() {
        return "HDR";
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    @Override
    public boolean hasMissing() {
        return false;
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyStringUTF("hfile", this.headerFile != null ? this.headerFile.getAbsolutePath() : null);
        randomOutputStream.writePropertyDoubleArray("wavelength", this.wavelength);
        randomOutputStream.writePropertyStringUTFArray("bandnames", this.bandnames);
    }

    @Override
    protected void readHeader() throws IOException {
        this.readHeader(null);
    }

    protected void readHeader(InputStream inputStream) throws IOException {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        InputStream inputStream2 = inputStream != null ? inputStream : new FileInputStream(this.headerFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        block28: while (true) {
            int n;
            if (bl7) {
                n = 13;
                bl7 = false;
            } else {
                n = bufferedInputStream.read();
            }
            if (bl3) {
                bl3 = false;
                if (n == 10 || n == 13) continue;
            }
            if (bl5 && !bl4 && (n == 32 || n == 9) || bl6 && (n == 10 || n == 13)) continue;
            switch (n) {
                case 61: {
                    string = stringBuilder.toString().trim().toLowerCase();
                    if (string.startsWith(";")) continue block28;
                    stringBuilder = new StringBuilder();
                    bl5 = true;
                    bl6 = true;
                    break;
                }
                case -1: 
                case 10: 
                case 13: {
                    if (!bl) {
                        if (string != null) {
                            object = stringBuilder.toString();
                            if (bl2) {
                                String[] stringArray = ((String)object).split(",");
                                double[] dArray = new double[stringArray.length];
                                try {
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        dArray[i] = Double.parseDouble(stringArray[i].trim());
                                    }
                                    hashMap.put(string, dArray);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    hashMap.put(string, stringArray);
                                }
                            } else {
                                hashMap.put(string, object);
                            }
                        }
                        stringBuilder = new StringBuilder();
                        string = null;
                        bl2 = false;
                    }
                    bl5 = true;
                    bl3 = true;
                    bl4 = false;
                    break;
                }
                case 123: {
                    if (string != null && string.equals("description")) {
                        bl4 = true;
                        break;
                    }
                    bl = true;
                    bl2 = true;
                    break;
                }
                case 125: {
                    bl = false;
                    bl7 = true;
                    break;
                }
                case 44: {
                    if (bl) {
                        bl5 = true;
                    }
                    stringBuilder.append((char)n);
                    break;
                }
                case 34: {
                    bl4 = !bl4;
                    break;
                }
                case 32: {
                    if (string != null && stringBuilder != null && stringBuilder.length() != 0) {
                        if (bl4) {
                            stringBuilder.append((char)n);
                            break;
                        }
                        bl7 = true;
                        break;
                    }
                }
                default: {
                    bl5 = false;
                    bl6 = false;
                    stringBuilder.append((char)n);
                }
            }
            if (n < 0) break;
        }
        bufferedInputStream.close();
        inputStream2.close();
        if (hashMap.containsKey("description")) {
            this.description = hashMap.get("description").toString();
        }
        this.imageStart = 0L;
        this.interleaveString = hashMap.get("interleave").toString().toLowerCase();
        if (this.interleaveString.equals("bsq")) {
            this.interleave = Interleave.BSQ;
        } else if (this.interleaveString.equals("bil")) {
            this.interleave = Interleave.BIL;
        } else if (this.interleaveString.equals("bip")) {
            this.interleave = Interleave.BIP;
        }
        this.columns = this.imageWidth = Integer.parseInt(hashMap.get("samples").toString());
        this.rows = this.imageHeight = Integer.parseInt(hashMap.get("lines").toString());
        this.layerCount = Integer.parseInt(hashMap.get("bands").toString());
        try {
            this.imageStart = Long.parseLong(hashMap.get("header offset").toString());
        }
        catch (Exception exception) {
            this.imageStart = 0L;
        }
        int n = Integer.parseInt(hashMap.get("data type").toString());
        switch (n) {
            case 1: {
                this.fileDataType = 0;
                this.sampleSize = 1;
                this.fileUnsigned = true;
                break;
            }
            case 2: {
                this.fileDataType = 1;
                this.sampleSize = 2;
                this.fileUnsigned = false;
                break;
            }
            case 3: {
                this.fileDataType = (byte)2;
                this.sampleSize = 4;
                this.fileUnsigned = false;
                break;
            }
            case 4: {
                this.fileDataType = (byte)4;
                this.sampleSize = 4;
                this.fileUnsigned = true;
                break;
            }
            case 5: {
                this.fileDataType = (byte)5;
                this.sampleSize = 8;
                this.fileUnsigned = true;
                break;
            }
            case 12: {
                this.fileDataType = 1;
                this.sampleSize = 2;
                this.fileUnsigned = true;
                break;
            }
            case 13: {
                this.fileDataType = (byte)2;
                this.sampleSize = 4;
                this.fileUnsigned = true;
                break;
            }
            case 14: {
                this.fileDataType = (byte)3;
                this.sampleSize = 8;
                this.fileUnsigned = false;
                break;
            }
            case 15: {
                this.fileDataType = (byte)3;
                this.sampleSize = 8;
                this.fileUnsigned = true;
                break;
            }
            default: {
                throw new IOException("Unknown image data type");
            }
        }
        this.dataType = this.fileDataType;
        this.unsigned = this.fileUnsigned;
        if (hashMap.containsKey("byte order") && NiceDataFormat.isNumber((String)(object = hashMap.get("byte order").toString()))) {
            this.swapByteOrder = ((String)object).equals("0");
        }
        if (hashMap.containsKey("sampleid")) {
            this.sampleid = Short.parseShort(hashMap.get("sampleid").toString());
        }
        if (hashMap.containsKey("wavelength") || hashMap.containsKey("band names")) {
            try {
                if (hashMap.containsKey("wavelength")) {
                    object = hashMap.get("wavelength");
                    if (object instanceof double[]) {
                        this.wavelength = (double[])object;
                    } else if (object instanceof String[]) {
                        this.bandnames = (String[])object;
                    }
                } else {
                    this.bandnames = (String[])hashMap.get("band names");
                }
            }
            catch (Exception exception) {
                this.wavelength = null;
            }
        }
        try {
            object = (double[])hashMap.get("default bands");
            if (object != null) {
                this.defaultband = new int[((Object)object).length];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    this.defaultband[i] = (int)object[i];
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.currentLayer = 0;
    }
}

