/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.hdr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpVector;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataexport.AbstractExportInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixByte;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixFloat;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixShort;
import se.prediktera.map.datasetcontainer.matrix.ReferenceMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.ScriptHelper;

public class HdrExportInfo
extends AbstractExportInfo {
    String decription;
    Interleaves interleave = Interleaves.BIL;
    Datatype datatype = Datatype.FLOAT;

    @Override
    public String getDescription() {
        return "ENVI File (*.raw)";
    }

    @Override
    public String getExt() {
        return "raw";
    }

    @Override
    public boolean isImageSave() {
        return true;
    }

    public boolean saveHdr(String string, ProgressManager progressManager, Properties properties) {
        try {
            FoldMatrix foldMatrix;
            AbstractDataMatrix abstractDataMatrix = this.model.getMatrix();
            boolean bl = false;
            if (abstractDataMatrix instanceof FoldMatrix) {
                foldMatrix = (FoldMatrix)abstractDataMatrix;
            } else {
                foldMatrix = new FoldMatrix(abstractDataMatrix);
                bl = true;
            }
            AbstractDataMatrix abstractDataMatrix2 = foldMatrix.getRootReferencedMatrix();
            AbstractDataMatrix abstractDataMatrix3 = null;
            if (abstractDataMatrix2 != null && abstractDataMatrix2.size() > 0 && abstractDataMatrix2 instanceof LayerMatrix) {
                abstractDataMatrix3 = (AbstractDataMatrix)((LayerMatrix)abstractDataMatrix2).get(0);
            }
            this.datatype = abstractDataMatrix3 instanceof MVmatrixByte ? Datatype.BYTE : (abstractDataMatrix3 instanceof MVmatrixShort ? Datatype.SHORT : (abstractDataMatrix3 instanceof MVmatrixFloat ? Datatype.FLOAT : Datatype.DOUBLE));
            if (properties != null) {
                try {
                    String string2;
                    if (ScriptHelper.hasKey(properties, "datatype")) {
                        string2 = ScriptHelper.getProperty(properties, "datatype");
                        this.datatype = string2.equalsIgnoreCase("byte") ? Datatype.BYTE : (string2.equalsIgnoreCase("short") ? Datatype.SHORT : (string2.equalsIgnoreCase("float") ? Datatype.FLOAT : Datatype.DOUBLE));
                    }
                    if (ScriptHelper.hasKey(properties, "dataorder")) {
                        string2 = ScriptHelper.getProperty(properties, "dataorder");
                        if (string2.equalsIgnoreCase("bsq")) {
                            this.interleave = Interleaves.BSQ;
                        } else if (string2.equalsIgnoreCase("bil")) {
                            this.interleave = Interleaves.BIL;
                        } else if (string2.equalsIgnoreCase("bip")) {
                            this.interleave = Interleaves.BIP;
                        } else if (string2.equalsIgnoreCase("bsq_col")) {
                            this.interleave = Interleaves.BSQ_COL;
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
            this.saveHdrHeaderFile(abstractDataMatrix);
            boolean bl2 = this.writeFoldMatrix(foldMatrix, progressManager);
            if (bl) {
                foldMatrix.cleanUp();
            }
            if (!bl2) {
                return false;
            }
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            return false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    @Override
    public boolean supportTableModel(SimpleTableModel simpleTableModel) {
        return simpleTableModel.getMatrix() != null && simpleTableModel.getMatrix().isFoldable();
    }

    public void writeFoldMatrixBIL(ProgressManager progressManager, RandomOutputStream randomOutputStream, FoldMatrix foldMatrix, DataTypeWriter dataTypeWriter) throws IOException {
        int n = foldMatrix.getN();
        int n2 = foldMatrix.getFoldsize();
        int n3 = foldMatrix.getK();
        byte[] byArray = new byte[n2 * n3 * dataTypeWriter.getNumberOfBytes()];
        int[] nArray = foldMatrix.getFNref();
        int n4 = foldMatrix.getYmax();
        AbstractDataMatrix abstractDataMatrix = foldMatrix.getReferencedMatrix();
        progressManager.setMaximumAndReset(n);
        for (int i = 0; i < n; ++i) {
            int n5 = 0;
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n6 = k * n4 + i;
                    if (nArray != null) {
                        n6 = nArray[n6];
                    }
                    dataTypeWriter.putTypeInBuffert(byArray, n5, abstractDataMatrix.getFoldValue(n6, j));
                    n5 += dataTypeWriter.getNumberOfBytes();
                }
            }
            randomOutputStream.write(byArray);
            progressManager.incStep();
        }
    }

    public void writeFoldMatrixBIP(ProgressManager progressManager, RandomOutputStream randomOutputStream, FoldMatrix foldMatrix, DataTypeWriter dataTypeWriter) throws IOException {
        int n = foldMatrix.getN();
        int n2 = foldMatrix.getFoldsize();
        int n3 = foldMatrix.getK();
        int[] nArray = foldMatrix.getFNref();
        int n4 = foldMatrix.getYmax();
        AbstractDataMatrix abstractDataMatrix = foldMatrix.getReferencedMatrix();
        progressManager.setMaximumAndReset(n);
        byte[] byArray = new byte[n2 * n3 * dataTypeWriter.getNumberOfBytes()];
        for (int i = 0; i < n; ++i) {
            int n5 = 0;
            for (int j = 0; j < n3; ++j) {
                int n6 = j * n4 + i;
                if (nArray != null) {
                    n6 = nArray[n6];
                }
                for (int k = 0; k < n2; ++k) {
                    double d = 0.0;
                    if (n6 >= 0) {
                        d = abstractDataMatrix.getFoldValue(n6, k);
                    }
                    dataTypeWriter.putTypeInBuffert(byArray, n5, d);
                    n5 += dataTypeWriter.getNumberOfBytes();
                }
            }
            randomOutputStream.write(byArray);
            progressManager.incStep();
        }
    }

    public void writeFoldMatrixBSQ(ProgressManager progressManager, RandomOutputStream randomOutputStream, FoldMatrix foldMatrix, DataTypeWriter dataTypeWriter) throws IOException {
        int n = foldMatrix.getN();
        int n2 = foldMatrix.getFoldsize();
        int n3 = foldMatrix.getK();
        byte[] byArray = new byte[n3 * n * dataTypeWriter.getNumberOfBytes()];
        int[] nArray = foldMatrix.getFNref();
        int n4 = foldMatrix.getYmax();
        AbstractDataMatrix abstractDataMatrix = foldMatrix.getReferencedMatrix();
        progressManager.setMaximumAndReset(n2);
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    int n6 = k * n4 + j;
                    if (nArray != null) {
                        n6 = nArray[n6];
                    }
                    double d = abstractDataMatrix.getFoldValue(n6, i);
                    dataTypeWriter.putTypeInBuffert(byArray, n5, d);
                    n5 += dataTypeWriter.getNumberOfBytes();
                }
            }
            randomOutputStream.write(byArray);
            progressManager.incStep();
        }
    }

    @Override
    protected void addExportSettings(JPanel jPanel, Properties properties) {
        Datatype[] datatypeArray;
        super.addExportSettings(jPanel, properties);
        JComboBox<Interleaves> jComboBox = new JComboBox<Interleaves>();
        Interleaves[] interleavesArray = Interleaves.values();
        for (Interleaves interleaves : interleavesArray) {
            jComboBox.addItem(interleaves);
        }
        jComboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                properties.setProperty("dataorder", itemEvent.getItem().toString().toLowerCase());
            }
        });
        jComboBox.setSelectedItem((Object)this.interleave);
        jPanel.add((Component)new JLabel("Data order"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add(jComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
        JComboBox jComboBox2 = new JComboBox();
        for (Datatype datatype : datatypeArray = Datatype.values()) {
            jComboBox2.addItem(datatype);
        }
        jComboBox2.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                properties.setProperty("datatype", itemEvent.getItem().toString().toLowerCase());
            }
        });
        jComboBox2.setSelectedItem((Object)this.datatype);
        jPanel.add((Component)new JLabel("Data type"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)jComboBox2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
    }

    @Override
    protected void SaveNow(ProgressManager progressManager) {
        this.saveHdr("MV", progressManager, null);
    }

    @Override
    protected void SaveNow(ProgressManager progressManager, Properties properties) {
        this.saveHdr("MV", progressManager, properties);
    }

    private void saveHdrHeaderFile(AbstractDataMatrix abstractDataMatrix) throws IOException {
        Object object;
        String string = this.file.getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        FileWriter fileWriter = new FileWriter(this.file.getParentFile().getAbsolutePath() + IniManager.getFileSeparator() + string + ".hdr");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write("ENVI");
        bufferedWriter.newLine();
        if (this.decription != null) {
            bufferedWriter.write("description = { " + this.decription + " }");
        } else {
            bufferedWriter.write("description = {}");
        }
        bufferedWriter.newLine();
        bufferedWriter.write("file type = ENVI");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("interleave = " + this.interleave.toString().toLowerCase());
        bufferedWriter.newLine();
        if (abstractDataMatrix instanceof FoldMatrix) {
            bufferedWriter.write("samples = " + abstractDataMatrix.getFoldK());
            bufferedWriter.newLine();
            bufferedWriter.write("lines   = " + abstractDataMatrix.getFoldN());
            bufferedWriter.newLine();
            bufferedWriter.write("bands   = " + abstractDataMatrix.getFoldsize());
            bufferedWriter.newLine();
        } else {
            object = new FoldMatrix(abstractDataMatrix);
            bufferedWriter.write("samples = " + ((FoldMatrix)object).getK());
            bufferedWriter.newLine();
            bufferedWriter.write("lines   = " + ((FoldMatrix)object).getN());
            bufferedWriter.newLine();
            bufferedWriter.write("bands   = " + ((ReferenceMatrix)object).getFoldsize());
            bufferedWriter.newLine();
            ((CleanUpVector)object).cleanUp();
        }
        if (abstractDataMatrix instanceof LayerMatrix) {
            object = ((LayerMatrix)abstractDataMatrix).getDefaultBand();
            bufferedWriter.write("default bands = {");
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    bufferedWriter.write(String.valueOf((int)object[i]));
                    if (i == ((Object)object).length - 1) continue;
                    bufferedWriter.write(", ");
                }
            }
            bufferedWriter.write("}");
            bufferedWriter.newLine();
        }
        bufferedWriter.write("header offset = 0");
        bufferedWriter.newLine();
        bufferedWriter.write("data type = ");
        if (this.datatype == Datatype.BYTE) {
            bufferedWriter.write("1");
        } else if (this.datatype == Datatype.SHORT) {
            bufferedWriter.write("12");
        } else if (this.datatype == Datatype.FLOAT) {
            bufferedWriter.write("4");
        } else {
            bufferedWriter.write("5");
        }
        bufferedWriter.newLine();
        bufferedWriter.write("byte order = 0");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("errors = {none}");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write("Wavelength = {");
        bufferedWriter.newLine();
        for (int i = 0; i < abstractDataMatrix.getFoldsize(); ++i) {
            bufferedWriter.write(abstractDataMatrix.getFoldName(i) + (i != abstractDataMatrix.getFoldsize() - 1 ? ", " : ""));
            bufferedWriter.newLine();
        }
        bufferedWriter.write("}");
        bufferedWriter.newLine();
        bufferedWriter.close();
        fileWriter.close();
    }

    private boolean writeFoldMatrix(FoldMatrix foldMatrix, ProgressManager progressManager) {
        if (foldMatrix.getFoldsize() <= 0) {
            return false;
        }
        DataTypeWriter dataTypeWriter = this.datatype == Datatype.BYTE ? new ByteType() : (this.datatype == Datatype.SHORT ? new ShortType() : (this.datatype == Datatype.FLOAT ? new FloatType() : new DoubleType()));
        try {
            RandomOutputStream randomOutputStream = new RandomOutputStream(this.file, false, progressManager);
            if (this.interleave == Interleaves.BSQ) {
                this.writeFoldMatrixBSQ(progressManager, randomOutputStream, foldMatrix, dataTypeWriter);
            } else if (this.interleave == Interleaves.BIL) {
                this.writeFoldMatrixBIL(progressManager, randomOutputStream, foldMatrix, dataTypeWriter);
            } else {
                this.writeFoldMatrixBIP(progressManager, randomOutputStream, foldMatrix, dataTypeWriter);
            }
            randomOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorHandler.logAndReportException(iOException);
            return false;
        }
        return true;
    }

    private static enum Interleaves {
        BSQ,
        BIL,
        BIP,
        BSQ_COL;

    }

    private static enum Datatype {
        BYTE,
        SHORT,
        FLOAT,
        DOUBLE;

    }

    static interface DataTypeWriter {
        public int getNumberOfBytes();

        public void putTypeInBuffert(byte[] var1, int var2, double var3);
    }

    static class ByteType
    implements DataTypeWriter {
        ByteType() {
        }

        @Override
        public int getNumberOfBytes() {
            return 1;
        }

        @Override
        public void putTypeInBuffert(byte[] byArray, int n, double d) {
            byArray[n] = (byte)d;
        }
    }

    static class ShortType
    implements DataTypeWriter {
        ShortType() {
        }

        @Override
        public int getNumberOfBytes() {
            return 2;
        }

        @Override
        public void putTypeInBuffert(byte[] byArray, int n, double d) {
            short s = (short)d;
            byArray[n + 1] = (byte)(s >> 8 & 0xFF);
            byArray[n] = (byte)s;
        }
    }

    static class FloatType
    implements DataTypeWriter {
        FloatType() {
        }

        @Override
        public int getNumberOfBytes() {
            return 4;
        }

        @Override
        public void putTypeInBuffert(byte[] byArray, int n, double d) {
            int n2 = Float.floatToIntBits((float)d);
            byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
            byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
            byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
            byArray[n] = (byte)n2;
        }
    }

    static class DoubleType
    implements DataTypeWriter {
        DoubleType() {
        }

        @Override
        public int getNumberOfBytes() {
            return 8;
        }

        @Override
        public void putTypeInBuffert(byte[] byArray, int n, double d) {
            long l = Double.doubleToLongBits(d);
            byArray[n + 7] = (byte)(l >> 56 & 0xFFL);
            byArray[n + 6] = (byte)(l >> 48 & 0xFFL);
            byArray[n + 5] = (byte)(l >> 40 & 0xFFL);
            byArray[n + 4] = (byte)(l >> 32 & 0xFFL);
            byArray[n + 3] = (byte)(l >> 24 & 0xFFL);
            byArray[n + 2] = (byte)(l >> 16 & 0xFFL);
            byArray[n + 1] = (byte)(l >> 8 & 0xFFL);
            byArray[n] = (byte)l;
        }
    }
}

