/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.hdr;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.image.hdr.HdrDataSource;
import se.prediktera.map.dataimport.image.hdr.HdrImportPanel;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;
import se.prediktera.map.main.script.ScriptHelper;

public class HdrImageImportInfo
extends AbstractImportInfo {
    public static final String[] hdrExtArray = new String[]{"bil", "bip", "bsq", "raw", "img", "wrw", "drw", "bin", "dat", "envi", "spe", "bpr", ""};
    public static final String DESCRIPTION = "ENVI Files (*.bil, *.bip, *.bsq, *.raw, *.img, *.bin, *.dat, *.envi, *)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String[] getExt() {
        return hdrExtArray;
    }

    @Override
    public boolean requireHeaderFile() {
        return true;
    }

    @Override
    public void setCalibrationProperties(Properties properties, boolean bl) {
        File file;
        File[] fileArray;
        if (this.supportCalibration() && (fileArray = HdrImageImportInfo.getReferenceFiles(file = this.importPanel.getFile())) != null) {
            properties.put("apply", "unitconversion");
            properties.put("nrimages", "2");
            if (bl || !ScriptHelper.hasKey(properties, "file1")) {
                properties.put("file1", fileArray[0].getAbsolutePath());
            }
            if (bl || !ScriptHelper.hasKey(properties, "percentage1")) {
                properties.put("percentage1", "0");
            }
            if (bl || !ScriptHelper.hasKey(properties, "file2")) {
                properties.put("file2", fileArray[1].getAbsolutePath());
            }
            if (bl || !ScriptHelper.hasKey(properties, "percentage2")) {
                properties.put("percentage2", "100");
            }
            if (bl || !ScriptHelper.hasKey(properties, "convertto")) {
                properties.put("convertto", "absorbance");
            }
            if (bl || !ScriptHelper.hasKey(properties, "type")) {
                properties.put("type", "line");
            }
        }
    }

    @Override
    public boolean supportCalibration() {
        return true;
    }

    @Override
    public boolean supportDataSource() {
        return true;
    }

    @Override
    public String toString() {
        return "Hdr";
    }

    @Override
    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        return new HdrImportPanel(importInterface);
    }

    @Override
    public boolean isMultiLayer() {
        return true;
    }

    @Override
    public String getPreviewDescription(File file) {
        CharSequence charSequence;
        HdrDataSource hdrDataSource = new HdrDataSource(new File[]{file}, 0);
        try {
            hdrDataSource.readHeader();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><b>");
            stringBuffer.append(jopensaveDialog.getFileName(file));
            stringBuffer.append("</b><br>");
            stringBuffer.append("<table cellpadding=\"0\">");
            String string = hdrDataSource.getDescription();
            if (string != null) {
                this.addRow(stringBuffer, "Description", string);
            }
            this.addRow(stringBuffer, "Samples", hdrDataSource.getOrigColumnCount());
            this.addRow(stringBuffer, "Lines", hdrDataSource.getOrigRowCount());
            this.addRow(stringBuffer, "Bands", hdrDataSource.getLayerCount());
            this.addRow(stringBuffer, "Interleave", hdrDataSource.getInterleave().toString());
            int[] nArray = hdrDataSource.getDefaultBand();
            if (nArray != null) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("{");
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)charSequence).append(", ");
                    }
                    ((StringBuffer)charSequence).append(nArray[i]);
                }
                ((StringBuffer)charSequence).append("}");
                this.addRow(stringBuffer, "Default band", ((StringBuffer)charSequence).toString());
            }
            this.addRow(stringBuffer, "Data type", DataTypeInterface.TYPE_DESCR[hdrDataSource.getFileDataType()]);
            stringBuffer.append("</table>");
            charSequence = stringBuffer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    hdrDataSource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return super.getPreviewDescription(file);
            }
        }
        hdrDataSource.close();
        return charSequence;
    }

    @Override
    public File getPreviewFile(File file) {
        String string = jopensaveDialog.getFileName(file);
        File file2 = new File(file.getParentFile(), string + "_raw.png");
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(file.getParentFile(), string + ".png");
        if (file3.exists()) {
            return file3;
        }
        return new File(file.getParentFile(), string + ".jpg");
    }

    private void addRow(StringBuffer stringBuffer, String string, double d) {
        this.addRow(stringBuffer, string, NiceDataFormat.toString(d));
    }

    private void addRow(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<tr><td><font size=\"3\">");
        stringBuffer.append(string);
        stringBuffer.append("</font></td><td><font size=\"3\">");
        stringBuffer.append(string2);
        stringBuffer.append("</font></td></tr>");
    }

    public static boolean isHdrFile(File file) {
        if (file != null) {
            String string = jopensaveDialog.getFileExtension(file);
            for (String string2 : hdrExtArray) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static File[] getReferenceFiles(File file) {
        String[][][] stringArrayArray;
        Path path = file.toPath().getParent();
        String string = jopensaveDialog.getFileName(file);
        String string2 = jopensaveDialog.getFileExtension(file).toLowerCase();
        for (String[][] stringArray : stringArrayArray = new String[][][]{{{"", "", "wrw"}, {"", "", "drw"}}, {{"whiteref_", "", string2}, {"darkref_", "", string2}}, {{"", "_whiteref", string2}, {"", "_darkref", string2}}, {{"", "_white", string2}, {"", "_dark", string2}}}) {
            Path path2 = path.resolve(stringArray[1][0] + string + stringArray[1][1] + "." + stringArray[1][2]);
            Path path3 = path.resolve(stringArray[0][0] + string + stringArray[0][1] + "." + stringArray[0][2]);
            if (!Files.exists(path3, new LinkOption[0]) || !Files.exists(path2, new LinkOption[0])) continue;
            return new File[]{path2.toFile(), path3.toFile()};
        }
        return null;
    }
}

