/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.hdr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import se.prediktera.map.common.NiceDataFormat;

public class HdrParser {
    final HashMap<String, String> header = new HashMap();

    public HdrParser(File file) throws IOException {
        this.parseHeader(new BytePos(Files.readAllBytes(file.toPath())));
    }

    public HdrParser(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.close();
        inputStream.close();
    }

    public HdrParser(String string) {
        this.parseHeader(new BytePos(string.getBytes()));
    }

    private void parseHeader(BytePos bytePos) {
        while (bytePos.hasNext()) {
            this.parseVariable(bytePos);
        }
    }

    private void parseVariable(BytePos bytePos) {
        StringBuffer stringBuffer = new StringBuffer();
        while (bytePos.next()) {
            switch (bytePos.getByte()) {
                case 61: {
                    this.addValue(stringBuffer.toString(), this.parseValue(bytePos));
                    return;
                }
                case 10: {
                    this.addValue(stringBuffer.toString(), "");
                    return;
                }
            }
            bytePos.append(stringBuffer);
        }
    }

    private void addValue(String string, String string2) {
        String string3 = string.trim().toLowerCase();
        if (!string3.isEmpty()) {
            this.header.put(string3, string2);
        }
    }

    private String parseValue(BytePos bytePos) {
        StringBuffer stringBuffer = new StringBuffer();
        block6: while (bytePos.next()) {
            switch (bytePos.getByte()) {
                case 34: {
                    stringBuffer.append(this.parseQuote(bytePos));
                    continue block6;
                }
                case 123: {
                    stringBuffer.append(this.parseSection(bytePos));
                    continue block6;
                }
                case 13: {
                    continue block6;
                }
                case 10: {
                    return stringBuffer.toString().trim();
                }
            }
            bytePos.append(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String parseQuote(BytePos bytePos) {
        StringBuffer stringBuffer = new StringBuffer();
        while (bytePos.next()) {
            switch (bytePos.getByte()) {
                case 34: {
                    return stringBuffer.toString();
                }
            }
            bytePos.append(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String parseSection(BytePos bytePos) {
        StringBuffer stringBuffer = new StringBuffer();
        while (bytePos.next()) {
            switch (bytePos.getByte()) {
                case 125: {
                    return stringBuffer.toString();
                }
            }
            bytePos.append(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public Object getDescription() {
        return this.header.get("description");
    }

    public boolean contains(String string) {
        return this.header.containsKey(string);
    }

    public String get(String string) {
        return this.header.get(string);
    }

    public String[] getArray(String string) {
        String string2 = this.header.get(string);
        if (string2 != null) {
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            return stringArray;
        }
        return null;
    }

    public double getNumber(String string) {
        return NiceDataFormat.toNumber(this.get(string));
    }

    public int getInt(String string) {
        return Integer.parseInt(this.get(string));
    }

    public int[] getIntArray(String string) {
        String[] stringArray = this.getArray(string);
        if (stringArray != null) {
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return nArray;
        }
        return null;
    }

    public float[] getFloatArray(String string) {
        String[] stringArray = this.getArray(string);
        if (stringArray != null) {
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
            return fArray;
        }
        return null;
    }

    private static class BytePos {
        private final byte[] bytes;
        private int pos = -1;

        public BytePos(byte[] byArray) {
            this.bytes = byArray;
        }

        public final int getByte() {
            return this.bytes[this.pos];
        }

        public final void append(StringBuffer stringBuffer) {
            stringBuffer.append((char)this.getByte());
        }

        public final boolean next() {
            return ++this.pos < this.bytes.length;
        }

        public boolean hasNext() {
            return this.pos < this.bytes.length;
        }
    }
}

