/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.hdr;

public class ReferenceTarget {
    private final float[] values;

    public ReferenceTarget(float[] fArray) {
        this.values = fArray;
    }

    public float[] getValues() {
        return this.values;
    }

    public float getValue(int n) {
        if (n < this.values.length) {
            return this.values[n];
        }
        return this.values[this.values.length - 1];
    }

    public String toEnviHdrString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("reference target = {\r\n");
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i < this.values.length - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\r\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static ReferenceTarget fromHdr(float[] fArray) {
        if (fArray != null) {
            return new ReferenceTarget(fArray);
        }
        return null;
    }
}

