/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.pam;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.SortedMap;
import java.util.TreeMap;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;

public class PamDataSource
extends AbstractDataSource {
    private PAMImage image;
    private int currentLayer;
    private final File file;

    public PamDataSource(File[] fileArray, byte by) {
        super(by);
        this.file = fileArray[0];
        this.setForceMultiLayer(true);
    }

    @Override
    public void init(ProgressManager progressManager) {
        if (this.image != null) {
            return;
        }
        this.image = PamDataSource.parse(progressManager, this.file, true);
        this.rows = this.image.height;
        this.columns = this.image.width;
        this.dataType = this.image.getDataSize() == 1 ? 0 : 1;
    }

    @Override
    public String getInformation() {
        return null;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 15;
    }

    @Override
    public String getName() {
        return "PAM";
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        return null;
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        return fastDecimal.setValue(this.image.pixels[n][n2][this.currentLayer]);
    }

    @Override
    public double getDirectDoubleAtNoMissing(int n, int n2, int n3) {
        return this.image.pixels[n][n2][n3];
    }

    @Override
    public final void setCurrentLayer(int n) {
        this.currentLayer = n;
    }

    @Override
    public int[] getDataOrder() {
        return new int[]{0, 1, 2};
    }

    @Override
    public final int getLayerCount() {
        return this.image.depth;
    }

    @Override
    public String getLayerName(int n) {
        if (this.image.wavelength != null && n < this.image.wavelength.length) {
            return this.image.wavelength[n];
        }
        return NiceDataFormat.toString(n + 1);
    }

    @Override
    public int[] getDefaultBand() {
        return this.image.defaultBand;
    }

    @Override
    public void setDefaultBand(int[] nArray) {
        this.image.defaultBand = nArray;
    }

    @Override
    public boolean hasMissing() {
        return false;
    }

    @Override
    public boolean supportMultiThread() {
        return true;
    }

    public static PAMImage parse(ProgressManager progressManager, File file, boolean bl) {
        PAMImage pAMImage;
        block41: {
            FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
            try {
                Object[] objectArray;
                String[] stringArray;
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
                StringBuilder stringBuilder = new StringBuilder();
                long l = 0L;
                boolean bl2 = false;
                String string = "";
                while (fileChannel.read(byteBuffer) > 0 && !bl2) {
                    byteBuffer.flip();
                    while (byteBuffer.hasRemaining()) {
                        char c = (char)byteBuffer.get();
                        ++l;
                        stringBuilder.append(c);
                        if (stringBuilder.indexOf("P5") == 0) {
                            string = "P5";
                            stringArray = stringBuilder.toString().split("\\s+");
                            if ((stringArray.length != 4 || !stringBuilder.toString().endsWith("\r\n")) && !stringBuilder.toString().endsWith("\n")) continue;
                            bl2 = true;
                            break;
                        }
                        if (stringBuilder.indexOf("P7") != 0) continue;
                        string = "P7";
                        if (!stringBuilder.toString().endsWith("ENDHDR\r\n") && !stringBuilder.toString().endsWith("ENDHDR\n")) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    byteBuffer.compact();
                }
                PAMImage pAMImage2 = new PAMImage();
                if (string.equals("P5")) {
                    stringArray = stringBuilder.toString().trim().split("\\s+");
                    pAMImage2.width = Integer.parseInt(stringArray[1]);
                    pAMImage2.height = Integer.parseInt(stringArray[2]);
                    pAMImage2.maxVal = Integer.parseInt(stringArray[3]);
                    pAMImage2.depth = 1;
                } else if (string.equals("P7")) {
                    stringArray = stringBuilder.toString().split("\n");
                    block25: for (String object : stringArray) {
                        objectArray = object.split("\\s+");
                        switch (objectArray[0]) {
                            case "WIDTH": {
                                pAMImage2.width = Integer.parseInt(objectArray[1]);
                                continue block25;
                            }
                            case "HEIGHT": {
                                pAMImage2.height = Integer.parseInt(objectArray[1]);
                                continue block25;
                            }
                            case "DEPTH": {
                                pAMImage2.depth = Integer.parseInt(objectArray[1]);
                                continue block25;
                            }
                            case "MAXVAL": {
                                pAMImage2.maxVal = Integer.parseInt(objectArray[1]);
                                continue block25;
                            }
                            case "WAVELENGTH": {
                                pAMImage2.wavelength = objectArray[1].split(";");
                            }
                            case "ENDHDR": {
                                continue block25;
                            }
                            default: {
                                pAMImage2.metadata.put(objectArray[0], objectArray.length > 1 ? objectArray[1] : "");
                            }
                        }
                    }
                } else {
                    throw new RuntimeException("Invalid PAM (P5 or P7) file");
                }
                pAMImage2.depth = (int)Math.max((long)pAMImage2.depth, (file.length() - l) / (long)pAMImage2.width / (long)pAMImage2.height / (long)pAMImage2.getDataSize());
                if (bl) {
                    boolean bl3;
                    progressManager.setInfoText("Reading data");
                    pAMImage2.pixels = new int[pAMImage2.height][pAMImage2.width][pAMImage2.depth];
                    fileChannel.position(l);
                    boolean bl4 = bl3 = pAMImage2.maxVal <= 255;
                    if (string.equals("P5")) {
                        progressManager.setMaximumAndReset(pAMImage2.depth);
                        var12_17 = ByteBuffer.allocate(pAMImage2.width * pAMImage2.height * pAMImage2.getDataSize());
                        for (var13_18 = 0; var13_18 < pAMImage2.depth; ++var13_18) {
                            ((ByteBuffer)var12_17).clear();
                            fileChannel.read((ByteBuffer)var12_17);
                            ((ByteBuffer)var12_17).flip();
                            for (int i = 0; i < pAMImage2.height; ++i) {
                                int[][] nArray = pAMImage2.pixels[i];
                                for (int j = 0; j < pAMImage2.width; ++j) {
                                    nArray[j][var13_18] = bl3 ? ((ByteBuffer)var12_17).get() & 0xFF : ((ByteBuffer)var12_17).getShort() & 0xFFFF;
                                }
                            }
                            progressManager.incStep();
                        }
                    } else {
                        progressManager.setMaximumAndReset(pAMImage2.height);
                        var12_17 = ByteBuffer.allocate(pAMImage2.width * pAMImage2.depth * pAMImage2.getDataSize());
                        for (var13_18 = 0; var13_18 < pAMImage2.height; ++var13_18) {
                            int[][] nArray = pAMImage2.pixels[var13_18];
                            ((ByteBuffer)var12_17).clear();
                            fileChannel.read((ByteBuffer)var12_17);
                            ((ByteBuffer)var12_17).flip();
                            for (int i = 0; i < pAMImage2.width; ++i) {
                                objectArray = nArray[i];
                                for (int j = 0; j < pAMImage2.depth; ++j) {
                                    objectArray[j] = bl3 ? (Object)(((ByteBuffer)var12_17).get() & 0xFF) : (String)(((ByteBuffer)var12_17).getShort() & 0xFFFF);
                                }
                            }
                            progressManager.incStep();
                        }
                    }
                }
                pAMImage = pAMImage2;
                if (fileChannel == null) break block41;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            fileChannel.close();
        }
        return pAMImage;
    }

    public static class PAMImage {
        public int width;
        public int height;
        public int depth;
        public int maxVal;
        public int[][][] pixels;
        public SortedMap<String, String> metadata = new TreeMap<String, String>();
        public int[] defaultBand;
        public String[] wavelength;

        public int getDataSize() {
            return this.maxVal <= 255 ? 1 : 2;
        }
    }
}

