/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.pam;

import java.io.File;
import java.util.Map;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.image.pam.PamDataSource;
import se.prediktera.map.dataimport.image.pam.PamImportPanel;

public class PamImportInfo
extends AbstractImportInfo {
    public static final String[] extArray = new String[]{"pam", "pgm", "ppm", "pnm"};
    public static final String DESCRIPTION = "PAM Files (*.pam, *.pgm, *.ppm, *.pnm)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String[] getExt() {
        return extArray;
    }

    @Override
    public String toString() {
        return "PAM";
    }

    @Override
    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        return new PamImportPanel(importInterface);
    }

    @Override
    public boolean isMultiLayer() {
        return true;
    }

    @Override
    public String getPreviewDescription(File file) {
        try {
            PamDataSource.PAMImage pAMImage = PamDataSource.parse(ProgressManager.createEmpty(), file, false);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body><b>");
            stringBuffer.append(jopensaveDialog.getFileName(file));
            stringBuffer.append("</b><br>");
            stringBuffer.append("<table cellpadding=\"0\">");
            this.addRow(stringBuffer, "Pixels", pAMImage.width);
            this.addRow(stringBuffer, "Lines", pAMImage.height);
            this.addRow(stringBuffer, "Bands", pAMImage.depth);
            this.addRow(stringBuffer, "Max", pAMImage.maxVal);
            for (Map.Entry<String, String> entry : pAMImage.metadata.entrySet()) {
                this.addRow(stringBuffer, entry.getKey(), entry.getValue());
            }
            stringBuffer.append("</table>");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return super.getPreviewDescription(file);
        }
    }

    private void addRow(StringBuffer stringBuffer, String string, double d) {
        this.addRow(stringBuffer, string, NiceDataFormat.toString(d));
    }

    private void addRow(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<tr><td><font size=\"3\">");
        stringBuffer.append(string);
        stringBuffer.append("</font></td><td><font size=\"3\">");
        stringBuffer.append(string2);
        stringBuffer.append("</font></td></tr>");
    }
}

