/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.sac;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.org.apache.tools.zip.ZipEntry;
import se.prediktera.map.common.org.apache.tools.zip.ZipFile;
import se.prediktera.map.dataimport.image.hdr.HdrDataSource;

public class SacDataSource
extends HdrDataSource {
    public static final String CAPTURERAW = "captraw";
    public static final String CAPTUREHEADER = "capthdr";
    public static final String WHITEREFRAW = "wrefraw";
    public static final String WHITEREFHEADER = "wrefHDR";
    public static final String DARKREFRAW = "drefraw";
    public static final String DARKREFHEADER = "drefHDR";
    public static final String LOG = "log";
    public static final String METADATAXML = "mdxml";
    public static final String METADATAXSL = "mdxsl";
    public static final String MANIFEST = "manifest";
    public static final byte CAPTUREDATA = 0;
    public static final byte WHITEBALANCE = 1;
    public static final byte DARKBALANCE = 2;
    private InputStream headerStream;
    HashMap<String, ZipEntry> fileEntries;
    private byte type;

    public SacDataSource(File[] fileArray, byte by) throws IOException {
        this(fileArray, by, 0);
    }

    public SacDataSource(File[] fileArray, byte by, byte by2) throws IOException {
        super(fileArray[0], by);
        this.type = by2;
        this.openConnections();
        this.readHeader(this.headerStream);
    }

    public SacDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    @Override
    public void closeConnections() {
        super.closeConnections();
        if (this.headerStream != null) {
            try {
                this.headerStream.close();
                this.headerStream = null;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    public byte getTreeType() {
        return 8;
    }

    @Override
    public void openConnections() {
        try {
            RandomInputStream randomInputStream;
            ZipEntry zipEntry;
            ZipFile zipFile;
            this.fileEntries = new HashMap();
            try {
                zipFile = new ZipFile(this.file);
            }
            catch (ZipException zipException) {
                throw new IOException("Invalid SAC container");
            }
            SacDataSource.fillFileEntriesFromZipFile(zipFile, this.fileEntries);
            switch (this.type) {
                case 0: {
                    zipEntry = this.fileEntries.get(CAPTURERAW);
                    this.headerStream = zipFile.getInputStream(this.fileEntries.get(CAPTUREHEADER));
                    break;
                }
                case 1: {
                    zipEntry = this.fileEntries.get(WHITEREFRAW);
                    this.headerStream = zipFile.getInputStream(this.fileEntries.get(WHITEREFHEADER));
                    break;
                }
                case 2: {
                    zipEntry = this.fileEntries.get(DARKREFRAW);
                    this.headerStream = zipFile.getInputStream(this.fileEntries.get(DARKREFHEADER));
                    break;
                }
                default: {
                    zipEntry = this.fileEntries.get(CAPTURERAW);
                    this.headerStream = zipFile.getInputStream(this.fileEntries.get(CAPTUREHEADER));
                }
            }
            long l = this.getRawOffset(zipFile, zipEntry);
            if (l == -1L) {
                throw new IOException("Raw data not found; SAC file has been compressed?");
            }
            this.inStream = randomInputStream = new RandomInputStream(this.file, null, l);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    public String toString() {
        return "SAC";
    }

    @Override
    protected void cleanUpChild() {
        this.fileEntries = null;
        this.wavelength = null;
        try {
            this.headerStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUpChild();
    }

    public static void fillFileEntriesFromZipFile(ZipFile zipFile, HashMap<String, ZipEntry> hashMap) {
        hashMap.clear();
        Enumeration enumeration = zipFile.getEntries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            String string = zipEntry.getName();
            if (string.matches("manifest[.]xml")) {
                hashMap.put(MANIFEST, zipEntry);
                continue;
            }
            if (string.matches("metadata/.*xml")) {
                hashMap.put(METADATAXML, zipEntry);
                continue;
            }
            if (string.matches("metadata/.*xsl")) {
                hashMap.put(METADATAXSL, zipEntry);
                continue;
            }
            if (string.matches("capture/.*dhd")) {
                hashMap.put(DARKREFHEADER, zipEntry);
                continue;
            }
            if (string.matches("capture/.*drw")) {
                hashMap.put(DARKREFRAW, zipEntry);
                continue;
            }
            if (string.matches("capture/.*wrw")) {
                hashMap.put(WHITEREFRAW, zipEntry);
                continue;
            }
            if (string.matches("capture/.*whd")) {
                hashMap.put(WHITEREFHEADER, zipEntry);
                continue;
            }
            if (string.matches("capture/.*log")) {
                hashMap.put(LOG, zipEntry);
                continue;
            }
            if (string.matches("capture/.*raw")) {
                hashMap.put(CAPTURERAW, zipEntry);
                continue;
            }
            if (!string.matches("capture/.*hdr")) continue;
            hashMap.put(CAPTUREHEADER, zipEntry);
        }
    }

    private long getRawOffset(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        Class<?> clazz = inputStream.getClass();
        long l = -1L;
        if (inputStream instanceof InflaterInputStream) {
            return -1L;
        }
        try {
            Field field = clazz.getDeclaredField("loc");
            field.setAccessible(true);
            l = field.getLong(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        inputStream.close();
        return l;
    }
}

