/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.sac;

import java.io.File;
import java.util.Properties;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.image.sac.SacImportPanel;

public class SacImageImportInfo
extends AbstractImportInfo {
    File sacFile;
    private byte type = (byte)-1;

    @Override
    public String getDescription() {
        return "SAC file (*.sac)";
    }

    @Override
    public String[] getExt() {
        return new String[]{"sac"};
    }

    @Override
    public void setCalibrationProperties(Properties properties, boolean bl) {
        properties.put("apply", "unitconversion");
        properties.put("nrimages", "2");
        properties.put("file1", this.sacFile.getAbsolutePath());
        properties.put("percentage1", "0");
        properties.put("file2", this.sacFile.getAbsolutePath());
        properties.put("percentage2", "100");
        properties.put("convertto", "absorbance");
        properties.put("type", "line");
    }

    public void setSacType(byte by) {
        this.type = by;
    }

    @Override
    public boolean supportCalibration() {
        return true;
    }

    @Override
    public boolean supportDataSource() {
        return true;
    }

    @Override
    public String toString() {
        return "Sac";
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.sacFile = null;
    }

    @Override
    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        this.sacFile = importInterface.getFiles()[0];
        if (this.type != -1) {
            return new SacImportPanel(importInterface, this.type);
        }
        return new SacImportPanel(importInterface);
    }

    @Override
    public boolean isMultiLayer() {
        return true;
    }
}

