/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.sac;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.ImportWizard;
import se.prediktera.map.dataimport.image.hdr.HdrImportPanel;

public class SacXMLImageImportInfo
extends AbstractImportInfo {
    @Override
    public String getDescription() {
        return "SAC xml file (*.xml)";
    }

    @Override
    public String[] getExt() {
        return new String[]{"xml"};
    }

    @Override
    public boolean supportCalibration() {
        return true;
    }

    @Override
    public String toString() {
        return "Xml";
    }

    @Override
    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        ImportWizard importWizard = (ImportWizard)importInterface;
        File file = this.getFileLocationFromXml(this.getXmlFile(importWizard.getFiles()[0]), "capture", "raw");
        if (file == null) {
            throw new IllegalArgumentException("Incorrect XML file");
        }
        importWizard.getFiles()[0] = file;
        return new HdrImportPanel(importInterface);
    }

    private File getXmlFile(File file) {
        if (file.isDirectory()) {
            return new File(file, "manifest.xml");
        }
        return file;
    }

    @Override
    public boolean isMultiLayer() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private File getFileLocationFromXml(File file, String string, String string2) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            InputSource inputSource = new InputSource(fileInputStream);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/", inputSource, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equalsIgnoreCase("manifest")) continue;
                    NodeList nodeList3 = node2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Object object;
                        Node node3 = nodeList3.item(k);
                        if (!node3.getNodeName().equals("file")) continue;
                        boolean bl = false;
                        boolean bl2 = false;
                        for (int i2 = 0; i2 < node3.getAttributes().getLength(); ++i2) {
                            object = node3.getAttributes().item(i2);
                            if (object.getNodeName().equalsIgnoreCase("extension") && object.getNodeValue().equalsIgnoreCase(string2)) {
                                bl = true;
                            }
                            if (!object.getNodeName().equalsIgnoreCase("type") || !object.getNodeValue().equalsIgnoreCase(string)) continue;
                            bl2 = true;
                        }
                        if (!bl2 || !bl) continue;
                        File file2 = new File(file.getParent() + "\\" + node3.getFirstChild().getNodeValue());
                        object = file2.exists() ? file2 : null;
                        return object;
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        return null;
    }

    @Override
    public boolean accepts(File file) {
        if (file.isDirectory() && SacXMLImageImportInfo.isSpecimFolder(file)) {
            return true;
        }
        return file.getName().equalsIgnoreCase("manifest.xml");
    }

    @Override
    public File getPreviewFile(File file) {
        return this.getFileLocationFromXml(this.getXmlFile(file), "preview", "png");
    }

    @Override
    public String getPreviewDescription(File file) {
        try {
            File file2 = this.getXmlFile(file);
            File file3 = file2.getParentFile();
            String string = "<html><body><b>" + file3.getName();
            string = string + "</b><br>";
            string = string + "<table cellpadding=\"0\">";
            string = string + this.printMetadataList(file3);
            string = string + "</table>";
            return string;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            return "Error parsing file";
        }
    }

    private String printMetadataList(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        File file2 = this.getMetadataFile(file);
        List<MetaData> list = this.readProperties(file2);
        if (list.size() > 0) {
            stringBuilder.append("<tr><td colspan=\"3\"><font size=\"3\"><b>");
            stringBuilder.append("Metadata:");
            stringBuilder.append("</b></font></td></tr>");
            for (MetaData metaData : list) {
                stringBuilder.append("<tr><td width=\"10px\"></td>");
                stringBuilder.append("<td><font size=\"3\">");
                stringBuilder.append(metaData.key.replace(" ", "&nbsp;"));
                stringBuilder.append(" </font></td><td><font size=\"3\">");
                stringBuilder.append(metaData.value);
                stringBuilder.append("</font></td></tr>");
            }
        }
        return stringBuilder.toString();
    }

    private File getMetadataFile(File file) {
        File file2 = new File(file, "manifest.xml");
        if (file2.exists()) {
            return file2;
        }
        return new File(file, "metadata/" + file.getName() + ".xml");
    }

    private List<MetaData> readProperties(File file) {
        ArrayList<MetaData> arrayList = new ArrayList<MetaData>();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            InputSource inputSource = new InputSource(fileInputStream);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/", inputSource, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equalsIgnoreCase("properties")) continue;
                    NodeList nodeList3 = node2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Node node3 = nodeList3.item(k);
                        if (!node3.getNodeName().equals("header") && !node3.getNodeName().equals("userdefined")) continue;
                        NodeList nodeList4 = node3.getChildNodes();
                        for (int i2 = 0; i2 < nodeList4.getLength(); ++i2) {
                            Node node4;
                            Node node5 = nodeList4.item(i2);
                            NamedNodeMap namedNodeMap = node5.getAttributes();
                            if (namedNodeMap == null || (node4 = namedNodeMap.getNamedItem("field")) == null) continue;
                            arrayList.add(new MetaData(node4.getNodeValue(), node5.getTextContent()));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        return arrayList;
    }

    public static boolean isSpecimFolder(File file) {
        File file2 = new File(file, "manifest.xml");
        File file3 = new File(file, "capture");
        return file2.exists() && file3.exists();
    }

    public static class MetaData {
        public String key;
        public String value;

        public MetaData(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

