/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.dataimport.image.sc;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.dataimport.FastDecimal;

public class ScDataSource
extends AbstractDataSource {
    private static final String FILE_IDENTIFIER = "TELOPS_HSI_FILE";
    private ScImage image;
    private int currentLayer;
    private final File file;

    public ScDataSource(File[] fileArray, byte by) {
        super(by);
        this.file = fileArray[0];
        this.setForceMultiLayer(true);
    }

    @Override
    public void init(ProgressManager progressManager) {
        if (this.image != null) {
            return;
        }
        this.image = ScDataSource.parse(progressManager, this.file, true);
        this.rows = this.image.height;
        this.columns = this.image.width;
        this.dataType = 4;
    }

    @Override
    public String getInformation() {
        return null;
    }

    @Override
    public byte getNodeType() {
        return 5;
    }

    @Override
    public byte getTreeType() {
        return 16;
    }

    @Override
    public String getName() {
        return "SC";
    }

    @Override
    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    @Override
    public Object getValueAt_Transpose(int n, int n2) {
        return null;
    }

    @Override
    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        return fastDecimal.setValue(this.image.pixels[n][n2][this.currentLayer]);
    }

    @Override
    public double getDirectDoubleAtNoMissing(int n, int n2, int n3) {
        return this.image.pixels[n][n2][n3];
    }

    @Override
    public final void setCurrentLayer(int n) {
        this.currentLayer = n;
    }

    @Override
    public int[] getDataOrder() {
        return new int[]{0, 1, 2};
    }

    @Override
    public final int getLayerCount() {
        return this.image.numBands;
    }

    @Override
    public String getLayerName(int n) {
        if (this.image.wavelength != null && n < this.image.wavelength.length) {
            return this.image.wavelength[n];
        }
        return NiceDataFormat.toString(n + 1);
    }

    @Override
    public int[] getDefaultBand() {
        return this.image.defaultband;
    }

    @Override
    public void setDefaultBand(int[] nArray) {
        this.image.defaultband = nArray;
    }

    @Override
    public boolean hasMissing() {
        return false;
    }

    @Override
    public boolean supportMultiThread() {
        return true;
    }

    public static ScImage parse(ProgressManager progressManager, File file, boolean bl) {
        Iterator<PayloadInfo> iterator;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            byte[] byArray = new byte[16];
            randomAccessFile.readFully(byArray);
            String string = new String(byArray).trim();
            if (!string.equals(FILE_IDENTIFIER)) {
                throw new IOException("Invalid file format");
            }
            byte by = randomAccessFile.readByte();
            byte by2 = randomAccessFile.readByte();
            byte by3 = randomAccessFile.readByte();
            int n = Integer.reverseBytes(randomAccessFile.readInt());
            byte by4 = randomAccessFile.readByte();
            byte by5 = randomAccessFile.readByte();
            byte by6 = randomAccessFile.readByte();
            byte by7 = randomAccessFile.readByte();
            byte by8 = randomAccessFile.readByte();
            byte by9 = randomAccessFile.readByte();
            long l = Long.reverseBytes(randomAccessFile.readLong());
            int n2 = Integer.reverseBytes(randomAccessFile.readInt());
            randomAccessFile.skipBytes(23);
            ScImage scImage = null;
            List<PayloadInfo> list = ScDataSource.readPayloadInfos(randomAccessFile, n2);
            for (PayloadInfo payloadInfo : list) {
                if (!payloadInfo.isData()) continue;
                randomAccessFile.seek(payloadInfo.start());
                byte by10 = randomAccessFile.readByte();
                byte by11 = randomAccessFile.readByte();
                byte by12 = randomAccessFile.readByte();
                byte by13 = randomAccessFile.readByte();
                int n3 = Integer.reverseBytes(randomAccessFile.readInt());
                long l2 = Long.reverseBytes(randomAccessFile.readLong());
                double d = Double.longBitsToDouble(Long.reverseBytes(randomAccessFile.readLong()));
                double d2 = Double.longBitsToDouble(Long.reverseBytes(randomAccessFile.readLong()));
                int n4 = Integer.reverseBytes(randomAccessFile.readInt());
                int n5 = Integer.reverseBytes(randomAccessFile.readInt());
                int n6 = Short.reverseBytes(randomAccessFile.readShort());
                int n7 = Short.reverseBytes(randomAccessFile.readShort());
                short s = Short.reverseBytes(randomAccessFile.readShort());
                short s2 = Short.reverseBytes(randomAccessFile.readShort());
                byte by14 = randomAccessFile.readByte();
                byte by15 = randomAccessFile.readByte();
                byte by16 = randomAccessFile.readByte();
                byte by17 = randomAccessFile.readByte();
                randomAccessFile.skipBytes(12);
                if (scImage == null) {
                    scImage = new ScImage();
                    scImage.width = n6;
                    scImage.height = n7;
                    scImage.numBands = n4;
                    scImage.wavelength = new String[scImage.numBands];
                    double d3 = d;
                    for (int i = 0; i < scImage.numBands; ++i) {
                        scImage.wavelength[n4 - i - 1] = NiceDataFormat.toString(ScDataSource.convertWavenumberToWavelength(d3), 8);
                        d3 += d2;
                    }
                }
                if (!bl) continue;
                if (scImage.pixels == null) {
                    scImage.pixels = new float[n7][n6][n4];
                }
                int n8 = n6 * n4 * (by14 == 0 ? 4 : 8);
                byte[] byArray2 = new byte[n8];
                ByteBuffer byteBuffer = ByteBuffer.allocate(n8).order(ByteOrder.LITTLE_ENDIAN);
                for (int i = 0; i < n7; ++i) {
                    randomAccessFile.readFully(byArray2);
                    byteBuffer.clear();
                    byteBuffer.put(byArray2);
                    byteBuffer.flip();
                    for (int j = 0; j < n6; ++j) {
                        float[] fArray = scImage.pixels[i][j];
                        for (int k = n4 - 1; k >= 0; --k) {
                            fArray[k] = by14 == 0 ? byteBuffer.getFloat() : (float)byteBuffer.getDouble();
                            if (!Double.isNaN(fArray[k])) continue;
                            fArray[k] = 0.0f;
                        }
                    }
                }
            }
            iterator = scImage;
        }
        catch (Throwable throwable) {
            try {
                try {
                    randomAccessFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        randomAccessFile.close();
        return iterator;
    }

    public static double convertWavenumberToWavelength(double d) {
        return 1.0E7 / d;
    }

    private static List<PayloadInfo> readPayloadInfos(RandomAccessFile randomAccessFile, int n) throws IOException {
        ArrayList<PayloadInfo> arrayList = new ArrayList<PayloadInfo>();
        for (int i = 0; i < n; ++i) {
            byte by = randomAccessFile.readByte();
            int n2 = Integer.reverseBytes(randomAccessFile.readInt());
            int n3 = Integer.reverseBytes(randomAccessFile.readInt());
            arrayList.add(new PayloadInfo(by, n2, n3));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        File file = new File("E:\\Telops\\MWIR data\\Telops_ActualTarget_PostProcessedSpectralReflectance.radiance.sc");
        ScImage scImage = ScDataSource.parse(ProgressManager.createEmpty(), file, true);
        System.out.println("Width: " + scImage.width);
        System.out.println("Height: " + scImage.height);
        System.out.println("Number of Bands: " + scImage.numBands);
        System.out.println("Wavelength: " + scImage.wavelength[0] + " - " + scImage.wavelength[scImage.numBands - 1]);
        if (scImage.pixels != null) {
            System.out.println("Spectral Data at (0, 0, 0): " + scImage.pixels[0][0][0]);
        }
    }

    public static class ScImage {
        public int width;
        public int height;
        public int numBands;
        public float[][][] pixels;
        public int[] defaultband;
        public String[] wavelength;
    }

    private record PayloadInfo(byte type, int size, int start) {
        public boolean isData() {
            return this.type == 101 || this.type == 103 || this.type == 104;
        }
    }
}

